/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.operations.FeatureDescriptor;
import org.eclipse.epp.internal.mpc.ui.wizards.InstallProfile;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionModel {
    private final Map<CatalogItem, Operation> itemToOperation = new HashMap<CatalogItem, Operation>();
    private List<CatalogItemEntry> entries;
    private final InstallProfile installProfile;

    public SelectionModel(InstallProfile installProfile) {
        this.installProfile = installProfile;
    }

    public void select(CatalogItem item, Operation operation) {
        boolean changed = false;
        if (operation == null || Operation.NONE == operation) {
            if (this.itemToOperation.remove(item) != Operation.NONE) {
                changed = true;
            }
            if (this.entries != null) {
                Iterator<CatalogItemEntry> it = this.entries.iterator();
                while (it.hasNext()) {
                    CatalogItemEntry entry = it.next();
                    if (!entry.getItem().equals(item)) continue;
                    it.remove();
                }
            }
        } else {
            Operation previous = this.itemToOperation.put(item, operation);
            if (previous != operation) {
                changed = true;
                if (this.entries != null) {
                    Iterator<CatalogItemEntry> it = this.entries.iterator();
                    while (it.hasNext()) {
                        CatalogItemEntry entry = it.next();
                        if (!entry.getItem().equals(item)) continue;
                        it.remove();
                    }
                    CatalogItemEntry itemEntry = this.createItemEntry(item, operation);
                    this.entries.add(itemEntry);
                }
            }
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    public List<CatalogItemEntry> getCatalogItemEntries() {
        if (this.entries == null) {
            ArrayList<CatalogItemEntry> entries = new ArrayList<CatalogItemEntry>();
            for (Map.Entry<CatalogItem, Operation> entry : this.itemToOperation.entrySet()) {
                CatalogItem item = entry.getKey();
                Operation operation = entry.getValue();
                CatalogItemEntry itemEntry = this.createItemEntry(item, operation);
                entries.add(itemEntry);
            }
            this.entries = entries;
        }
        return this.entries;
    }

    public CatalogItemEntry createItemEntry(CatalogItem item, Operation operation) {
        CatalogItemEntry itemEntry = new CatalogItemEntry(item, operation);
        this.computeChildren(itemEntry);
        return itemEntry;
    }

    private void computeChildren(CatalogItemEntry itemEntry) {
        ArrayList<FeatureEntry> children = new ArrayList<FeatureEntry>();
        for (String iu : itemEntry.getItem().getInstallableUnits()) {
            FeatureEntry featureEntry = new FeatureEntry(itemEntry, new FeatureDescriptor(iu));
            featureEntry.setInstalled(this.computeInstalled(featureEntry));
            this.computeInitialChecked(featureEntry);
            children.add(featureEntry);
        }
        itemEntry.children = children;
    }

    private boolean computeInstalled(FeatureEntry entry) {
        Set<String> installedFeatures = this.installProfile.getInstalledFeatures();
        return installedFeatures.contains(entry.featureDescriptor.getId()) || installedFeatures.contains(entry.featureDescriptor.getSimpleId());
    }

    private void computeInitialChecked(FeatureEntry entry) {
        Operation operation = entry.parent.operation;
        if (operation == Operation.CHECK_FOR_UPDATES) {
            if (entry.isInstalled()) {
                entry.checked = true;
            }
        } else {
            entry.checked = true;
        }
    }

    public Map<CatalogItem, Operation> getItemToOperation() {
        return Collections.unmodifiableMap(this.itemToOperation);
    }

    public void selectionChanged() {
    }

    public Set<FeatureDescriptor> getSelectedFeatureDescriptors() {
        HashSet<FeatureDescriptor> featureDescriptors = new HashSet<FeatureDescriptor>();
        for (CatalogItemEntry entry : this.getCatalogItemEntries()) {
            for (FeatureEntry featureEntry : entry.getChildren()) {
                if (!featureEntry.isChecked()) continue;
                featureDescriptors.add(featureEntry.getFeatureDescriptor());
            }
        }
        return Collections.unmodifiableSet(featureDescriptors);
    }

    public Set<CatalogItem> getSelectedCatalogItems() {
        HashSet<CatalogItem> items = new HashSet<CatalogItem>();
        for (CatalogItemEntry entry : this.getCatalogItemEntries()) {
            for (FeatureEntry featureEntry : entry.getChildren()) {
                if (!featureEntry.isChecked()) continue;
                items.add(entry.item);
            }
        }
        return Collections.unmodifiableSet(items);
    }

    public Operation getOperation(CatalogItem item) {
        Operation operation = this.itemToOperation.get(item);
        return operation == null ? Operation.NONE : operation;
    }

    public boolean computeProvisioningOperationViable() {
        if (this.getSelectedFeatureDescriptors().isEmpty()) {
            return false;
        }
        IStatus status = this.computeProvisioningOperationViability();
        if (status != null) {
            switch (status.getSeverity()) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public IStatus computeProvisioningOperationViability() {
        Set<FeatureDescriptor> selectedFeatureDescriptors = this.getSelectedFeatureDescriptors();
        if (selectedFeatureDescriptors.isEmpty()) {
            return null;
        }
        Map<Operation, List<CatalogItem>> operationToItem = this.computeOperationToItem();
        if (operationToItem.size() == 1) {
            Map.Entry<Operation, List<CatalogItem>> entry = operationToItem.entrySet().iterator().next();
            return new Status(1, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.SelectionModel_count_selectedFor_operation, (Object)(entry.getValue().size() == 1 ? Messages.SelectionModel_oneSolution : NLS.bind((String)Messages.SelectionModel_countSolutions, (Object)entry.getValue().size())), (Object)entry.getKey().getLabel()));
        }
        if (operationToItem.size() == 2 && operationToItem.containsKey((Object)Operation.INSTALL) && operationToItem.containsKey((Object)Operation.CHECK_FOR_UPDATES)) {
            int count = 0;
            for (List<CatalogItem> items : operationToItem.values()) {
                count += items.size();
            }
            return new Status(1, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.SelectionModel_countSolutionsSelectedForInstallUpdate, (Object)count));
        }
        if (!(operationToItem.size() <= 1 || operationToItem.size() == 2 && operationToItem.containsKey((Object)Operation.INSTALL) && operationToItem.containsKey((Object)Operation.CHECK_FOR_UPDATES))) {
            return new Status(4, "org.eclipse.epp.mpc.ui", Messages.SelectionModel_cannotInstallRemoveConcurrently);
        }
        return null;
    }

    private Map<Operation, List<CatalogItem>> computeOperationToItem() {
        Map<CatalogItem, Operation> itemToOperation = this.getItemToOperation();
        HashMap<Operation, List<CatalogItem>> catalogItemByOperation = new HashMap<Operation, List<CatalogItem>>();
        for (Map.Entry<CatalogItem, Operation> entry : itemToOperation.entrySet()) {
            if (entry.getValue() == Operation.NONE) continue;
            ArrayList<CatalogItem> list = (ArrayList<CatalogItem>)catalogItemByOperation.get((Object)entry.getValue());
            if (list == null) {
                list = new ArrayList<CatalogItem>();
                catalogItemByOperation.put(entry.getValue(), list);
            }
            list.add(entry.getKey());
        }
        return catalogItemByOperation;
    }

    public void clear() {
        this.itemToOperation.clear();
        this.entries = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CatalogItemEntry {
        private final CatalogItem item;
        private final Operation operation;
        private List<FeatureEntry> children;

        private CatalogItemEntry(CatalogItem item, Operation operation) {
            this.item = item;
            this.operation = operation;
        }

        public CatalogItem getItem() {
            return this.item;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public List<FeatureEntry> getChildren() {
            return this.children;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CatalogItemEntry other = (CatalogItemEntry)obj;
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }

    public class FeatureEntry {
        private final CatalogItemEntry parent;
        private FeatureDescriptor featureDescriptor;
        private boolean checked;
        private boolean installed;

        private FeatureEntry(CatalogItemEntry parent, FeatureDescriptor featureDescriptor) {
            this.parent = parent;
            this.featureDescriptor = featureDescriptor;
        }

        public FeatureDescriptor getFeatureDescriptor() {
            return this.featureDescriptor;
        }

        public void setFeatureDescriptor(FeatureDescriptor featureDescriptor) {
            if (featureDescriptor != null && this.featureDescriptor != null && !this.featureDescriptor.getId().equals(featureDescriptor.getId())) {
                throw new IllegalStateException();
            }
            this.featureDescriptor = featureDescriptor;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
            SelectionModel.this.selectionChanged();
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public void setInstalled(boolean installed) {
            this.installed = installed;
        }

        public CatalogItemEntry getParent() {
            return this.parent;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.featureDescriptor == null ? 0 : this.featureDescriptor.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureEntry other = (FeatureEntry)obj;
            if (this.featureDescriptor == null ? other.featureDescriptor != null : !this.featureDescriptor.equals(other.featureDescriptor)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }
    }
}

