/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceUrlHandler;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.NewsViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModelStateSerializer;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsUrlHandler
extends MarketplaceUrlHandler
implements LocationListener,
ProgressListener {
    private final Set<String> documentLinks = new HashSet<String>();
    private final NewsViewer viewer;

    public NewsUrlHandler(NewsViewer viewer) {
        this.viewer = viewer;
    }

    public void changed(LocationEvent event) {
        this.updatePageLinks();
    }

    private void updatePageLinks() {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Object[] links = (Object[])NewsUrlHandler.this.viewer.getBrowser().evaluate("var links = document.links;var hrefs = Array();for (var i=0; i<links.length; i++) {   links[i].target='_self';   hrefs[i]=links[i].href;};return hrefs");
                if (links != null) {
                    NewsUrlHandler.this.documentLinks.clear();
                    Object[] objectArray = links;
                    int n = links.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object link = objectArray[n2];
                        NewsUrlHandler.this.documentLinks.add(link.toString());
                        ++n2;
                    }
                }
            }
        });
    }

    public void changing(LocationEvent event) {
        if (!event.doit) {
            return;
        }
        String newLocation = event.location;
        boolean handled = this.handleUri(newLocation);
        if (handled) {
            event.doit = false;
        } else {
            String currentLocation = this.viewer.getBrowser().getUrl();
            if (this.isNavigation(currentLocation, newLocation)) {
                event.doit = false;
                this.viewer.getWizard().openUrl(newLocation);
            }
        }
    }

    private boolean isNavigation(String currentLocation, String newLocation) {
        if (NewsUrlHandler.eq(currentLocation, newLocation) || newLocation.startsWith("javascript:") || "about:blank".equals(newLocation) || "about:blank".equals(currentLocation)) {
            return false;
        }
        if (!this.documentLinks.isEmpty() && !this.documentLinks.contains(newLocation)) {
            return false;
        }
        return !NewsUrlHandler.isSameLocation(currentLocation, newLocation);
    }

    static boolean isSameLocation(String currentLocation, String newLocation) {
        try {
            URI currentUri = new URI(currentLocation);
            URI newUri = new URI(newLocation);
            return NewsUrlHandler.equalsIgnoreFragment(currentUri, newUri);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    static boolean equalsIgnoreFragment(URI currentLocation, URI newLocation) {
        return NewsUrlHandler.eq(currentLocation.getHost(), newLocation.getHost()) && NewsUrlHandler.eq(currentLocation.getPath(), newLocation.getPath()) && currentLocation.getPort() == newLocation.getPort() && NewsUrlHandler.eq(currentLocation.getAuthority(), newLocation.getAuthority()) && NewsUrlHandler.eq(currentLocation.getScheme(), newLocation.getScheme()) && NewsUrlHandler.eq(currentLocation.getQuery(), newLocation.getQuery());
    }

    static boolean eq(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    @Override
    protected boolean handleSearch(CatalogDescriptor descriptor, String url, String searchString, Map<String, String> params) {
        MarketplaceWizard marketplaceWizard = this.viewer.getWizard();
        String filterParam = params.get("filter");
        String[] filters = filterParam.split(" ");
        Category searchCategory = null;
        Market searchMarket = null;
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (filter.startsWith("tid:")) {
                String id = filter.substring("tid:".length());
                List catalogCategories = marketplaceWizard.getCatalog().getCategories();
                for (CatalogCategory catalogCategory : catalogCategories) {
                    if (!(catalogCategory instanceof MarketplaceCategory)) continue;
                    MarketplaceCategory marketplaceCategory = (MarketplaceCategory)catalogCategory;
                    List<Market> markets = marketplaceCategory.getMarkets();
                    for (Market market : markets) {
                        if (id.equals(market.getId())) {
                            searchMarket = market;
                            continue;
                        }
                        List categories = market.getCategory();
                        for (Category category : categories) {
                            if (!id.equals(category.getId())) continue;
                            searchCategory = category;
                        }
                    }
                }
            }
            ++n2;
        }
        marketplaceWizard.getCatalogPage().search(descriptor, searchMarket, searchCategory, searchString);
        return true;
    }

    @Override
    protected boolean handleRecent(CatalogDescriptor descriptor, String url) {
        this.viewer.getWizard().getCatalogPage().show(descriptor, MarketplaceViewer.ContentType.RECENT);
        return true;
    }

    @Override
    protected boolean handlePopular(CatalogDescriptor descriptor, String url) {
        this.viewer.getWizard().getCatalogPage().show(descriptor, MarketplaceViewer.ContentType.POPULAR);
        return true;
    }

    @Override
    protected boolean handleNode(CatalogDescriptor descriptor, String url, Node node) {
        this.viewer.getWizard().getCatalogPage().show(descriptor, Collections.singleton(node));
        return true;
    }

    @Override
    protected boolean handleInstallRequest(final MarketplaceUrlHandler.SolutionInstallationInfo installInfo, String url) {
        final String installId = installInfo.getInstallId();
        if (installId == null) {
            return false;
        }
        final MarketplaceWizard wizard = this.viewer.getWizard();
        try {
            wizard.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Display display;
                    HashMap<String, Operation> nodeIdToOperation = new HashMap<String, Operation>();
                    try {
                        nodeIdToOperation.put(URLDecoder.decode(installId, "UTF-8"), Operation.INSTALL);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalStateException();
                    }
                    final SelectionModel selectionModel = NewsUrlHandler.this.viewer.getWizard().getSelectionModel();
                    SelectionModelStateSerializer stateSerializer = new SelectionModelStateSerializer(wizard.getCatalog(), selectionModel);
                    stateSerializer.deserialize(monitor, installId, nodeIdToOperation);
                    if (selectionModel.getItemToOperation().size() > 0 && !(display = wizard.getShell().getDisplay()).isDisposed()) {
                        display.asyncExec(new Runnable(){

                            public void run() {
                                IWizardPage currentPage;
                                MarketplacePage catalogPage = wizard.getCatalogPage();
                                if (catalogPage == (currentPage = wizard.getContainer().getCurrentPage())) {
                                    catalogPage.getViewer().setSelection((IStructuredSelection)new StructuredSelection(selectionModel.getSelectedCatalogItems().toArray()));
                                    catalogPage.show(installInfo.getCatalogDescriptor(), MarketplaceViewer.ContentType.SELECTION);
                                    IWizardPage nextPage = wizard.getNextPage((IWizardPage)catalogPage);
                                    if (nextPage != null && catalogPage.isPageComplete()) {
                                        wizard.getContainer().showPage(nextPage);
                                    }
                                }
                            }
                        });
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            IStatus status = MarketplaceClientUi.computeStatus(e, Messages.MarketplaceViewer_unexpectedException);
            StatusManager.getManager().handle(status, 7);
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return false;
    }

    public void completed(ProgressEvent event) {
        this.updatePageLinks();
    }

    public void changed(ProgressEvent event) {
    }
}

