/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSLiteral.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDFS Literal</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral#getLexicalForm <em>lexicalForm</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSLiteral()
 * @model
 * @generated
 */
public interface RDFSLiteral extends RDFSResource, Cloneable {
	/**
	 * Returns the value of the '<em><b>lexicalForm</b></em>' attribute.
	 * The default value is <code>""</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lexical Form</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>lexicalForm</em>' attribute.
	 * @see #setLexicalForm(String)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFSLiteral_LexicalForm()
	 * @model default="" required="true"
	 * @generated
	 */
	String getLexicalForm();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFSLiteral#getLexicalForm <em>lexicalForm</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>lexicalForm</em>' attribute.
	 * @see #getLexicalForm()
	 * @generated
	 */
	void setLexicalForm(String value);

	/**
	 * Literals, treated as an atomic value, should be able to be cloned.
	 * 
	 * @return a cloned object of this one
	 */
	Object clone();
	
} // RDFSLiteral
