/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFXMLResource.java,v 1.2 2007/03/18 08:39:02 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

/**
 * RDFXMLResource represents an RDF/XML syntax resource storing a EODM-based RDF
 * memory model. The RDF/XML syntax is defined by <a
 * href="http://www.w3.org/TR/2004/REC-rdf-syntax-grammar-20040210/"> W3C
 * RDF/XML Syntax Specificatoin (W3C Recommendation, 10 February 2004) </a>
 * 
 * @see <a href="http://www.w3.org/TR/2004/REC-rdf-syntax-grammar-20040210/">W3C
 *      RDF/XML Syntax Specificatoin (W3C Recommendation, 10 February 2004) </a>
 * 
 */
public interface RDFXMLResource extends Resource {

    /**
     * The default file extension (".rdf") of a RDF/XML file or URI.
     */
    public String DEFAULT_RDFXML_EXTENSION = "rdf";

    /**
     * A constant that represents the encoding option of the resource.
     */
    public String OPTION_ENCODING = XMLResource.OPTION_ENCODING;

}