/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.internal.runtime.SafeContainerRuntimeTag;
import org.eclipse.jet.internal.runtime.SafeCustomRuntimeTag;
import org.eclipse.jet.taglib.IteratingTag;

public class SafeIteratingRuntimeTag
extends SafeContainerRuntimeTag {
    private boolean okToProcessBodyResult;
    private boolean loopInitializedOk;

    public SafeIteratingRuntimeTag(IteratingTag tag) {
        super(tag);
    }

    public void doStart(JET2Context startContext, JET2Writer startOut) {
        super.doStart(startContext, startOut);
        this.loopInitializedOk = false;
        Platform.run((ISafeRunnable)new SafeCustomRuntimeTag.TagSafeRunnable(this){

            public void doRun() throws Exception {
                IteratingTag untrustedTag = (IteratingTag)SafeIteratingRuntimeTag.this.getUntrustedTag();
                untrustedTag.doInitializeLoop(SafeIteratingRuntimeTag.this.getTagInfo(), SafeIteratingRuntimeTag.this.getContext());
                SafeIteratingRuntimeTag.this.loopInitializedOk = true;
            }
        });
        RuntimeLoggerContextExtender.log(this.getContext(), JET2Messages.TraceRuntimeTags_LoopInitialized, this.getTagInfo(), 2);
    }

    public boolean okToProcessBody() {
        this.okToProcessBodyCalled = true;
        if (!this.loopInitializedOk) {
            return false;
        }
        this.okToProcessBodyResult = false;
        Platform.run((ISafeRunnable)new SafeCustomRuntimeTag.TagSafeRunnable(this){

            public void doRun() throws Exception {
                IteratingTag untrustedTag = (IteratingTag)SafeIteratingRuntimeTag.this.getUntrustedTag();
                SafeIteratingRuntimeTag.this.okToProcessBodyResult = untrustedTag.doEvalLoopCondition(SafeIteratingRuntimeTag.this.getTagInfo(), SafeIteratingRuntimeTag.this.getContext());
                if (SafeIteratingRuntimeTag.this.okToProcessBodyResult) {
                    untrustedTag.doBeforeBody(SafeIteratingRuntimeTag.this.getTagInfo(), SafeIteratingRuntimeTag.this.getContext(), SafeIteratingRuntimeTag.this.getWriter());
                }
            }
        });
        RuntimeLoggerContextExtender.log(this.getContext(), this.okToProcessBodyResult ? JET2Messages.TraceRuntimeTags_ProcessingLoopBody : JET2Messages.TraceRuntimeTags_LoopFinished, this.getTagInfo(), 2);
        return this.okToProcessBodyResult;
    }
}

