/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.ast;

import org.eclipse.jet.internal.xpath.ast.BooleanExpr;
import org.eclipse.jet.internal.xpath.ast.ExprNode;
import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.xpath.Context;

public abstract class LogicalOp
extends BooleanExpr {
    protected final ExprNode left;
    protected final ExprNode right;

    public LogicalOp(ExprNode left, ExprNode right) {
        this.left = left;
        this.right = right;
    }

    protected final boolean eval(Context context, ExprNode node) {
        if (node instanceof BooleanExpr) {
            return ((BooleanExpr)node).evalAsBoolean(context);
        }
        Object result = node.evalAsObject(context);
        return BooleanFunction.evaluate(result);
    }

    public abstract String opName();

    public String toString() {
        return "(" + this.left.toString() + this.opName() + this.right.toString() + ")";
    }

    public static final class Or
    extends LogicalOp {
        public Or(ExprNode left, ExprNode right) {
            super(left, right);
        }

        public boolean evalAsBoolean(Context context) {
            return this.eval(context, this.left) || this.eval(context, this.right);
        }

        public String opName() {
            return " or ";
        }
    }

    public static final class And
    extends LogicalOp {
        public And(ExprNode left, ExprNode right) {
            super(left, right);
        }

        public boolean evalAsBoolean(Context context) {
            return this.eval(context, this.left) && this.eval(context, this.right);
        }

        public String opName() {
            return " and ";
        }
    }
}

