/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class WindowUtil {
    public static void centerDialog(Shell dialogShell, Shell parentShell) {
        try {
            Point dialogSize = dialogShell.getSize();
            Point windowLocation = parentShell.getLocation();
            Point windowSize = parentShell.getSize();
            dialogShell.setLocation((windowSize.x - dialogSize.x) / 2 + windowLocation.x, (windowSize.y - dialogSize.y) / 2 + windowLocation.y);
        }
        catch (Exception e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, WindowUtil.class, (String)"Failed to center dialog", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)6, (String)"Failed to center dialog", (Throwable)e);
        }
    }

    public static Point constrainWindowLocation(Shell shell, Point initLocation, int lowerY) {
        Monitor[] monitors = shell.getDisplay().getMonitors();
        int closest = Integer.MAX_VALUE;
        Monitor closestMonitor = monitors[0];
        Rectangle windowBounds = shell.getBounds();
        Point toFind = Geometry.centerPoint((Rectangle)windowBounds);
        int idx = 0;
        while (idx < monitors.length) {
            Monitor current = monitors[idx];
            Rectangle clientArea = current.getClientArea();
            if (clientArea.contains(toFind)) {
                closestMonitor = current;
                break;
            }
            int distance = Geometry.distanceSquared((Point)Geometry.centerPoint((Rectangle)clientArea), (Point)toFind);
            if (distance < closest) {
                closest = distance;
                closestMonitor = current;
            }
            ++idx;
        }
        Rectangle monitorBounds = closestMonitor.getClientArea();
        int windowX = Math.max(monitorBounds.x, Math.min(initLocation.x, monitorBounds.x + monitorBounds.width - windowBounds.width));
        int windowY = Math.max(monitorBounds.y, Math.min(initLocation.y, monitorBounds.y + monitorBounds.height - windowBounds.height));
        if (lowerY > -1 && windowY < initLocation.y && windowY + windowBounds.height > lowerY) {
            windowY = lowerY - windowBounds.height;
        }
        return new Point(windowX, windowY);
    }

    public static void disposeChildren(Composite parent) {
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
    }

    public static GridData makeButtonData(Button button) {
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        GridData data = new GridData();
        data.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
        data.widthHint = Math.max(Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gc.dispose();
        return data;
    }

    public static GridData makeFixedButtonData(Button button) {
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        GridData gridData = new GridData();
        gridData.widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61);
        gridData.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
        gc.dispose();
        return gridData;
    }

    public static void doMessageBox(String message, String title, int swtStyle, Shell shell) {
        MessageBox messageBox = new MessageBox(shell, swtStyle);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }
}

