/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.ResourceInfoImpl;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.UIUtils;
import org.eclipse.emf.cdo.examples.ui.internal.wizards.CDONewWizardPage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CDONewWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "org.eclipse.emf.cdo.examples.ui.CDONewWizard";
    public static final String TITLE = "New CDO Resource";
    private CDONewWizardPage page;
    private ResourceManager resourceManager;
    private boolean commit;

    public CDONewWizard() {
        this(null, true);
    }

    public CDONewWizard(ResourceManager resourceManager, boolean commit) {
        if (resourceManager == null && !commit) {
            throw new IllegalArgumentException("resourceManager == null && !commit");
        }
        this.setWindowTitle(TITLE);
        this.setNeedsProgressMonitor(true);
        this.resourceManager = resourceManager;
        this.commit = commit;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new CDONewWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String resourcePath = this.page.getResourcePath();
        final ClassInfo rootElement = this.page.getRootElement();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    CDONewWizard.this.doFinish(resourcePath, rootElement, monitor);
                }
                catch (Exception ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        if (this.resourceManager == null) {
            UIUtils.openCDOEditor((ResourceInfo)new ResourceInfoImpl(resourcePath, 0, false));
        }
        return true;
    }

    private void doFinish(String resourcePath, ClassInfo rootElement, IProgressMonitor monitor) throws Exception {
        ResourceManager resourceManager = this.resourceManager == null ? ExampleClientPlugin.createResourceManager((ResourceSet)new ResourceSetImpl()) : this.resourceManager;
        URI uri = URI.createURI((String)("cdo://" + resourcePath));
        CDOResource resource = (CDOResource)resourceManager.createResource(uri);
        EClass eClass = rootElement.getEClass();
        EPackage ePackage = eClass.getEPackage();
        EFactory eFactory = ePackage.getEFactoryInstance();
        EObject eObject = eFactory.create(eClass);
        resource.getContents().add((Object)eObject);
        if (this.commit) {
            resourceManager.commit();
        }
        if (this.resourceManager == null) {
            resourceManager.stop();
        }
    }
}

