/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.Message;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.jms.internal.server.ServerDestination;
import org.eclipse.net4j.jms.internal.server.ServerSession;
import org.eclipse.net4j.jms.internal.server.bundle.OM;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerMessageRequest;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerProtocol;
import org.eclipse.net4j.jms.server.IServerConsumer;
import org.eclipse.net4j.jms.server.IStoreTransaction;
import org.eclipse.net4j.util.io.IOUtil;

public class ServerConsumer
implements IServerConsumer {
    private ServerSession session;
    private long id;
    private ServerDestination destination;
    private String messageSelector;
    private boolean noLocal;
    private boolean durable;
    private ConcurrentMap<String, MessageImpl> messages = new ConcurrentHashMap<String, MessageImpl>();

    public ServerConsumer(long id, ServerDestination destination, String messageSelector, boolean noLocal, boolean durable) {
        this.id = id;
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.noLocal = noLocal;
        this.durable = durable;
    }

    public ServerSession getSession() {
        return this.session;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public long getID() {
        return this.id;
    }

    public ServerDestination getDestination() {
        return this.destination;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public JMSServerProtocol getProtocol() {
        return this.session.getConnection().getProtocol();
    }

    public boolean isDurable() {
        return this.durable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleClientMessage(IStoreTransaction transaction, MessageImpl message) {
        try {
            String messageID = message.getJMSMessageID();
            ConcurrentMap<String, MessageImpl> concurrentMap = this.messages;
            synchronized (concurrentMap) {
                this.messages.put(messageID, message);
            }
            new JMSServerMessageRequest(this.getProtocol(), this.session.getID(), this.id, message).sendAsync();
            transaction.messageSent((Message)message, this.id);
            return true;
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAcknowledge(IStoreTransaction transaction) {
        ConcurrentMap<String, MessageImpl> concurrentMap = this.messages;
        synchronized (concurrentMap) {
            if (this.messages.isEmpty()) {
                return;
            }
            for (MessageImpl message : this.messages.values()) {
                transaction.messageAcknowledged((Message)message, this.id);
                IOUtil.OUT().println("\nMessage acknowledged: " + message.getJMSMessageID() + "  (consumer=" + this.id + ")\n");
            }
            this.messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRecover(IStoreTransaction transaction) {
        ConcurrentMap<String, MessageImpl> concurrentMap = this.messages;
        synchronized (concurrentMap) {
            if (this.messages.isEmpty()) {
                return;
            }
            for (MessageImpl message : this.messages.values()) {
                IOUtil.OUT().println("\nRecovering message: " + message.getJMSMessageID() + "  (consumer=" + this.id + ")\n");
                this.session.getConnection().getServer().addWork(message);
            }
        }
    }
}

