/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class VerifyRevisionIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, VerifyRevisionIndication.class);
    protected long[] timeStamps;

    public VerifyRevisionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)11);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int size = in.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} IDs and versions", new Object[]{size});
        }
        RevisionManager revisionManager = this.getRepository().getRevisionManager();
        this.timeStamps = new long[size];
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            int version = in.readInt();
            if (TRACER.isEnabled()) {
                TRACER.format("Read ID and version: {0}v{1}", new Object[]{id, version});
            }
            InternalCDORevision revision = revisionManager.getRevisionByVersion(id, 0, version);
            this.timeStamps[i] = revision.getRevised();
            ++i;
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        long[] lArray = this.timeStamps;
        int n = this.timeStamps.length;
        int n2 = 0;
        while (n2 < n) {
            long revised = lArray[n2];
            out.writeLong(revised);
            ++n2;
        }
    }
}

