/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.bundle;

import java.io.File;
import org.eclipse.emf.cdo.internal.server.RepositoryConfigurator;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.messages.Messages;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.TransportConfigurator;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiApplication;

public class CDOServerApplication
extends OSGiApplication {
    public static final String ID = "org.eclipse.emf.cdo.server.app";
    private IRepository[] repositories;
    private IAcceptor[] acceptors;

    public CDOServerApplication() {
        super(ID);
    }

    protected void doStart() throws Exception {
        super.doStart();
        OM.LOG.info(Messages.getString("CDOServerApplication.1"));
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo-server.xml");
        if (configFile != null && configFile.exists()) {
            RepositoryConfigurator repositoryConfigurator = new RepositoryConfigurator((IManagedContainer)IPluginContainer.INSTANCE);
            this.repositories = repositoryConfigurator.configure(configFile);
            if (this.repositories == null || this.repositories.length == 0) {
                OM.LOG.warn(Messages.getString("CDOServerApplication.3"));
            }
            TransportConfigurator net4jConfigurator = new TransportConfigurator((IManagedContainer)IPluginContainer.INSTANCE);
            this.acceptors = net4jConfigurator.configure(configFile);
            if (this.acceptors == null || this.acceptors.length == 0) {
                OM.LOG.warn(Messages.getString("CDOServerApplication.4"));
            }
        } else {
            OM.LOG.warn(String.valueOf(Messages.getString("CDOServerApplication.5")) + configFile.getAbsolutePath());
        }
        OM.LOG.info(Messages.getString("CDOServerApplication.6"));
    }

    protected void doStop() throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        OM.LOG.info(Messages.getString("CDOServerApplication.7"));
        if (this.acceptors != null) {
            objectArray = this.acceptors;
            n2 = this.acceptors.length;
            n = 0;
            while (n < n2) {
                IAcceptor acceptor = objectArray[n];
                acceptor.close();
                ++n;
            }
        }
        if (this.repositories != null) {
            objectArray = this.repositories;
            n2 = this.repositories.length;
            n = 0;
            while (n < n2) {
                IAcceptor repository = objectArray[n];
                LifecycleUtil.deactivate((Object)repository);
                ++n;
            }
        }
        OM.LOG.info(Messages.getString("CDOServerApplication.8"));
        super.doStop();
    }
}

