/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UmlElement
extends PropertyTester {
    public boolean test(Object receiver, String propertyName, Object[] args, Object value) {
        switch (propertyName) {
            case "fromLocal": {
                return true;
            }
            case "isLocalised": {
                EObject obj = UmlElement.unwrap(receiver);
                if (obj instanceof Association) {
                    Association association = (Association)obj;
                    for (Property property : association.getMemberEnds()) {
                        if (property.getType() == null || !property.getType().getOwner().equals(property.getOwner())) continue;
                        return true;
                    }
                }
                return false;
            }
            case "instanceOf": {
                return false;
            }
            case "isAnAssociation": {
                return UmlElement.unwrap(receiver) instanceof Association;
            }
            case "isProperty": {
                return UmlElement.unwrap(receiver) instanceof Property;
            }
            case "isNamedElement": {
                return UmlElement.unwrap(receiver) instanceof NamedElement;
            }
        }
        return false;
    }

    private static EObject unwrap(Object wrapper) {
        Object obj = null;
        if (wrapper instanceof EObject) {
            return (EObject)wrapper;
        }
        if (wrapper instanceof DelegatingWrapperItemProvider) {
            obj = ((DelegatingWrapperItemProvider)wrapper).getValue();
        } else if (wrapper instanceof UMLDomainNavigatorItem) {
            obj = ((UMLDomainNavigatorItem)wrapper).getEObject();
        } else {
            return null;
        }
        return UmlElement.unwrap(obj);
    }

    private static Package getCurrentMDHTModel() {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        if (editingDomain == null) {
            return null;
        }
        IWorkbenchPart part = null;
        try {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!(part instanceof IEditorPart) || !(((IEditorPart)part).getEditorInput() instanceof IFileEditorInput)) {
            return null;
        }
        String modelFilePath = ((IFileEditorInput)((IEditorPart)part).getEditorInput()).getFile().getFullPath().toString();
        URI resourceURI = URI.createPlatformResourceURI((String)modelFilePath, (boolean)false);
        for (Resource resource : editingDomain.getResourceSet().getResources()) {
            if (!resource.getURI().equals(resourceURI)) continue;
            for (EObject e : resource.getContents()) {
                if (!(e instanceof Package)) continue;
                return (Package)e;
            }
        }
        return null;
    }

    private static boolean fromCurrentModel(ITreeContentProvider provider, Package localModel, Object selectedItem) {
        boolean rs = false;
        EObject currentObj = UmlElement.unwrap(selectedItem);
        Object child = selectedItem;
        if (selectedItem instanceof UMLDomainNavigatorItem) {
            child = currentObj;
        }
        if (!(currentObj instanceof Association || currentObj instanceof Class || currentObj instanceof Generalization)) {
            if (currentObj instanceof Package) {
                return currentObj == localModel;
            }
            return false;
        }
        rs = UmlElement.fromCurrentModel(provider, localModel, provider.getParent(child));
        return rs;
    }

    private static boolean isLocalised(ITreeContentProvider provider, Package localModel, Object selectedItem, String previousTypeName) {
        EObject currentObj = UmlElement.unwrap(selectedItem);
        Object child = selectedItem;
        if (selectedItem instanceof UMLDomainNavigatorItem) {
            child = currentObj;
        }
        if (!(currentObj instanceof Association || currentObj instanceof Class || currentObj instanceof Generalization)) {
            return false;
        }
        String part1 = UmlElement.getTypeName(currentObj);
        String part2 = part1 != null && previousTypeName != null ? "::" : "";
        part1 = part1 == null ? "" : part1;
        String part3 = previousTypeName == null ? "" : previousTypeName;
        String typeName = String.valueOf(part1) + part2 + part3;
        if (UmlElement.isLocalClass(localModel, currentObj)) {
            return UMLUtil.findNamedElements((Resource)localModel.eResource(), (String)typeName).size() > 0;
        }
        return UmlElement.isLocalised(provider, localModel, provider.getParent(child), typeName);
    }

    private static String getTypeName(EObject obj) {
        if (obj instanceof Association) {
            return ((Property)((Association)obj).getMemberEnds().get(0)).getType().getName();
        }
        if (obj instanceof Generalization) {
            return null;
        }
        if (obj instanceof Class) {
            return ((Class)obj).getQualifiedName();
        }
        return "";
    }

    private static boolean isLocalType(Package currentModel, EObject type) {
        return currentModel == UmlElement.getOwnerModel(type);
    }

    private static boolean isLocalClass(Package currentModel, EObject type) {
        return UmlElement.isLocalType(currentModel, type) && type instanceof Class;
    }

    private static Package getOwnerModel(EObject t) {
        if (t.eContainer() instanceof Package) {
            return (Package)t.eContainer();
        }
        return UmlElement.getOwnerModel(t.eContainer());
    }
}

