/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.ui.properties;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.util.UMLUIUtil;
import org.eclipse.mdht.uml.term.core.profile.BindingKind;
import org.eclipse.mdht.uml.term.core.profile.Extensibility;
import org.eclipse.mdht.uml.term.core.profile.Guidance;
import org.eclipse.mdht.uml.term.core.profile.TermPackage;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class ValueSetConstraintSection
extends ResettableModelerPropertySection {
    private Property property;
    private Text idText;
    private boolean idModified = false;
    private Text nameText;
    private boolean nameModified = false;
    private Text versionText;
    private boolean versionModified = false;
    private CCombo bindingCombo;
    private boolean bindingModified = false;
    private Text valueSetRefText;
    private boolean valueSetRefTextModified = false;
    private Button valueSetRefButton;
    private Button valueSetRefDeleteButton;
    ComboEnumeration guidanceEnumeration = null;
    ComboEnumeration extensibilityEnumeration = null;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (ValueSetConstraintSection.this.idText == event.getSource()) {
                ValueSetConstraintSection.this.idModified = true;
            }
            if (ValueSetConstraintSection.this.nameText == event.getSource()) {
                ValueSetConstraintSection.this.nameModified = true;
            }
            if (ValueSetConstraintSection.this.versionText == event.getSource()) {
                ValueSetConstraintSection.this.versionModified = true;
            }
            if (ValueSetConstraintSection.this.valueSetRefText == event.getSource()) {
                ValueSetConstraintSection.this.valueSetRefTextModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                ValueSetConstraintSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            ValueSetConstraintSection.this.modifyFields();
        }

        public void focusLost(FocusEvent event) {
            ValueSetConstraintSection.this.modifyFields();
        }
    };

    private void modifyFields() {
        if (!(this.idModified || this.nameModified || this.versionModified || this.bindingModified || this.valueSetRefTextModified || this.guidanceEnumeration != null & this.guidanceEnumeration.modified || this.extensibilityEnumeration != null & this.extensibilityEnumeration.modified)) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)ValueSetConstraintSection.this.property.eResource().getResourceSet());
                    if (ctsProfile == null) {
                        return Status.CANCEL_STATUS;
                    }
                    Enumeration bindingKind = (Enumeration)ctsProfile.getOwnedType("BindingKind");
                    Stereotype stereotype = TermProfileUtil.getAppliedStereotype((Element)ValueSetConstraintSection.this.property, (String)"ValueSetConstraint");
                    ValueSetConstraint valueSetConstraint = (ValueSetConstraint)ValueSetConstraintSection.this.property.getStereotypeApplication(stereotype);
                    if (stereotype == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ValueSetConstraintSection.this.idModified) {
                        ValueSetConstraintSection.this.idModified = false;
                        this.setLabel("Set Value Set ID");
                        if (stereotype != null) {
                            String value = ValueSetConstraintSection.this.idText.getText().trim();
                            ValueSetConstraintSection.this.property.setValue(stereotype, "identifier", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (ValueSetConstraintSection.this.nameModified) {
                        ValueSetConstraintSection.this.nameModified = false;
                        this.setLabel("Set Value Set Name");
                        if (stereotype != null) {
                            String value = ValueSetConstraintSection.this.nameText.getText().trim();
                            ValueSetConstraintSection.this.property.setValue(stereotype, "name", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (ValueSetConstraintSection.this.versionModified) {
                        ValueSetConstraintSection.this.versionModified = false;
                        this.setLabel("Set Value Set Version");
                        if (stereotype != null) {
                            String value = ValueSetConstraintSection.this.versionText.getText().trim();
                            ValueSetConstraintSection.this.property.setValue(stereotype, "version", (Object)(value.length() > 0 ? value : null));
                        }
                    } else if (ValueSetConstraintSection.this.valueSetRefTextModified) {
                        ValueSetConstraintSection.this.valueSetRefTextModified = false;
                        this.setLabel("Set valueSetRefTextModified");
                        if (valueSetConstraint != null) {
                            valueSetConstraint.setUri(ValueSetConstraintSection.this.valueSetRefText.getText().trim());
                        }
                    } else if (ValueSetConstraintSection.this.bindingModified) {
                        ValueSetConstraintSection.this.bindingModified = false;
                        this.setLabel("Set Binding");
                        if (stereotype != null && bindingKind != null) {
                            if (ValueSetConstraintSection.this.bindingCombo.getSelectionIndex() == 0) {
                                ValueSetConstraintSection.this.property.setValue(stereotype, "binding", null);
                            } else {
                                EnumerationLiteral literal = (EnumerationLiteral)bindingKind.getOwnedLiterals().get(ValueSetConstraintSection.this.bindingCombo.getSelectionIndex());
                                ValueSetConstraintSection.this.property.setValue(stereotype, "binding", (Object)literal);
                            }
                        }
                    } else if (ValueSetConstraintSection.this.guidanceEnumeration != null & ValueSetConstraintSection.this.guidanceEnumeration.modified) {
                        this.setLabel("Set Guidance");
                        if (valueSetConstraint != null) {
                            if (ValueSetConstraintSection.this.guidanceEnumeration.getEnumerationCombo().getSelectionIndex() == 0) {
                                valueSetConstraint.setGuidance(null);
                            } else {
                                valueSetConstraint.setGuidance(Guidance.get((int)ValueSetConstraintSection.this.guidanceEnumeration.getEnumerationCombo().getSelectionIndex()));
                            }
                            ValueSetConstraintSection.this.guidanceEnumeration.modified = false;
                        }
                    } else if (ValueSetConstraintSection.this.extensibilityEnumeration != null & ValueSetConstraintSection.this.extensibilityEnumeration.modified) {
                        this.setLabel("Set Extensibility");
                        if (valueSetConstraint != null) {
                            if (ValueSetConstraintSection.this.extensibilityEnumeration.getEnumerationCombo().getSelectionIndex() == 0) {
                                valueSetConstraint.setExtensibility(null);
                            } else {
                                valueSetConstraint.setExtensibility(Extensibility.get((int)ValueSetConstraintSection.this.extensibilityEnumeration.getEnumerationCombo().getSelectionIndex()));
                            }
                            ValueSetConstraintSection.this.extensibilityEnumeration.modified = false;
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    ValueSetConstraintSection.this.updateViews();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected void resetFields() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Restore Default Values"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)ValueSetConstraintSection.this.property);
                    if (valueSetConstraint == null) {
                        return Status.CANCEL_STATUS;
                    }
                    valueSetConstraint.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CONSTRAINT__IDENTIFIER);
                    valueSetConstraint.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CONSTRAINT__NAME);
                    valueSetConstraint.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CONSTRAINT__VERSION);
                    valueSetConstraint.eUnset((EStructuralFeature)TermPackage.Literals.VALUE_SET_CONSTRAINT__BINDING);
                    ValueSetConstraintSection.this.updateViews();
                    ValueSetConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void addValueSetReference() {
        IElementFilter filter = new IElementFilter(){

            public boolean accept(Element element) {
                return element instanceof Enumeration && TermProfileUtil.getValueSetVersion((Enumeration)((Enumeration)element)) != null;
            }
        };
        Enumeration valueSetEnum = (Enumeration)DialogLaunchUtil.chooseElement((IElementFilter)filter, (ResourceSet)UMLUIUtil.loadModelsfromWorkspace(), (Shell)this.getPart().getSite().getShell(), null, (String)"Select a Value Set");
        if (valueSetEnum == null) {
            return;
        }
        Stereotype valueSetStereotype = TermProfileUtil.getAppliedStereotype((Element)valueSetEnum, (String)"ValueSetVersion");
        if (valueSetStereotype == null) {
            MessageDialog.openError((Shell)this.getPart().getSite().getShell(), (String)"Invalid Enumeration", (String)"The selected Enumertion must be a <<ValueSetVersion>>");
            return;
        }
        final ValueSetVersion valueSet = (ValueSetVersion)valueSetEnum.getStereotypeApplication(valueSetStereotype);
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)ValueSetConstraintSection.this.property);
                    if (valueSetConstraint == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Set ValueSet reference");
                    valueSetConstraint.setReference(valueSet);
                    valueSetConstraint.setIdentifier(null);
                    valueSetConstraint.setName(null);
                    valueSetConstraint.setVersion(null);
                    valueSetConstraint.setBinding(null);
                    ValueSetConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void deleteValueSetReference() {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.property);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)ValueSetConstraintSection.this.property);
                    if (valueSetConstraint == null || valueSetConstraint.getReference() == null) {
                        return Status.CANCEL_STATUS;
                    }
                    this.setLabel("Remove ValueSet reference");
                    valueSetConstraint.setReference(null);
                    valueSetConstraint.setIdentifier(null);
                    valueSetConstraint.setName(null);
                    valueSetConstraint.setVersion(null);
                    valueSetConstraint.setBinding(null);
                    ValueSetConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int buttonHeight = point.y + 10;
        gc.dispose();
        shell.dispose();
        Group composite = this.getWidgetFactory().createGroup(parent, "Value Set");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        FormData data = null;
        this.valueSetRefText = this.getWidgetFactory().createText((Composite)composite, "");
        this.valueSetRefText.addModifyListener(this.modifyListener);
        this.valueSetRefText.addKeyListener(this.keyListener);
        this.valueSetRefText.addFocusListener(this.focusListener);
        this.valueSetRefButton = this.getWidgetFactory().createButton((Composite)composite, "Select Value Set...", 8);
        this.valueSetRefButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetConstraintSection.this.addValueSetReference();
            }
        });
        this.valueSetRefDeleteButton = this.getWidgetFactory().createButton((Composite)composite, "X", 8);
        this.valueSetRefDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ValueSetConstraintSection.this.deleteValueSetReference();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment(0, 0);
        this.valueSetRefButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.valueSetRefButton, 0);
        data.height = buttonHeight;
        data.top = new FormAttachment(0, 0);
        this.valueSetRefDeleteButton.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.restoreDefaultsButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.valueSetRefDeleteButton, 0);
        data.right = new FormAttachment((Control)this.restoreDefaultsButton, 5);
        data.top = new FormAttachment(0, 0);
        this.valueSetRefText.setLayoutData((Object)data);
        this.nameText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel nameLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Name:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.valueSetRefText, 0);
        nameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)nameLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment((Control)this.valueSetRefText, 0);
        this.nameText.setLayoutData((Object)data);
        this.nameText.addModifyListener(this.modifyListener);
        this.nameText.addKeyListener(this.keyListener);
        this.nameText.addFocusListener(this.focusListener);
        this.idText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel idLabel = this.getWidgetFactory().createCLabel((Composite)composite, "ID:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.nameText, 5);
        data.top = new FormAttachment((Control)this.valueSetRefText, 0);
        idLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)idLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.valueSetRefText, 0);
        this.idText.setLayoutData((Object)data);
        this.bindingCombo = this.getWidgetFactory().createCCombo((Composite)composite, 0x800808);
        this.bindingCombo.setItems(new String[]{"Static", "Dynamic"});
        this.bindingCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValueSetConstraintSection.this.bindingModified = true;
                ValueSetConstraintSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ValueSetConstraintSection.this.bindingModified = true;
                ValueSetConstraintSection.this.modifyFields();
            }
        });
        CLabel bindingLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Binding:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.nameText, 0);
        bindingLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)bindingLabel, 0);
        data.top = new FormAttachment((Control)this.nameText, 0);
        this.bindingCombo.setLayoutData((Object)data);
        this.versionText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel versionLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Version:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.bindingCombo, 5);
        data.top = new FormAttachment((Control)this.nameText, 0);
        versionLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)versionLabel, 0);
        data.right = new FormAttachment(50, 0);
        data.top = new FormAttachment((Control)this.nameText, 0);
        this.versionText.setLayoutData((Object)data);
        this.guidanceEnumeration = new ComboEnumeration((Composite)composite, (Control)this.versionText, null, "Guidance : ", Guidance.VALUES);
        this.extensibilityEnumeration = new ComboEnumeration((Composite)composite, (Control)this.versionText, (Control)this.guidanceEnumeration.getEnumerationCombo(), "Extensibility : ", Extensibility.VALUES);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.property != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.property)) != null && editingDomain.isReadOnly(this.property.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof NamedElement));
        this.property = (Property)element;
    }

    public void dispose() {
        super.dispose();
    }

    private void setText(Text text, String value) {
        System.out.println(value);
        text.removeModifyListener(this.modifyListener);
        text.removeKeyListener(this.keyListener);
        text.removeFocusListener(this.focusListener);
        text.setText(StringUtils.isEmpty((String)value) ? "" : value);
        text.addModifyListener(this.modifyListener);
        text.addKeyListener(this.keyListener);
        text.addFocusListener(this.focusListener);
    }

    public void refresh() {
        Profile ctsProfile = TermProfileUtil.getTerminologyProfile((ResourceSet)this.property.eResource().getResourceSet());
        if (ctsProfile == null) {
            return;
        }
        Enumeration bindingKind = (Enumeration)ctsProfile.getOwnedType("BindingKind");
        ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)this.property);
        ValueSetVersion valueSet = null;
        Enumeration referenceEnum = null;
        if (valueSetConstraint != null && valueSetConstraint.getReference() != null) {
            valueSet = valueSetConstraint.getReference();
            referenceEnum = valueSet.getBase_Enumeration();
            this.valueSetRefText.setText(valueSet.getEnumerationQualifiedName());
            this.valueSetRefText.setEnabled(false);
            this.valueSetRefText.setEditable(false);
        } else {
            this.valueSetRefText.setEditable(true);
            this.setText(this.valueSetRefText, valueSetConstraint.getUri());
            this.valueSetRefText.setFocus();
        }
        String id = valueSet == null ? valueSetConstraint.getIdentifier() : valueSet.getIdentifier();
        this.setText(this.idText, id);
        String name = valueSet == null ? valueSetConstraint.getName() : valueSet.getEnumerationName();
        this.setText(this.nameText, name);
        String version = valueSet == null ? valueSetConstraint.getVersion() : valueSet.getVersion();
        this.setText(this.versionText, version);
        this.bindingCombo.select(0);
        if (valueSetConstraint != null) {
            BindingKind binding;
            BindingKind bindingKind2 = binding = valueSet == null ? valueSetConstraint.getBinding() : valueSet.getBinding();
            if (bindingKind != null && binding != null) {
                EnumerationLiteral literal = bindingKind.getOwnedLiteral(binding.getName());
                int index = bindingKind.getOwnedLiterals().indexOf((Object)literal);
                this.bindingCombo.select(index);
            }
        }
        if (this.guidanceEnumeration != null) {
            this.guidanceEnumeration.getEnumerationCombo().select(Guidance.get((String)valueSetConstraint.getGuidance().getLiteral()).getValue());
        }
        if (this.extensibilityEnumeration != null) {
            this.extensibilityEnumeration.getEnumerationCombo().select(Extensibility.get((String)valueSetConstraint.getExtensibility().getLiteral()).getValue());
        }
        if (this.isReadOnly()) {
            this.valueSetRefText.setEnabled(false);
            this.idText.setEnabled(false);
            this.nameText.setEnabled(false);
            this.versionText.setEnabled(false);
            this.bindingCombo.setEnabled(false);
        } else {
            this.valueSetRefText.setEnabled(true);
            this.idText.setEnabled(referenceEnum == null);
            this.nameText.setEnabled(referenceEnum == null);
            this.versionText.setEnabled(referenceEnum == null);
            this.bindingCombo.setEnabled(referenceEnum == null);
            this.restoreDefaultsButton.setEnabled(valueSetConstraint != null);
        }
        this.nameText.setFocus();
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ValueSetConstraintSection.this.isDisposed() && ValueSetConstraintSection.this.property.eResource() != null) {
                        ValueSetConstraintSection.this.refresh();
                    }
                }
            });
        }
    }

    protected void updateViews() {
        NotificationImpl notification = new NotificationImpl(1, null, this.property.getName()){

            public Object getNotifier() {
                return ValueSetConstraintSection.this.property;
            }

            public int getFeatureID(Class expectedClass) {
                return 5;
            }
        };
        this.property.eNotify((Notification)notification);
    }

    private class ComboEnumeration {
        private CCombo enumerationCombo;
        private boolean modified = false;

        public CCombo getEnumerationCombo() {
            return this.enumerationCombo;
        }

        public ComboEnumeration(Composite composite, Control top, Control left, String name, List values) {
            this.enumerationCombo = ValueSetConstraintSection.this.getWidgetFactory().createCCombo(composite, 0x800808);
            for (Object object : values) {
                if (!(object instanceof Enumerator)) continue;
                Enumerator enumerator = (Enumerator)object;
                this.enumerationCombo.add(enumerator.getLiteral(), enumerator.getValue());
            }
            this.enumerationCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboEnumeration.this.modified = true;
                    ValueSetConstraintSection.this.modifyFields();
                }

                public void widgetSelected(SelectionEvent e) {
                    ComboEnumeration.this.modified = true;
                    ValueSetConstraintSection.this.modifyFields();
                }
            });
            CLabel bindingLabel = ValueSetConstraintSection.this.getWidgetFactory().createCLabel(composite, name);
            FormData data = new FormData();
            data.left = left != null ? new FormAttachment(left, 0) : new FormAttachment(0, 0);
            data.top = new FormAttachment(top, 0);
            bindingLabel.setLayoutData((Object)data);
            data = new FormData();
            data.left = new FormAttachment((Control)bindingLabel, 0);
            data.top = new FormAttachment(top, 0);
            this.enumerationCombo.setLayoutData((Object)data);
        }
    }
}

