/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.uml.cda.core.profile.ConformsTo;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.transform.EcoreTransformUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.AnnotationsUtil;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformAbstract;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class TransformTemplateIdentifier
extends TransformAbstract {
    private static final String REGISTRY_DELEGATE_NAME = "RegistryDelegate";

    public TransformTemplateIdentifier(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    public Object caseClass(Class umlClass) {
        Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)umlClass, (String)"CDATemplate");
        if (hl7Template != null) {
            this.addConstraint(umlClass, hl7Template);
            this.addAnnotation(umlClass, hl7Template);
        }
        return umlClass;
    }

    private void addConstraint(Class umlClass, Stereotype hl7Template) {
        MutableBoolean requiresParentId = new MutableBoolean(false);
        String constraintName = this.createTemplateConstraintName(umlClass, requiresParentId);
        Constraint constraint = umlClass.createOwnedRule(constraintName, UMLPackage.eINSTANCE.getConstraint());
        constraint.getConstrainedElements().add((Object)umlClass);
        String templateId = (String)umlClass.getValue(hl7Template, "templateId");
        String templateVersion = (String)umlClass.getValue(hl7Template, "templateVersion");
        OpaqueExpression expression = (OpaqueExpression)constraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
        expression.getLanguages().add((Object)"OCL");
        String versionBody = " and id.extension = '" + templateVersion + "'";
        String body = "self.templateId->exists(id : datatypes::II | id.root = '" + templateId + "'" + (StringUtils.isEmpty((String)templateVersion) ? "" : versionBody) + ")";
        String message = CDAModelUtil.getValidationMessage((Element)umlClass);
        if (message == null) {
            message = "The template identifier for " + umlClass.getName() + " must be " + templateId;
        }
        if (requiresParentId.isTrue()) {
            body = "self.templateId->exists(id : datatypes::II | id.root = '" + templateId + "'" + " and id.extension.oclIsUndefined())";
            message = "A compatible R1.1 templateId without an extension must be included in addition to the existing R2.1 templateId with an extension for " + this.convertV2CamelCaseToHumanReadableExceptVersionSuffix(umlClass.getName(), 2) + " " + templateId + ":" + templateVersion + ". " + "When asserting this templateId, " + "all C-CDA R2.1 document, section, and entry templates that had a previous version in C-CDA R1.1 SHALL include " + "both the C-CDA R2.1 templateId and the C-CDA R1.1 templateId root without an extension. See C-CDA R2.1 Volume 1 - " + "Design Considerations for additional detail (CONF:1198-32936, CONF:1198-32934, DSTU:757, DSTU:781).";
        }
        expression.getBodies().add((Object)body);
        this.addValidationError(umlClass, constraintName, message);
    }

    private String convertV2CamelCaseToHumanReadableExceptVersionSuffix(String camelCasedV2Template, int versionSuffix) {
        String versionNumber = String.valueOf(versionSuffix);
        if (camelCasedV2Template.endsWith(versionNumber)) {
            camelCasedV2Template = StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)camelCasedV2Template), (String)" "));
            camelCasedV2Template = camelCasedV2Template.replaceFirst(" " + versionNumber, versionNumber);
        }
        return camelCasedV2Template;
    }

    protected String createTemplateConstraintName(Class template) {
        return this.createTemplateConstraintName(template, new MutableBoolean(false));
    }

    protected String createTemplateConstraintName(Class template, MutableBoolean requiresParentId) {
        String constraintName = null;
        Generalization generalization = null;
        IEcoreProfileReflection.ValidationSeverityKind severity = null;
        if (template.getGeneralizations().size() > 0) {
            generalization = (Generalization)template.getGeneralizations().get(0);
            severity = this.getEcoreProfile().getValidationSeverity((Element)generalization, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
            if (severity == null) {
                severity = IEcoreProfileReflection.ValidationSeverityKind.ERROR;
            }
        }
        if (severity == IEcoreProfileReflection.ValidationSeverityKind.ERROR && CDAModelUtil.getTemplateId((Class)((Class)generalization.getGeneral())) != null) {
            Stereotype stereotype = CDAProfileUtil.applyCDAStereotype((Element)generalization, (String)"ConformsTo");
            if (stereotype != null) {
                ConformsTo conformsTo = (ConformsTo)generalization.getStereotypeApplication(stereotype);
                requiresParentId.setValue(conformsTo.isRequiresParentId());
            }
            if (requiresParentId.isFalse()) {
                constraintName = this.createTemplateConstraintName((Class)generalization.getGeneral());
            } else {
                System.out.println("requiresParentId: " + template.getQualifiedName() + " = " + constraintName);
            }
        }
        if (constraintName == null) {
            constraintName = this.createConstraintName((NamedElement)template, "TemplateId");
        }
        return constraintName;
    }

    private void addAnnotation(Class umlClass, Stereotype hl7Template) {
        String templateId = (String)umlClass.getValue(hl7Template, "templateId");
        String templateVersion = (String)umlClass.getValue(hl7Template, "templateVersion");
        Boolean contextDependent = false;
        try {
            contextDependent = (Boolean)umlClass.getValue(hl7Template, "contextDependent");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AnnotationsUtil annotationsUtil = this.getEcoreProfile().annotate((Element)umlClass);
        annotationsUtil.setAnnotation("templateId.root", templateId);
        if (!StringUtils.isEmpty((String)templateVersion)) {
            annotationsUtil.setAnnotation("templateId.extension", templateVersion);
        }
        if (contextDependent.booleanValue()) {
            this.createRegistryDelegate(umlClass);
            annotationsUtil.setAnnotation("contextDependent", "true");
        }
        annotationsUtil.saveAnnotations();
    }

    private void createRegistryDelegate(Class umlClass) {
        Interface delegateInterface;
        Package cdaPackage;
        String prefix;
        String name;
        Stereotype ePackage;
        Package umlPackage = umlClass.getNearestPackage();
        if (umlPackage.isStereotypeApplied(ePackage = EcoreTransformUtil.getEcoreStereotype((EObject)umlPackage, (String)"EPackage")) && umlPackage.getOwnedType(name = String.valueOf(prefix = (String)umlPackage.getValue(ePackage, "prefix")) + REGISTRY_DELEGATE_NAME) == null && (cdaPackage = this.getBaseModel((Classifier)umlClass)) != null && (delegateInterface = (Interface)cdaPackage.getOwnedType(REGISTRY_DELEGATE_NAME)) != null) {
            Class delegateClass = umlPackage.createOwnedClass(name, false);
            delegateClass.createInterfaceRealization(null, delegateInterface);
            AnnotationsUtil annotationsUtil = this.getEcoreProfile().annotate((Element)umlPackage);
            annotationsUtil.setAnnotation("registryDelegate", name);
            annotationsUtil.saveAnnotations();
        }
    }
}

