/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelConsolidator;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.transform.GenMethodHelper;
import org.eclipse.mdht.uml.cda.transform.TransformFacade;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class GenDomainProperty
extends TransformFacade {
    private GenMethodHelper methodHelper;

    public GenDomainProperty(TransformerOptions options, CDAModelConsolidator consolidator, IBaseModelReflection baseModelReflection) {
        super(options, consolidator, baseModelReflection);
        this.methodHelper = new GenMethodHelper(this.transformerOptions);
    }

    public Object caseProperty(Property property) {
        this.addProperty(property, property.getClass_());
        return property;
    }

    public void addProperty(Property property, Class ownerClass) {
        if (this.isRemoved((Element)property)) {
            return;
        }
        if (property.getClass_() == null) {
            return;
        }
        if (property.getUpper() == 0) {
            return;
        }
        if (this.isFixedValue(property) && !this.transformerOptions.isIncludeFixedValueGetters()) {
            return;
        }
        if (property.getType() instanceof Enumeration) {
            return;
        }
        Classifier domainInterface = this.getDomainInterface((Type)ownerClass);
        Classifier domainType = null;
        domainType = UMLUtil.isSameModel((Element)property.getType(), (Element)ownerClass) ? this.getDomainInterface(property.getType()) : (!CDAModelUtil.isCDAModel((Element)property.getType()) && !CDAModelUtil.isDatatypeModel((Element)property.getType()) ? this.getDomainInterface(property.getType()) : (Classifier)property.getType());
        Operation getOperation = this.methodHelper.genPropertyGetterOperation(domainInterface, property, domainType);
        if (getOperation != null) {
            EList comments = null;
            comments = property.getAssociation() != null ? property.getAssociation().getOwnedComments() : property.getOwnedComments();
            for (Comment comment : comments) {
                Comment clone = (Comment)EcoreUtil.copy((EObject)comment);
                clone.getAnnotatedElements().add((Object)getOperation);
                getOperation.getOwnedComments().add((Object)clone);
            }
            Property docProperty = CDAModelUtil.getCDAProperty((Property)property);
            if (docProperty == null) {
                docProperty = property;
            }
            Comment comment = UMLFactory.eINSTANCE.createComment();
            getOperation.getOwnedComments().add(0, (Object)comment);
            comment.getAnnotatedElements().add((Object)getOperation);
            String xpath = docProperty.getQualifiedName();
            comment.setBody(String.valueOf(xpath) + ".");
        }
        if (!this.isFixedValue(property)) {
            Comment conformanceRule;
            String conformanceText;
            Operation createOperation = null;
            Operation updateOperation = null;
            createOperation = this.methodHelper.genCreateOperation(domainInterface, property, domainType);
            if (property.getUpper() > 1 || property.getUpper() == -1) {
                updateOperation = this.methodHelper.genAddOperation(domainInterface, property, domainType);
            }
            if (property.getUpper() == 1) {
                updateOperation = this.methodHelper.genSetOperation(domainInterface, property, domainType);
            }
            if (!(conformanceText = CDAModelUtil.computeConformanceMessage((Property)property, (boolean)false)).endsWith(".")) {
                conformanceText = String.valueOf(conformanceText) + ".";
            }
            if (createOperation != null) {
                conformanceRule = createOperation.createOwnedComment();
                conformanceRule.getAnnotatedElements().add((Object)createOperation);
                conformanceRule.setBody(conformanceText);
            }
            if (updateOperation != null) {
                conformanceRule = updateOperation.createOwnedComment();
                conformanceRule.getAnnotatedElements().add((Object)updateOperation);
                conformanceRule.setBody(conformanceText);
            }
        }
    }

    private boolean isFixedValue(Property property) {
        String code;
        CodeSystemConstraint codeSystemConstraint;
        if (property.isReadOnly()) {
            return true;
        }
        return this.getEcoreProfile().getValidationSeverity((Element)property, IEcoreProfileReflection.ValidationStereotypeKind.CODE_SYSTEM) == IEcoreProfileReflection.ValidationSeverityKind.ERROR && (codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property)) != null && (code = codeSystemConstraint.getCode()) != null;
    }
}

