/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.dita.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mdht.dita.ui.handlers.DitaCompare;
import org.eclipse.mdht.uml.common.util.CompareResultVisitor;
import org.eclipse.mdht.uml.common.util.ModelCompare;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UMLResource;

public class CompareDitaHandler
extends AbstractHandler {
    private static final String MODELSERVERELEMENTCLASSNAME = "com.ibm.xtools.uml.navigator.ModelServerElement";

    private Class<?> getModelServerElement() {
        try {
            return Class.forName(MODELSERVERELEMENTCLASSNAME);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            try {
                if (!(event.getApplicationContext() instanceof IEvaluationContext)) break block10;
                IEvaluationContext evaluationContext = (IEvaluationContext)event.getApplicationContext();
                IFile leftModel = null;
                IFile rightModel = null;
                Class<?> modelServerElement = this.getModelServerElement();
                if (modelServerElement != null) {
                    Method getResourceIfResourceRootMethod = modelServerElement.getMethod("getResourceIfResourceRoot", new Class[0]);
                    for (Iterator selection : (Collection)evaluationContext.getDefaultVariable()) {
                        if (!modelServerElement.isInstance(selection)) continue;
                        if (leftModel == null) {
                            leftModel = (IFile)getResourceIfResourceRootMethod.invoke(selection, new Object[0]);
                            continue;
                        }
                        rightModel = (IFile)getResourceIfResourceRootMethod.invoke(selection, new Object[0]);
                    }
                } else {
                    for (Object selection : (Collection)evaluationContext.getDefaultVariable()) {
                        if (!(selection instanceof IFile)) continue;
                        if (leftModel == null) {
                            leftModel = (IFile)selection;
                            continue;
                        }
                        rightModel = (IFile)selection;
                    }
                }
                if (leftModel != null && rightModel != null && leftModel.isAccessible() && rightModel.isAccessible()) {
                    PublishThread publishThread = new PublishThread(leftModel, rightModel);
                    IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
                    iProgressService.busyCursorWhile((IRunnableWithProgress)publishThread);
                } else {
                    IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                    MessageDialog.openError((Shell)window.getShell(), (String)"Dita COMPARE", (String)"Unable to open model files");
                }
            }
            catch (Exception e) {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                e.printStackTrace();
                MessageDialog.openError((Shell)window.getShell(), (String)"Dita COMPARE", (String)("Error" + e.getMessage()));
            }
        }
        return null;
    }

    private static class PublishThread
    implements IRunnableWithProgress {
        private static final String DITAMAP = "<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE map PUBLIC \"-//OASIS//DTD DITA Map//EN\" \"../dtd/technicalContent/dtd/map.dtd\"><map title=\"ModelCompare\"><topicref href=\"ModelCompare.dita\" type=\"task\"></topicref></map>";
        IFile leftModel;
        IFile rightModel;

        private static String getResourceDate(Resource resource) {
            Date date = new Date(resource.getTimeStamp());
            SimpleDateFormat df2 = new SimpleDateFormat("MM/dd/yy");
            return df2.format(date);
        }

        private static Package getPackage(Resource umlResource) {
            Package packge = (Package)EcoreUtil.getObjectByType((Collection)umlResource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getPackage());
            if (packge != null) {
                return packge;
            }
            return (Package)EcoreUtil.getObjectByType((Collection)umlResource.getContents(), (EClassifier)UMLPackage.eINSTANCE.getModel());
        }

        private static void save(File file, byte[] bytes) {
            FileOutputStream fop = null;
            try {
                try {
                    fop = new FileOutputStream(file);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    byte[] contentInBytes = bytes;
                    fop.write(contentInBytes);
                    fop.flush();
                    fop.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (fop != null) {
                            fop.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (fop != null) {
                        fop.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private static void saveResults(File ditaMapFile, File ditaFile, DitaCompare compareResults) {
            PublishThread.save(ditaMapFile, DITAMAP.getBytes());
            PublishThread.save(ditaFile, compareResults.getResults().getBytes());
        }

        public PublishThread(IFile leftModel, IFile rightModel) {
            this.leftModel = leftModel;
            this.rightModel = rightModel;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emx", UMLResource.Factory.INSTANCE);
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("efx", UMLResource.Factory.INSTANCE);
            URI modelFile1 = URI.createFileURI((String)this.leftModel.getRawLocation().toOSString());
            URI modelFile2 = URI.createFileURI((String)this.rightModel.getRawLocation().toOSString());
            try {
                monitor.beginTask("Comparing " + this.leftModel.getName() + " to " + this.rightModel.getName(), 100);
                monitor.subTask("Opening " + this.leftModel.getName());
                monitor.worked(5);
                Resource umlResource1 = resourceSet.getResource(modelFile1, true);
                monitor.worked(5);
                monitor.subTask("Opening" + this.rightModel.getName());
                Resource umlResource2 = resourceSet.getResource(modelFile2, true);
                monitor.worked(5);
                Package umlPackage1 = PublishThread.getPackage(umlResource1);
                Package umlPackage2 = PublishThread.getPackage(umlResource2);
                if (umlPackage1 != null && umlPackage2 != null) {
                    monitor.subTask("Reading " + umlPackage1.getName());
                    monitor.worked(15);
                    EcoreUtil.resolveAll((EObject)umlPackage1);
                    monitor.subTask("Reading " + umlPackage2.getName());
                    monitor.worked(15);
                    EcoreUtil.resolveAll((EObject)umlPackage2);
                    DitaCompare compareResults = new DitaCompare(PublishThread.getResourceDate(umlResource1), PublishThread.getResourceDate(umlResource2), monitor);
                    ModelCompare.compare((NamedElement)umlPackage1, (NamedElement)umlPackage2, (CompareResultVisitor)compareResults);
                    IFile ditaFile = this.leftModel.getProject().getFile("ModelCompare.dita");
                    IFile ditaMapFile = this.leftModel.getProject().getFile("ModelCompare.ditamap");
                    java.net.URI ditaFileURI = ditaFile.getLocationURI();
                    if (ditaFile.isLinked()) {
                        ditaFileURI = ditaFile.getRawLocationURI();
                    }
                    java.net.URI ditaMapFileURI = ditaMapFile.getLocationURI();
                    if (ditaFile.isLinked()) {
                        ditaMapFileURI = ditaFile.getRawLocationURI();
                    }
                    PublishThread.saveResults(EFS.getStore((java.net.URI)ditaMapFileURI).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()), EFS.getStore((java.net.URI)ditaFileURI).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()), compareResults);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("Done");
        }
    }
}

