/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.views;

import java.io.ByteArrayOutputStream;
import org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer;
import org.eclipse.mdht.cda.xml.ui.handlers.AnalyzeCDAHandler;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.ViewPart;

public class MetricsView
extends ViewPart {
    Browser browser;

    public void addTableListener(Table table) {
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.item.getData() instanceof AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics) {
                    AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics metrics = (AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics)event.item.getData();
                    new ByteArrayOutputStream();
                    try {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html><head></head><body>Code Metrics<br/><table border=\"1\" width=\"400\">");
                        for (String key : metrics.codedMetrics.keySet()) {
                            sb.append("<tr><td>").append(key).append("</td><td>").append(metrics.codedMetrics.get(key)).append("</td></tr>");
                        }
                        sb.append("</table></body></html>");
                        MetricsView.this.browser.setText(sb.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void clearView() {
        this.browser.setText("");
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 2048);
        Menu menu = new Menu((Control)this.browser);
        MenuItem printMenuItem = new MenuItem(menu, 64);
        printMenuItem.setText("Print");
        printMenuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MetricsView.this.browser.execute("window.print();");
            }
        });
        this.browser.setMenu(menu);
        if (this.getSite().getPage().getPerspective() != null) {
            IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDAAnalyzer analyzer;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if ("org.eclipse.mdht.cda.xml.ui.editors.CDAAnalyzer".equals(editorReference.getId()) && (analyzer = (CDAAnalyzer)editorReference.getEditor(false)) != null) {
                    this.addTableListener(analyzer.getTable());
                }
                ++n2;
            }
        }
    }

    public void setFocus() {
    }
}

