/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import com.google.common.base.Stopwatch;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.xmlbeans.ThreadLocalUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.mdht.cda.xml.ui.Activator;
import org.eclipse.mdht.cda.xml.ui.handlers.AnalyzeCDAHandler;
import org.eclipse.mdht.cda.xml.ui.handlers.CDAValueUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.EncounterUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.GenerateCDABaseHandler;
import org.eclipse.mdht.cda.xml.ui.handlers.ProcessSectionSwitch;
import org.eclipse.mdht.cda.xml.ui.handlers.SheetHeaderUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.SigLocationSwitch;
import org.eclipse.mdht.cda.xml.ui.handlers.SigSwitch;
import org.eclipse.mdht.cda.xml.ui.handlers.SpreadsheetSerializer;
import org.eclipse.mdht.uml.cda.AssignedAuthor;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.CDAPackage;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.DocumentRoot;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.InFulfillmentOf;
import org.eclipse.mdht.uml.cda.InformationRecipient;
import org.eclipse.mdht.uml.cda.Participant1;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.ServiceEvent;
import org.eclipse.mdht.uml.cda.ui.editors.MDHTPreferences;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.cda.util.ValidationResult;
import org.eclipse.mdht.uml.hl7.datatypes.EN;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.ON;
import org.eclipse.mdht.uml.hl7.datatypes.PN;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.openhealthtools.mdht.uml.cda.consol.ConsolPackage;
import org.openhealthtools.mdht.uml.cda.consol.EncountersSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.GeneralHeaderConstraints;

public class GenerateCDADataHandler
extends GenerateCDABaseHandler {
    static HashMap<String, String> authors = new HashMap();
    private static final String CONSOLIDATED = "CONSOLIDATED";
    private static final String DIVIDER_PATTERN = "(?<=[^\\p{Lu}])(?=\\p{Lu})|(?<=[\\p{Ll}])(?=\\d)";
    static ExtractText extractText = new ExtractText();
    private static final String FILTER = "org.eclipse.mdht.cda.xml.ui.filter";
    private static final String MDHTCONSOLE = "MDHTCONSOLE";
    static HashSet<String> names = new HashSet();
    static boolean exportCDTranslations = false;
    static boolean omitDOB = false;
    static boolean omitDOD = false;
    static boolean omitUnits = false;
    static boolean omitValidation = false;
    static HashMap<String, String> organizations = new HashMap();
    static Map<String, List<String>> preferenceFilters = new HashMap<String, List<String>>();
    static String activeFilter;
    static String fileNameFilters;
    static SigSwitch sigSwitch;
    static SigLocationSwitch sigLocationSwitch;
    private static final String SPLITBYDOCUMENT = "org.eclipse.mdht.cda.xml.ui.splitbydocument";
    HashMap<Integer, EClass> documents = new HashMap();
    HashMap<Integer, HashMap<IFile, CDAValueUtil.DocumentMetadata>> documentsbyfile = new HashMap();
    protected HashMap<Integer, HashMap<String, ArrayList<IFile>>> documentsbysectionbyfile = new HashMap();
    protected HashMap<IFile, Exception> errors = new HashMap();
    int fileCount = 0;
    protected ArrayList<IFile> files = new ArrayList();
    long previousHeap = 0L;
    protected HashMap<Integer, HashMap<String, ArrayList<IFile>>> sectionbyfileByDocumentxxx = new HashMap();
    HashMap<Integer, HashMap<String, String>> sheets = new HashMap();
    HashMap<Integer, SXSSFWorkbook> workbooks = new HashMap();
    int worksheetCache;
    int documentSplitCount = 1000;
    int relatedPersonCount = 5;
    public IFile codeMetricsFile;
    boolean combinesheets = false;
    boolean countSections = true;

    static {
        sigSwitch = new SigSwitch();
        sigLocationSwitch = new SigLocationSwitch();
    }

    public static String sheetName(EClass sectionEClass) {
        String name = sectionEClass.getName();
        String[] prettyName = name.split(DIVIDER_PATTERN);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = prettyName;
        int n = prettyName.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (StringUtils.isNumeric((String)str)) {
                sb.append("(V").append(str).append(")");
            } else {
                sb.append(str).append(" ");
            }
            ++n2;
        }
        if ("CONSOL".equalsIgnoreCase(sectionEClass.getEPackage().getNsPrefix())) {
            return sb.toString();
        }
        return String.valueOf(sectionEClass.getEPackage().getNsPrefix().toUpperCase()) + " " + sb.toString();
    }

    static boolean shouldHandle(Diagnostic diagnostic) {
        return diagnostic.getMessage() != null && !diagnostic.getMessage().startsWith("Diagnosis of");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final String splitOption = event.getParameter(SPLITBYDOCUMENT);
        String filterOption = event.getParameter(FILTER);
        exportCDTranslations = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.EXPORT_CD_TRANSLATIONS_VALUE);
        omitDOB = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.OMIT_DOB_STORE_VALUE);
        omitDOD = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.OMIT_DOD_STORE_VALUE);
        omitUnits = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.OMIT_UNITS_STORE_VALUE);
        MDHTPreferences.filtersFromString((String)org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getString(MDHTPreferences.CDA_REPORT_FILTERS), preferenceFilters);
        activeFilter = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getString(MDHTPreferences.CDA_REPORT_ACTIVE_FILTER);
        fileNameFilters = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getString("fileNameFilter");
        omitValidation = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.OMIT_VALIDATION_STORE_VALUE);
        SpreadsheetSerializer.processNarrative = System.getProperty("org.eclipse.mdht.cda.xls.processnarrative") != null ? Boolean.valueOf(System.getProperty("org.eclipse.mdht.cda.xls.processnarrative")) : false;
        if (System.getProperty("org.eclipse.mdht.cda.xls.narrativesize") != null) {
            SpreadsheetSerializer.narrativeSize = Integer.valueOf(System.getProperty("org.eclipse.mdht.cda.xls.worksheetcache"));
        }
        this.worksheetCache = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().isDefault(MDHTPreferences.WORKSHEET_CACHE_VALUE) ? (System.getProperty("org.eclipse.mdht.cda.xls.worksheetcache") != null ? Integer.valueOf(System.getProperty("org.eclipse.mdht.cda.xls.worksheetcache")).intValue() : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.WORKSHEET_CACHE_VALUE)) : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.WORKSHEET_CACHE_VALUE);
        this.documentSplitCount = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().isDefault(MDHTPreferences.DOCUMENT_COUNT_VALUE) ? (System.getProperty("org.eclipse.mdht.cda.xls.documentcount") != null ? Integer.valueOf(System.getProperty("org.eclipse.mdht.cda.xls.worksheetcache")).intValue() : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.DOCUMENT_COUNT_VALUE)) : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.DOCUMENT_COUNT_VALUE);
        this.combinesheets = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().isDefault(MDHTPreferences.COMBINE_SHEETS_VALUE) ? (System.getProperty("org.eclipse.mdht.cda.xls.combinesheets") != null ? true : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.COMBINE_SHEETS_VALUE)) : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getBoolean(MDHTPreferences.COMBINE_SHEETS_VALUE);
        this.relatedPersonCount = org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().isDefault(MDHTPreferences.RELATED_PERSON_COUNT_VALUE) ? (System.getProperty("org.eclipse.mdht.cda.xls.relatedpersoncount") != null ? Integer.valueOf(System.getProperty("org.eclipse.mdht.cda.xls.relatedpersoncount")).intValue() : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.RELATED_PERSON_COUNT_VALUE)) : org.eclipse.mdht.uml.cda.ui.internal.Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.RELATED_PERSON_COUNT_VALUE);
        final HashSet<EClass> theSections = new HashSet<EClass>();
        final HashMap<EClass, HashSet<EClass>> theSectionCache = new HashMap<EClass, HashSet<EClass>>();
        if (filterOption != null) {
            IWorkbenchWindow window2 = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            ILabelProvider lp = new ILabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    EClass ec = (EClass)element;
                    String theElementName = ec.getName();
                    if (Character.isDigit(theElementName.charAt(theElementName.length() - 1))) {
                        theElementName = theElementName.substring(0, theElementName.length() - 1);
                    }
                    String[] nameArray = theElementName.split("(?=\\p{Upper})");
                    StringBuffer sb = new StringBuffer();
                    String[] stringArray = nameArray;
                    int n = nameArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String seg = stringArray[n2];
                        sb.append(seg).append(" ");
                        ++n2;
                    }
                    sb.append("(s)");
                    return sb.toString();
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
            ElementListSelectionDialog filterSelectionDialog = new ElementListSelectionDialog(window2.getShell(), lp);
            filterSelectionDialog.setTitle("Select Section");
            filterSelectionDialog.setMessage("Select a section(s):");
            filterSelectionDialog.setMultipleSelection(true);
            this.getFilterHash(theSectionCache);
            filterSelectionDialog.setElements(theSectionCache.keySet().toArray());
            if (filterSelectionDialog.open() != 0) {
                return null;
            }
            Object[] objectArray = filterSelectionDialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                theSections.add((EClass)object);
                ++n2;
            }
        } else if (filterOption == null && preferenceFilters.containsKey(activeFilter)) {
            this.getFilterHash(theSectionCache);
            for (String r : preferenceFilters.get(activeFilter)) {
                if (!theSectionCache.containsKey(ConsolPackage.eINSTANCE.getEClassifier(r))) continue;
                theSections.add((EClass)ConsolPackage.eINSTANCE.getEClassifier(r));
            }
        }
        try {
            IProject[] iProjectArray;
            boolean completed = true;
            final StringBuffer fileLocation = new StringBuffer();
            ProgressMonitorDialog pd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
            if (selection instanceof ITreeSelection) {
                ILog log;
                ITreeSelection treeSelection = (ITreeSelection)selection;
                for (Object element : treeSelection.toList()) {
                    try {
                        if (fileLocation.length() == 0) {
                            IResource resource = (IResource)element;
                            fileLocation.append(String.valueOf(resource.getParent().getLocation().toOSString()) + System.getProperty("file.separator") + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + resource.getParent().getName() + "_" + "RollupStatistics.xlsx");
                        }
                        pd.run(true, true, (IRunnableWithProgress)new ProcessSelection(element, splitOption, filterOption, theSections, theSectionCache));
                    }
                    catch (Throwable e) {
                        log = Activator.getDefault().getLog();
                        log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error generating report", e));
                    }
                }
                if (completed) {
                    log = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int e = ((IProject[])log).length;
                    int n = 0;
                    while (n < e) {
                        ILog project = log[n];
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        ++n;
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
            } else if (selection instanceof IStructuredSelection) {
                ILog log;
                final IStructuredSelection iss = (IStructuredSelection)selection;
                try {
                    pd.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                Iterator iter = iss.iterator();
                                while (iter.hasNext() && !monitor.isCanceled()) {
                                    Object o = iter.next();
                                    if (o instanceof IFolder) {
                                        IFolder folder = (IFolder)o;
                                        GenerateCDADataHandler.this.codeMetricsFile = folder.getFile("codemetrics.cfg");
                                        monitor.beginTask("Generate Spreadsheet", folder != null ? folder.members().length : 1);
                                        if (fileLocation.length() == 0) {
                                            fileLocation.append(String.valueOf(folder.getParent().getLocation().toOSString()) + System.getProperty("file.separator") + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + "RollupStatistics.xlsx");
                                        }
                                        GenerateCDADataHandler.this.processSelection(folder, null, null, monitor, splitOption, theSections, theSectionCache);
                                    }
                                    if (!(o instanceof IFile)) continue;
                                    IFile zipFile = (IFile)o;
                                    GenerateCDADataHandler.this.processSelection(null, zipFile, null, monitor, splitOption, theSections, theSectionCache);
                                }
                            }
                            catch (Throwable e) {
                                ILog log = Activator.getDefault().getLog();
                                log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error generating report", e));
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    log = Activator.getDefault().getLog();
                    log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error generating report", (Throwable)e));
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    MessageBox dialog = new MessageBox(window.getShell(), 33);
                    dialog.setText("Error processing CDA");
                    dialog.setMessage("Make sure Excel file is closed!" + e.getMessage());
                    dialog.open();
                    completed = false;
                }
                catch (InterruptedException e) {
                    log = Activator.getDefault().getLog();
                    log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error generating report", (Throwable)e));
                }
                if (completed) {
                    iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = iProjectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IProject project = iProjectArray[n3];
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        ++n3;
                    }
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
            }
            if (completed) {
                File theFile = new File(fileLocation.toString());
                if (theFile.exists()) {
                    FileUtils.touch((File)theFile);
                }
                iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IProject project = iProjectArray[n4];
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    ++n4;
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
        }
        catch (Exception e) {
            ILog log = Activator.getDefault().getLog();
            log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error generating report", (Throwable)e));
        }
        return null;
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    private LinkedHashMap<String, String> getCodedMetrics() {
        LinkedHashMap<String, String> codedMetrics;
        block18: {
            codedMetrics = new LinkedHashMap<String, String>();
            BufferedReader br = null;
            String line = "";
            String cvsSplitBy = ",";
            try {
                try {
                    if (this.codeMetricsFile != null) {
                        br = new BufferedReader(new FileReader(this.codeMetricsFile.getLocation().toOSString()));
                        while ((line = br.readLine()) != null) {
                            String[] s = line.split(cvsSplitBy);
                            if (s.length != 2) continue;
                            codedMetrics.put(s[0], s[1]);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (br == null) break block18;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (br == null) break block18;
                    try {
                        br.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return codedMetrics;
    }

    public AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics applyMetrics(ClinicalDocument cd) {
        AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics cdaMetrics = new AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics();
        try {
            LinkedHashMap<String, String> codedMetrics = this.getCodedMetrics();
            cdaMetrics.codedMetricsCount = codedMetrics.size();
            for (String key : ((HashMap)codedMetrics).keySet()) {
                String ocl = (String)((HashMap)codedMetrics).get(key);
                Object o = CDAUtil.query((EObject)cd, (String)ocl);
                if (o instanceof Collection && !((Collection)o).isEmpty()) {
                    ++cdaMetrics.totalCodedMetrics;
                    cdaMetrics.codedMetrics.put(key, Boolean.TRUE);
                    continue;
                }
                cdaMetrics.codedMetrics.put(key, Boolean.FALSE);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return cdaMetrics;
    }

    HashMap<IFile, CDAValueUtil.DocumentMetadata> getDMHash(int document, String splitOption) {
        int documentIndex = CONSOLIDATED.equals(splitOption) ? 9909 : document;
        if (!this.documentsbyfile.containsKey(documentIndex)) {
            this.documentsbyfile.put(documentIndex, new HashMap());
        }
        return this.documentsbyfile.get(documentIndex);
    }

    String getFileName(Integer eclass, String splitOption) {
        if (CONSOLIDATED.equals(splitOption)) {
            return CONSOLIDATED;
        }
        return this.documents.get(eclass).getName();
    }

    void getFilterHash(HashMap<EClass, HashSet<EClass>> theSections) {
        TreeIterator packageContents = ConsolPackage.eINSTANCE.eAllContents();
        ArrayList<EClass> packageSections = new ArrayList<EClass>();
        ArrayList<EClass> rootSections = new ArrayList<EClass>();
        while (packageContents.hasNext()) {
            EObject packageObject = (EObject)packageContents.next();
            if (!(packageObject instanceof EClass)) continue;
            EClass eClass = (EClass)packageObject;
            boolean isSection = false;
            for (EClass eClass2 : eClass.getEAllSuperTypes()) {
                if (!"Section".equals(eClass2.getName())) continue;
                isSection = true;
                break;
            }
            if (!isSection) continue;
            packageSections.add(eClass);
        }
        HashSet<EClass> sectionBaseClasses = new HashSet<EClass>();
        for (EClass section : packageSections) {
            for (EClass parentSection : section.getESuperTypes()) {
                sectionBaseClasses.add(parentSection);
            }
        }
        Comparator<EClass> compare = new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(packageSections, compare);
        for (EClass section : packageSections) {
            if (sectionBaseClasses.contains(section)) continue;
            boolean isRealRoot = true;
            for (EClass sectionAgain : packageSections) {
                if (!sectionAgain.getName().startsWith(section.getName()) || sectionAgain.getName().equals(section.getName())) continue;
                isRealRoot = false;
            }
            if (!isRealRoot) continue;
            rootSections.add(section);
        }
        for (EClass ec3 : rootSections) {
            theSections.put(ec3, new HashSet());
            theSections.get(ec3).addAll((Collection<EClass>)ec3.getEAllSuperTypes());
            theSections.get(ec3).add(ec3);
            for (EClass sectionAgain : packageSections) {
                if (!ec3.getName().startsWith(sectionAgain.getName()) || ec3.getName().equals(sectionAgain.getName())) continue;
                theSections.get(ec3).add(sectionAgain);
            }
        }
    }

    String getMemoryUssage() {
        StringBuffer sb = new StringBuffer();
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            sb.append("gc count");
            sb.append(String.valueOf(gc.getCollectionCount()));
            sb.append(System.lineSeparator());
            sb.append("gc time");
            sb.append(String.valueOf(gc.getCollectionTime()));
            sb.append(System.lineSeparator());
        }
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memHeapUsage = memBean.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = memBean.getNonHeapMemoryUsage();
        sb.append("heapInit = ");
        sb.append(String.valueOf(memHeapUsage.getInit()));
        sb.append(System.lineSeparator());
        sb.append("heapMax = ");
        sb.append(String.valueOf(memHeapUsage.getMax()));
        sb.append(System.lineSeparator());
        sb.append("heapCommit = ");
        sb.append(String.valueOf(memHeapUsage.getCommitted()));
        sb.append(System.lineSeparator());
        sb.append("heapUsed = ");
        sb.append(String.valueOf(memHeapUsage.getUsed()));
        sb.append(System.lineSeparator());
        sb.append("heapDelta = ");
        sb.append(String.valueOf(memHeapUsage.getUsed() - this.previousHeap));
        this.previousHeap = memHeapUsage.getUsed();
        sb.append(System.lineSeparator());
        sb.append("nonHeapInit = ");
        sb.append(String.valueOf(nonHeapUsage.getInit()));
        sb.append(System.lineSeparator());
        sb.append("nonHeapMax = ");
        sb.append(String.valueOf(nonHeapUsage.getMax()));
        sb.append(System.lineSeparator());
        sb.append("nonHeapCommit = ");
        sb.append(String.valueOf(nonHeapUsage.getCommitted()));
        sb.append(System.lineSeparator());
        sb.append("nonHeapUsed ");
        sb.append(String.valueOf(nonHeapUsage.getUsed()));
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public int getSectionCount(IFile file) {
        int count = 0;
        for (Integer i : this.documentsbysectionbyfile.keySet()) {
            for (String s : this.documentsbysectionbyfile.get(i).keySet()) {
                if (!this.documentsbysectionbyfile.get(i).get(s).contains(file)) continue;
                ++count;
            }
        }
        return count;
    }

    ArrayList<IFile> getSectionHash(int document, String sheetIndex, String splitOption) {
        int documentIndex = CONSOLIDATED.equals(splitOption) ? 9909 : document;
        if (!this.documentsbysectionbyfile.containsKey(documentIndex)) {
            this.documentsbysectionbyfile.put(documentIndex, new HashMap(100));
        }
        if (!this.documentsbysectionbyfile.get(documentIndex).containsKey(sheetIndex)) {
            this.documentsbysectionbyfile.get(documentIndex).put(sheetIndex, new ArrayList(this.fileCount));
        }
        ArrayList<IFile> result = this.documentsbysectionbyfile.get(documentIndex).get(sheetIndex);
        return result;
    }

    protected String getSheet(EClass document, String sectionIndex, String sheetName, String splitOption) {
        int documentIndex = CONSOLIDATED.equals(splitOption) ? 9909 : document.getClassifierID();
        if (!this.sheets.containsKey(documentIndex)) {
            this.sheets.put(documentIndex, new HashMap());
        }
        if (this.combinesheets) {
            String newkey = sheetName.split(" ")[0];
            sheetName.substring(1, sheetName.indexOf("Section") + 7);
            if (!this.sheets.get(documentIndex).containsKey(newkey)) {
                SXSSFWorkbook wb = this.getWorkbook(document, splitOption);
                SXSSFSheet newSheet = wb.createSheet(sheetName.substring(0, sheetName.indexOf("Section") + 7));
                newSheet.setRandomAccessWindowSize(10);
                this.sheets.get(documentIndex).put(newkey, newSheet.getSheetName());
            }
            return this.sheets.get(documentIndex).get(newkey);
        }
        if (!this.sheets.get(documentIndex).containsKey(sectionIndex)) {
            for (String akey : this.sheets.get(documentIndex).keySet()) {
                if (!sheetName.startsWith(this.sheets.get(documentIndex).get(akey))) continue;
                this.sheets.get(documentIndex).put(sectionIndex, this.sheets.get(documentIndex).get(akey));
                return this.sheets.get(documentIndex).get(akey);
            }
            SXSSFWorkbook wb = this.getWorkbook(document, splitOption);
            SXSSFSheet newSheet = wb.createSheet(sheetName);
            newSheet.setRandomAccessWindowSize(10);
            this.sheets.get(documentIndex).put(sectionIndex, newSheet.getSheetName());
        }
        return this.sheets.get(documentIndex).get(sectionIndex);
    }

    SXSSFWorkbook getWorkbook(EClass document, String splitOption) {
        int documentIndex = CONSOLIDATED.equals(splitOption) ? 9909 : document.getClassifierID();
        if (!this.workbooks.containsKey(documentIndex)) {
            int offset = 0;
            SXSSFWorkbook wb = new SXSSFWorkbook(this.worksheetCache);
            if (System.getProperty("org.eclipse.mdht.cda.xls.worksheetcompress") != null) {
                wb.setCompressTempFiles(true);
            }
            SXSSFSheet documentsSheet = wb.createSheet("Documents");
            documentsSheet.setRandomAccessWindowSize(10);
            SXSSFSheet sectionsSheet = wb.createSheet("Sections");
            sectionsSheet.setRandomAccessWindowSize(10);
            SXSSFSheet encountersSheet = wb.createSheet("Encounters");
            encountersSheet.setRandomAccessWindowSize(10);
            SXSSFSheet demographicsSheet = wb.createSheet("Demographics");
            demographicsSheet.setRandomAccessWindowSize(10);
            SXSSFSheet metricsSheet = wb.createSheet("Metrics");
            metricsSheet.setRandomAccessWindowSize(10);
            Row row1 = null;
            SXSSFRow row2 = documentsSheet.createRow(0);
            offset = SheetHeaderUtil.createPatientHeader(row1, (Row)row2, 0);
            SheetHeaderUtil.createPatientHeader2(row1, (Row)row2, offset);
            row1 = null;
            row2 = encountersSheet.createRow(0);
            offset = SheetHeaderUtil.createPatientHeader(row1, (Row)row2, 0);
            SheetHeaderUtil.createEncounterHeader(row1, (Row)row2, offset);
            row1 = null;
            row2 = demographicsSheet.createRow(0);
            offset = SheetHeaderUtil.createPatientHeader(row1, (Row)row2, 0);
            offset = SheetHeaderUtil.createDemographicsHeader(row1, (Row)row2, offset, this.relatedPersonCount);
            row1 = null;
            row2 = metricsSheet.createRow(0);
            offset = SheetHeaderUtil.createPatientHeader(row1, (Row)row2, 0);
            offset = SheetHeaderUtil.createDemographicsHeader(row1, (Row)row2, offset, this.relatedPersonCount);
            LinkedHashMap<String, String> codedMetrics = this.getCodedMetrics();
            for (String key : ((HashMap)codedMetrics).keySet()) {
                row2.createCell(offset++).setCellValue(key);
            }
            this.workbooks.put(documentIndex, wb);
            this.documents.put(documentIndex, document);
        }
        return this.workbooks.get(documentIndex);
    }

    void initAuthorReferences(List<Author> authors, PorO poro) {
        String result = "";
        String authorId = "";
        for (Author a : authors) {
            if (a.getAssignedAuthor() != null) {
                AssignedAuthor aa = a.getAssignedAuthor();
                if (PorO.ORGANIZATION.equals((Object)poro) && aa.getRepresentedOrganization() != null) {
                    for (ON on : aa.getRepresentedOrganization().getNames()) {
                        result = CDAValueUtil.getValues((EN)on);
                    }
                }
                if (PorO.PERSON.equals((Object)poro) && aa.getAssignedPerson() != null) {
                    for (PN pn : aa.getAssignedPerson().getNames()) {
                        result = CDAValueUtil.getValues((EN)pn);
                    }
                }
            }
            for (II ii : a.getAssignedAuthor().getIds()) {
                authorId = CDAValueUtil.getKey3(ii);
                if (StringUtils.isEmpty((String)authorId) || StringUtils.isEmpty((String)result)) continue;
                if (PorO.ORGANIZATION.equals((Object)poro)) {
                    organizations.put(authorId, result);
                    continue;
                }
                GenerateCDADataHandler.authors.put(authorId, result);
            }
        }
    }

    public static String formatSize(long v) {
        if (v < 1024L) {
            return String.valueOf(v) + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(v)) / 10;
        return String.format("%.1f %sB", (double)v / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    private static String getPath(EObject eObject) {
        String path = "";
        while (eObject != null && !(eObject instanceof DocumentRoot)) {
            EStructuralFeature feature = eObject.eContainingFeature();
            EObject container = eObject.eContainer();
            Object value = container.eGet(feature);
            if (feature.isMany()) {
                List list = (List)value;
                int index = list.indexOf(eObject) + 1;
                path = "/" + feature.getName() + "[" + index + "]" + path;
            } else {
                path = "/" + feature.getName() + "[1]" + path;
            }
            eObject = eObject.eContainer();
        }
        return path;
    }

    public void processCommandLine(String selectedFile2) throws Exception {
        HashSet<EClass> sectionFilter = new HashSet<EClass>();
        HashMap<EClass, HashSet<EClass>> theSectionCache = new HashMap<EClass, HashSet<EClass>>();
        SXSSFWorkbook rollupStats = new SXSSFWorkbook(100);
        omitValidation = true;
        this.processSelection(null, null, selectedFile2, (IProgressMonitor)new NullProgressMonitor(), CONSOLIDATED, sectionFilter, theSectionCache);
    }

    void processSelection(IFolder selectedFolder, IFile selectedFile, String selectedFile2, IProgressMonitor monitor, String splitOption, HashSet<EClass> sectionFilter, HashMap<EClass, HashSet<EClass>> theSectionCache) throws Exception {
        ZipSecureFile.setMinInflateRatio((double)1.0E-6);
        ConsolPackage.eINSTANCE.getContinuityOfCareDocument();
        this.sheets.clear();
        this.documentsbysectionbyfile.clear();
        this.documentsbyfile.clear();
        this.workbooks.clear();
        this.files.clear();
        this.errors.clear();
        this.documents.clear();
        int offset = 0;
        int filectr = 1;
        long currentProcessingTime = 1L;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Comparator<Object> c = new Comparator<Object>(){
            HashMap<IFile, Long> sizes = new HashMap();

            private Long getSize(IFile aFile) throws CoreException {
                if (!this.sizes.containsKey(aFile)) {
                    this.sizes.put(aFile, EFS.getStore((URI)aFile.getLocationURI()).fetchInfo().getLength());
                }
                return this.sizes.get(aFile);
            }

            @Override
            public int compare(Object object1, Object object2) {
                try {
                    if (this.getSize((IFile)object1) < this.getSize((IFile)object2)) {
                        return 1;
                    }
                    return -1;
                }
                catch (CoreException coreException) {
                    return 0;
                }
            }
        };
        ArrayList<IFile> documents = new ArrayList<IFile>();
        IFolder folder = null;
        Iterator<IFile> documentsIterator = null;
        String folderTarget = null;
        String folderName = null;
        if (selectedFolder != null) {
            folder = selectedFolder;
            folderTarget = String.valueOf(folder.getParent().getLocation().toOSString()) + System.getProperty("file.separator");
            folderName = folder.getName().toUpperCase();
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile) {
                    documents.add((IFile)resource);
                }
                ++n2;
            }
            Collections.sort(documents, c);
            documentsIterator = documents.iterator();
        }
        if (selectedFile != null) {
            folder = (IFolder)selectedFile.getParent();
            folderTarget = String.valueOf(folder.getParent().getLocation().toOSString()) + System.getProperty("file.separator");
            folderName = folder.getName().toUpperCase();
            documentsIterator = new ZIPIterator(selectedFile.getName(), new ZipInputStream(selectedFile.getContents()), fileNameFilters);
        }
        if (!StringUtils.isEmpty((String)selectedFile2)) {
            java.nio.file.Path zipfile = Paths.get(selectedFile2, new String[0]);
            folderTarget = String.valueOf(zipfile.getParent().toAbsolutePath().toString()) + System.getProperty("file.separator");
            folderName = zipfile.getFileName().toString().toUpperCase().replace(".ZIP", "");
            documentsIterator = new ZIPIterator(zipfile.getFileName().toString(), new ZipInputStream(Files.newInputStream(zipfile, new OpenOption[0])), fileNameFilters);
        }
        this.fileCount = documents.size() + 50;
        String fileLocation2 = String.valueOf(folderTarget) + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + folderName + "performance.log";
        String fileLocation3 = String.valueOf(folderTarget) + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + folderName + "validatation.csv";
        BufferedWriter performance = null;
        boolean omitPerformance = true;
        if (!omitPerformance) {
            performance = Files.newBufferedWriter(Paths.get(fileLocation2, new String[0]), new OpenOption[0]);
        }
        BufferedWriter validation = null;
        if (!omitValidation) {
            validation = Files.newBufferedWriter(Paths.get(fileLocation3, new String[0]), new OpenOption[0]);
            validation.write("File,Rule,XPath");
            validation.newLine();
        }
        boolean skipProcessing = false;
        boolean skipSwitch = false;
        if (System.getProperty("org.eclipse.mdht.cda.xls.skip") != null) {
            skipProcessing = true;
        }
        if (System.getProperty("org.eclipse.mdht.cda.xls.skipswitch") != null) {
            skipSwitch = true;
        }
        boolean ignoreFilter = false;
        if (System.getProperty("org.eclipse.mdht.cda.xls.ignorefilter") != null) {
            ignoreFilter = true;
        }
        int documentCounter = 0;
        int statfilectr = 0;
        int consoldocumentsprocessed = 0;
        int outpatientprogressnoteprocessed = 0;
        int dischargesummaryprocessed = 0;
        int continuityofcareprocessed = 0;
        int otherdocumentprocessed = 0;
        boolean c32documentsprocessed = false;
        int nonxmldocuments = 0;
        int documenterrors = 0;
        int totalFiles = folder != null ? folder.members().length : 1;
        while (documentsIterator.hasNext()) {
            ++statfilectr;
            ++documentCounter;
            IFile file = documentsIterator.next();
            stopwatch.reset();
            stopwatch.start();
            if (monitor.isCanceled()) {
                monitor.done();
                break;
            }
            long fileSize = 100L;
            if (file.getLocationURI() != null) {
                IFileStore fs1 = EFS.getStore((URI)file.getLocationURI());
                fileSize = fs1.fetchInfo().getLength();
            }
            if ("XML".equalsIgnoreCase(file.getFileExtension())) {
                this.files.add(file);
                monitor.worked(1);
                double estimatedTimeLeft = (double)((long)((folder != null ? folder.members().length : 1) - filectr) * (currentProcessingTime / (long)filectr)) / 1000.0;
                if (estimatedTimeLeft > 60.0) {
                    monitor.setTaskName("Processing " + file.getName() + ", " + StringUtils.leftPad((String)String.valueOf(filectr++), (int)5) + " of " + StringUtils.leftPad((String)String.valueOf(totalFiles), (int)5));
                } else {
                    monitor.setTaskName("Processing " + file.getName() + ", " + StringUtils.leftPad((String)String.valueOf(filectr++), (int)5) + " of " + StringUtils.leftPad((String)String.valueOf(totalFiles), (int)5));
                }
                try {
                    ClinicalDocument clinicalDocument = null;
                    Throwable throwable = null;
                    Object var45_52 = null;
                    try (InputStream is = file.getContents();){
                        ValidationResult vr = null;
                        if (!omitValidation) {
                            vr = new ValidationResult();
                        }
                        boolean loaded = false;
                        try {
                            clinicalDocument = CDAUtil.load((InputStream)is, (CDAUtil.ValidationHandler)vr);
                            loaded = true;
                        }
                        catch (Throwable e) {
                            ILog log = Activator.getDefault().getLog();
                            if (!omitValidation) {
                                try {
                                    clinicalDocument = CDAUtil.load((InputStream)is);
                                    log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Validation Error loading " + file.getName(), e));
                                }
                                catch (Throwable e2) {
                                    log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "XML Error loading " + file.getName(), e));
                                }
                            }
                            log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "XML Error loading " + file.getName(), e));
                        }
                        is.close();
                        if (!loaded) continue;
                        if (vr != null && !vr.getErrorDiagnostics().isEmpty()) {
                            for (Diagnostic diagnostic : vr.getErrorDiagnostics()) {
                                validation.write(String.valueOf(file.getName()) + "," + StringEscapeUtils.escapeCsv((String)diagnostic.getMessage()));
                                if (diagnostic.getData().size() > 0 && diagnostic.getData().get(0) instanceof EObject) {
                                    validation.write("," + GenerateCDADataHandler.getPath((EObject)diagnostic.getData().get(0)));
                                }
                                validation.newLine();
                            }
                            validation.flush();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    if (skipProcessing) {
                        long t = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                        String s = String.valueOf(file.getName()) + " : " + GenerateCDADataHandler.formatSize(fileSize) + " took " + (double)t / 1000.0 + " Second(s) at " + String.format("%.2f MB/S", (double)(fileSize / 0x100000L) / ((double)t / 1000.0));
                        monitor.subTask(s);
                        if (performance == null) continue;
                        performance.write(s);
                        performance.newLine();
                        performance.flush();
                        continue;
                    }
                    SXSSFWorkbook wb = this.getWorkbook(clinicalDocument.eClass(), splitOption);
                    SXSSFSheet documentsSheet = wb.getSheet("Documents");
                    SXSSFSheet demographicsSheet = wb.getSheet("Demographics");
                    Iterator<Object> encountersSheet = wb.getSheet("Encounters");
                    SXSSFSheet metricsSheet = wb.getSheet("Metrics");
                    ArrayList<Encounter> encounters = new ArrayList<Encounter>();
                    CDAUtil.Query query = new CDAUtil.Query(clinicalDocument);
                    List authors = query.getEObjects(Author.class);
                    this.initAuthorReferences(authors, PorO.ORGANIZATION);
                    this.initAuthorReferences(authors, PorO.PERSON);
                    PatientRole patientRole = (PatientRole)query.getEObject(PatientRole.class);
                    ServiceEvent serviceEvent = (ServiceEvent)query.getEObject(ServiceEvent.class);
                    InformationRecipient ir = (InformationRecipient)query.getEObject(InformationRecipient.class);
                    InFulfillmentOf iffo = (InFulfillmentOf)query.getEObject(InFulfillmentOf.class);
                    List participant = query.getEObjects(Participant1.class);
                    String fileName = file.getName();
                    CDAValueUtil.DocumentMetadata documentMetadata = SpreadsheetSerializer.appendToPatientSheet(query, (Sheet)documentsSheet, patientRole, ir, iffo, file);
                    SpreadsheetSerializer.appendToDemographicsSheet(query, demographicsSheet, documentMetadata, patientRole, participant);
                    this.getDMHash(clinicalDocument.eClass().getClassifierID(), splitOption).put(file, documentMetadata);
                    if (clinicalDocument instanceof GeneralHeaderConstraints) {
                        ++consoldocumentsprocessed;
                        switch (clinicalDocument.eClass().getClassifierID()) {
                            case 155: 
                            case 319: {
                                ++outpatientprogressnoteprocessed;
                                break;
                            }
                            case 103: 
                            case 315: {
                                ++dischargesummaryprocessed;
                                break;
                            }
                            case 23: 
                            case 313: {
                                ++continuityofcareprocessed;
                                break;
                            }
                            default: {
                                ++otherdocumentprocessed;
                            }
                        }
                        AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics metrics = this.applyMetrics(clinicalDocument);
                        SpreadsheetSerializer.appendToMetricsSheet(query, metricsSheet, documentMetadata, patientRole, participant, metrics, file.getName());
                        EncountersSectionEntriesOptional es = (EncountersSectionEntriesOptional)query.getEObject(EncountersSectionEntriesOptional.class);
                        if (es != null) {
                            encounters.addAll((Collection<Encounter>)es.getEncounterActivitiess());
                        }
                        SpreadsheetSerializer.appendToEncounterSheet(query, encountersSheet, documentMetadata, patientRole, encounters, file.getName());
                        ProcessSectionSwitch pss = new ProcessSectionSwitch(splitOption, query, wb, documentMetadata, patientRole, serviceEvent, encounters, file, this);
                        for (Section section : clinicalDocument.getSections()) {
                            if (!ignoreFilter && !sectionFilter.isEmpty()) {
                                if (CDAPackage.eINSTANCE.getSection().isInstance((Object)section)) {
                                    String code = section.getCode().getCode();
                                    if (!ProcessSectionSwitch.getCodeToSection().containsKey(code)) continue;
                                    EClass targetSectionEclass = ProcessSectionSwitch.getCodeToSection().get(code);
                                    boolean found = false;
                                    for (EClass sectionClass : sectionFilter) {
                                        if (!theSectionCache.get(sectionClass).contains(targetSectionEclass)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) continue;
                                }
                                if (!sectionFilter.contains(section.eClass())) {
                                    boolean found = false;
                                    for (EClass sectionClass : sectionFilter) {
                                        if (!theSectionCache.get(sectionClass).contains(section.eClass())) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) continue;
                                }
                            }
                            if (skipSwitch || section == null || ((Boolean)pss.doSwitch((EObject)section)).booleanValue()) continue;
                            for (II found : section.getTemplateIds()) {
                            }
                        }
                        long t = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                        String s = String.valueOf(file.getName()) + " : " + GenerateCDADataHandler.formatSize(fileSize) + " took " + (double)t / 1000.0 + " Second(s) at " + String.format("%.2f MB/S", (double)(fileSize / 0x100000L) / ((double)t / 1000.0));
                        monitor.subTask(s);
                        if (performance != null) {
                            performance.write(s);
                            performance.newLine();
                            performance.flush();
                        }
                    }
                    EncounterUtil.encounterCache.clear();
                    EcoreUtil.deleteAll((Collection)clinicalDocument.eContents(), (boolean)true);
                    clinicalDocument.eResource().unload();
                    currentProcessingTime += stopwatch.elapsed(TimeUnit.MILLISECONDS);
                    int sheetNumber = wb.getNumberOfSheets();
                    int i = 0;
                    while (i < sheetNumber) {
                        try {
                            wb.getSheetAt(i).flushRows();
                        }
                        catch (IllegalArgumentException iae) {
                            System.err.println(i);
                        }
                        ++i;
                    }
                    clinicalDocument = null;
                }
                catch (Exception exception) {
                    ++documenterrors;
                    ILog log = Activator.getDefault().getLog();
                    log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error processing file " + file.getName(), (Throwable)exception));
                    this.errors.put(file, exception);
                }
            } else {
                ++nonxmldocuments;
            }
            stopwatch.stop();
            if (documentCounter % this.documentSplitCount != 0) continue;
            this.saveTheWorkbooks(splitOption, selectedFile, folderTarget, monitor, sectionFilter, folder, folderName, documentCounter);
            this.workbooks.clear();
        }
        monitor.beginTask("Generate Spreadsheet", folder != null ? folder.members().length : 1);
        for (Integer eClass : this.workbooks.keySet()) {
            HashMap<String, ArrayList<Object>> sectionbyfile = this.documentsbysectionbyfile.get(eClass);
            if (sectionbyfile == null) {
                sectionbyfile = new HashMap();
            }
            SXSSFWorkbook wb = this.workbooks.get(eClass);
            SXSSFSheet sectionsSheet = wb.getSheet("Sections");
            ArrayList<String> sortedKeys = new ArrayList<String>(sectionbyfile.keySet());
            Collections.sort(sortedKeys);
            SXSSFRow row1 = sectionsSheet.createRow(sectionsSheet.getPhysicalNumberOfRows());
            offset = 0;
            int metadataoffset = offset = SheetHeaderUtil.createDocumentMedadataHeadder((Row)row1, offset++);
            for (String sectionclass : sortedKeys) {
                SXSSFCell cell = row1.createCell(offset++);
                cell.setCellValue(sectionclass);
            }
            row1 = sectionsSheet.createRow(sectionsSheet.getPhysicalNumberOfRows());
            for (String sectionclass : sortedKeys) {
                SXSSFCell cell = row1.createCell(metadataoffset++);
                String columnLetter = CellReference.convertNumToColString((int)cell.getColumnIndex());
                String strFormula = "COUNTIF(" + columnLetter + "3:" + columnLetter + (this.files.size() + 2) + ",\"X\")";
                cell.setCellFormula(strFormula);
            }
            for (IFile file : this.files) {
                if (!this.getDMHash(eClass, splitOption).containsKey(file)) continue;
                offset = 0;
                row1 = sectionsSheet.createRow(sectionsSheet.getPhysicalNumberOfRows());
                CDAValueUtil.DocumentMetadata documentMetadata = this.getDMHash(eClass, splitOption).get(file);
                offset = SpreadsheetSerializer.serializeDocumentMetadata((Row)row1, offset, documentMetadata);
                row1.getRowNum();
                for (String sectionclass : sortedKeys) {
                    if (sectionbyfile.get(sectionclass).contains(file)) {
                        SXSSFCell cell = row1.createCell(offset++);
                        cell.setCellValue("X");
                        continue;
                    }
                    row1.createCell(offset++).setCellValue("");
                }
            }
            String fileLocation = "";
            fileLocation = selectedFile != null ? String.valueOf(folderTarget) + System.getProperty("file.separator") + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + selectedFile.getName().toUpperCase().replace(".ZIP", "") + this.getFileName(eClass, splitOption) + "_SA.xlsx" : String.valueOf(folderTarget) + System.getProperty("file.separator") + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + folderName + this.getFileName(eClass, splitOption) + "_SA.xlsx";
            File theFile = new File(fileLocation);
            if (theFile.exists()) {
                FileUtils.touch((File)theFile);
            }
            monitor.subTask("Serializing  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + fileLocation);
            if (theFile.exists()) {
                FileUtils.touch((File)theFile);
            }
            if (!sectionFilter.isEmpty()) {
                wb.removeSheetAt(wb.getSheetIndex("Metrics"));
                wb.removeSheetAt(wb.getSheetIndex("Sections"));
                wb.removeSheetAt(wb.getSheetIndex("Encounters"));
            }
            Throwable throwable = null;
            Object var49_65 = null;
            try (OutputStream fileOut = Files.newOutputStream(Paths.get(fileLocation, new String[0]), new OpenOption[0]);){
                wb.write(fileOut);
                fileOut.close();
                wb.close();
                wb.dispose();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            monitor.subTask("Flushing Memory  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + (folder != null ? folder.getName().toUpperCase() : "XXX") + "_SA.xlsx");
            monitor.subTask("Reloading  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + (folder != null ? folder.getName().toUpperCase() : "XXX") + "_SA.xlsx");
            monitor.subTask("Completed Saving  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + (folder != null ? folder.getName().toUpperCase() : "XXX") + "_SA.xlsx");
        }
        ThreadLocalUtil.clearAllThreadLocals();
        if (performance != null) {
            performance.close();
        }
        if (validation != null) {
            validation.close();
        }
    }

    boolean shouldCountSection(Section section) {
        if (this.countSections && section.isNullFlavorUndefined()) {
            if (!section.getEntries().isEmpty()) {
                return true;
            }
            if (section.getText() != null && section.getText().getText() != null && section.getText().getText().length() > 50) {
                return true;
            }
        }
        return false;
    }

    void saveTheWorkbooks(String splitOption, IFile selectedFile, String folderTarget, IProgressMonitor monitor, HashSet<EClass> sectionFilter, IFolder folder, String folderName, int documentCounter) throws Exception, Exception {
        this.sheets.clear();
        for (Integer eClass : this.workbooks.keySet()) {
            SXSSFCell cell;
            HashMap<String, ArrayList<Object>> sectionbyfile = this.documentsbysectionbyfile.get(eClass);
            if (sectionbyfile == null) {
                sectionbyfile = new HashMap();
            }
            SXSSFWorkbook wb = this.workbooks.get(eClass);
            SXSSFSheet sectionsSheet = wb.getSheet("Sections");
            ArrayList<String> sortedKeys = new ArrayList<String>(sectionbyfile.keySet());
            Collections.sort(sortedKeys);
            SXSSFRow row1 = sectionsSheet.createRow(sectionsSheet.getPhysicalNumberOfRows());
            int offset = 0;
            int metadataoffset = offset = SheetHeaderUtil.createDocumentMedadataHeadder((Row)row1, offset++);
            for (String sectionclass : sortedKeys) {
                cell = row1.createCell(offset++);
                cell.setCellValue(sectionclass);
            }
            row1 = sectionsSheet.createRow(sectionsSheet.getPhysicalNumberOfRows());
            for (String sectionclass : sortedKeys) {
                cell = row1.createCell(metadataoffset++);
                String columnLetter = CellReference.convertNumToColString((int)cell.getColumnIndex());
                String strFormula = "COUNTIF(" + columnLetter + "3:" + columnLetter + (this.files.size() + 2) + ",\"X\")";
                cell.setCellFormula(strFormula);
            }
            for (IFile file : this.files) {
                if (!this.getDMHash(eClass, splitOption).containsKey(file)) continue;
                offset = 0;
                row1 = sectionsSheet.createRow(sectionsSheet.getPhysicalNumberOfRows());
                CDAValueUtil.DocumentMetadata documentMetadata = this.getDMHash(eClass, splitOption).get(file);
                offset = SpreadsheetSerializer.serializeDocumentMetadata((Row)row1, offset, documentMetadata);
                row1.getRowNum();
                for (String sectionclass : sortedKeys) {
                    if (sectionbyfile.get(sectionclass).contains(file)) {
                        SXSSFCell cell2 = row1.createCell(offset++);
                        cell2.setCellValue("X");
                        continue;
                    }
                    row1.createCell(offset++).setCellValue("");
                }
            }
            String fileLocation = "";
            fileLocation = selectedFile != null ? String.valueOf(folderTarget) + System.getProperty("file.separator") + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + selectedFile.getName().toUpperCase().replace(".ZIP", "") + this.getFileName(eClass, splitOption) + "_SA" + documentCounter + ".xlsx" : String.valueOf(folderTarget) + System.getProperty("file.separator") + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + folderName + this.getFileName(eClass, splitOption) + "_SA" + documentCounter + ".xlsx";
            File theFile = new File(fileLocation);
            if (theFile.exists()) {
                FileUtils.touch((File)theFile);
            }
            monitor.subTask("Serializing  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + fileLocation);
            if (theFile.exists()) {
                FileUtils.touch((File)theFile);
            }
            if (!sectionFilter.isEmpty()) {
                wb.removeSheetAt(wb.getSheetIndex("Metrics"));
                wb.removeSheetAt(wb.getSheetIndex("Sections"));
                wb.removeSheetAt(wb.getSheetIndex("Encounters"));
            }
            Throwable throwable = null;
            Object var21_22 = null;
            try (OutputStream fileOut = Files.newOutputStream(Paths.get(fileLocation, new String[0]), new OpenOption[0]);){
                wb.write(fileOut);
                fileOut.close();
                wb.close();
                wb.dispose();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            monitor.subTask("Flushing Memory  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + (folder != null ? folder.getName().toUpperCase() : "XXX") + "_SA.xlsx");
            monitor.subTask("Reloading  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + (folder != null ? folder.getName().toUpperCase() : "XXX") + "_SA.xlsx");
            monitor.subTask("Completed Saving  " + CDAValueUtil.DATE_FORMAT3.format(new Date()) + "_" + (folder != null ? folder.getName().toUpperCase() : "XXX") + "_SA.xlsx");
        }
        ThreadLocalUtil.clearAllThreadLocals();
    }

    protected static class ExtractText
    extends HTMLEditorKit.ParserCallback {
        StringBuffer txt = new StringBuffer();

        String getText() {
            String result = this.txt.toString();
            if (StringUtils.isEmpty((String)result)) {
                return "";
            }
            if (result.length() < 50) {
                return result;
            }
            return result.substring(0, 49);
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.txt.append(text);
        }
    }

    protected static enum PorO {
        ORGANIZATION,
        PERSON;

    }

    class ProcessSelection
    implements IRunnableWithProgress {
        Object object;
        String splitOption;
        String filterOption;
        HashSet<EClass> theSections;
        HashMap<EClass, HashSet<EClass>> theSectionCache;
        SXSSFWorkbook rollupStats;

        public ProcessSelection(Object object, String splitOption, String filterOption, HashSet<EClass> theSections, HashMap<EClass, HashSet<EClass>> theSectionCache) {
            this.object = object;
            this.splitOption = splitOption;
            this.filterOption = filterOption;
            this.theSections = theSections;
            this.theSectionCache = theSectionCache;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                if (this.object instanceof IFolder) {
                    IFolder folder = (IFolder)this.object;
                    GenerateCDADataHandler.this.codeMetricsFile = folder.getFile("codemetrics.cfg");
                    monitor.beginTask("Generate Spreadsheet", folder != null ? folder.members().length : 1);
                    GenerateCDADataHandler.this.processSelection(folder, null, null, monitor, this.splitOption, this.theSections, this.theSectionCache);
                }
                if (this.object instanceof IFile) {
                    IFile zipFile = (IFile)this.object;
                    GenerateCDADataHandler.this.processSelection(null, zipFile, null, monitor, this.splitOption, this.theSections, this.theSectionCache);
                }
            }
            catch (Exception e) {
                ILog log = Activator.getDefault().getLog();
                log.log((IStatus)new Status(4, "org.eclipse.mdht.cda.xml.ui", "Error generating report", (Throwable)e));
            }
        }
    }

    public class ResultsDialog
    extends TitleAreaDialog {
        Table table;

        public ResultsDialog(Shell shell) {
            super(shell);
        }

        public void create() {
            super.create();
            this.setTitle("CDA Processing Results");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, "Ok", false);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResultsDialog.this.setReturnCode(0);
                    ResultsDialog.this.close();
                }
            });
        }

        protected Control createDialogArea(Composite parent) {
            Label label = new Label(parent, 2048);
            label.setText("Total Files " + GenerateCDADataHandler.this.files.size());
            ScrolledComposite composite = new ScrolledComposite(parent, 512);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table = new Table((Composite)composite, 2050);
            this.table.setHeaderVisible(true);
            this.table.setSize(100, 100);
            composite.setContent((Control)this.table);
            composite.setExpandHorizontal(true);
            composite.setExpandVertical(true);
            composite.setAlwaysShowScrollBars(true);
            composite.setMinSize(this.table.computeSize(-1, -1));
            this.table.setLinesVisible(true);
            GridData gridData = new GridData();
            gridData.widthHint = 500;
            this.table.setLayoutData((Object)gridData);
            this.table.setHeaderVisible(true);
            TableColumn column1 = new TableColumn(this.table, 16384);
            TableColumn column2 = new TableColumn(this.table, 16384);
            column1.setText("File Name");
            column2.setText("Total Sections");
            column1.setWidth(250);
            column2.setWidth(250);
            for (IFile file : GenerateCDADataHandler.this.files) {
                TableItem valueSetsUpdatedItem = new TableItem(this.table, 0);
                if (GenerateCDADataHandler.this.errors.containsKey(file)) {
                    valueSetsUpdatedItem.setText(new String[]{file.getName(), GenerateCDADataHandler.this.errors.get(file).getMessage()});
                    continue;
                }
                int sectionCount = GenerateCDADataHandler.this.getSectionCount(file);
                valueSetsUpdatedItem.setText(new String[]{file.getName(), String.valueOf(sectionCount)});
            }
            return composite;
        }
    }

    public static class WrapperForZipEnty
    implements IFile {
        ZipFile zipFile;
        ZipEntry zipEntry;
        ZipInputStream zipInputStream;
        String prefix = "";

        public WrapperForZipEnty(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public WrapperForZipEnty(String prefix, ZipEntry zipEntry, ZipInputStream zipInputStream) {
            this.prefix = prefix;
            this.zipEntry = zipEntry;
            this.zipInputStream = zipInputStream;
        }

        public int getType() {
            return 0;
        }

        public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public String getCharset() throws CoreException {
            return null;
        }

        public String getCharset(boolean checkImplicit) throws CoreException {
            return null;
        }

        public String getCharsetFor(Reader reader) throws CoreException {
            return null;
        }

        public IContentDescription getContentDescription() throws CoreException {
            return null;
        }

        public InputStream getContents() throws CoreException {
            try {
                if (this.zipInputStream != null) {
                    byte[] buffer = ByteStreams.toByteArray((InputStream)this.zipInputStream);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
                    return byteArrayInputStream;
                }
                return this.zipFile.getInputStream(this.zipEntry);
            }
            catch (IOException e) {
                throw new CoreException(null);
            }
        }

        public InputStream getContents(boolean force) throws CoreException {
            return null;
        }

        public int getEncoding() throws CoreException {
            return 0;
        }

        public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
            return null;
        }

        public void setCharset(String newCharset) throws CoreException {
        }

        public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        }

        public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
        }

        public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        }

        public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        }

        public void clearHistory(IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public IMarker createMarker(String type) throws CoreException {
            return null;
        }

        public IResourceProxy createProxy() {
            return null;
        }

        public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        }

        public boolean exists() {
            return false;
        }

        public IMarker findMarker(long id) throws CoreException {
            return null;
        }

        public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
            return null;
        }

        public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
            return 0;
        }

        public String getFileExtension() {
            return FilenameUtils.getExtension((String)this.zipEntry.getName());
        }

        public long getLocalTimeStamp() {
            return 0L;
        }

        public IPath getLocation() {
            return null;
        }

        public URI getLocationURI() {
            return null;
        }

        public IMarker getMarker(long id) {
            return null;
        }

        public long getModificationStamp() {
            return 0L;
        }

        public IPathVariableManager getPathVariableManager() {
            return null;
        }

        public IContainer getParent() {
            return null;
        }

        public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
            return null;
        }

        public String getPersistentProperty(QualifiedName key) throws CoreException {
            return null;
        }

        public IProject getProject() {
            return null;
        }

        public IPath getProjectRelativePath() {
            return null;
        }

        public IPath getRawLocation() {
            return null;
        }

        public URI getRawLocationURI() {
            return null;
        }

        public ResourceAttributes getResourceAttributes() {
            return null;
        }

        public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
            return null;
        }

        public Object getSessionProperty(QualifiedName key) throws CoreException {
            return null;
        }

        public IWorkspace getWorkspace() {
            return null;
        }

        public boolean isAccessible() {
            return false;
        }

        public boolean isDerived() {
            return false;
        }

        public boolean isDerived(int options) {
            return false;
        }

        public boolean isHidden() {
            return false;
        }

        public boolean isHidden(int options) {
            return false;
        }

        public boolean isLinked() {
            return false;
        }

        public boolean isVirtual() {
            return false;
        }

        public boolean isLinked(int options) {
            return false;
        }

        public boolean isLocal(int depth) {
            return false;
        }

        public boolean isPhantom() {
            return false;
        }

        public boolean isSynchronized(int depth) {
            return false;
        }

        public boolean isTeamPrivateMember() {
            return false;
        }

        public boolean isTeamPrivateMember(int options) {
            return false;
        }

        public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        }

        public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        }

        public void revertModificationStamp(long value) throws CoreException {
        }

        public void setDerived(boolean isDerived) throws CoreException {
        }

        public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
        }

        public void setHidden(boolean isHidden) throws CoreException {
        }

        public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        }

        public long setLocalTimeStamp(long value) throws CoreException {
            return 0L;
        }

        public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        }

        public void setReadOnly(boolean readOnly) {
        }

        public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        }

        public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        }

        public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        }

        public void touch(IProgressMonitor monitor) throws CoreException {
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }

        public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        }

        public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }

        public IPath getFullPath() {
            Path path = new Path(this.prefix);
            return path;
        }

        public String getName() {
            return FilenameUtils.getName((String)this.zipEntry.getName());
        }

        public boolean isReadOnly() {
            return false;
        }

        public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        }
    }

    public static class ZIPIterator
    implements Iterator<IFile> {
        Stack<ZipInputStream> zipInputStreams = new Stack();
        WrapperForZipEnty wrapper = null;
        String filesFilter;
        String fileName;

        public ZIPIterator(String fileName, ZipInputStream zipInputStream, String filesFilter) {
            this.fileName = fileName;
            this.zipInputStreams.push(zipInputStream);
            this.filesFilter = !StringUtils.isEmpty((String)filesFilter) ? filesFilter : "C62TXT";
        }

        boolean walkZipFile(String prefix) {
            while (!this.zipInputStreams.isEmpty()) {
                block5: {
                    ZipEntry entry;
                    ZipInputStream zipInputStream;
                    block6: {
                        zipInputStream = this.zipInputStreams.peek();
                        entry = null;
                        this.wrapper = null;
                        entry = zipInputStream.getNextEntry();
                        if (entry == null) break block5;
                        if (entry.isDirectory()) continue;
                        if (!"XML".equalsIgnoreCase(FilenameUtils.getExtension((String)entry.getName())) || entry.getName().contains(this.filesFilter)) break block6;
                        this.wrapper = new WrapperForZipEnty(prefix, entry, zipInputStream);
                        return true;
                    }
                    if (!"ZIP".equalsIgnoreCase(FilenameUtils.getExtension((String)entry.getName()))) continue;
                    ZipInputStream embeddedZipInputStream = new ZipInputStream(zipInputStream);
                    this.zipInputStreams.push(embeddedZipInputStream);
                    if (!this.walkZipFile(String.valueOf(prefix) + "/" + FilenameUtils.getBaseName((String)entry.getName()))) continue;
                    return true;
                }
                try {
                    ZipInputStream done = this.zipInputStreams.pop();
                    done.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.walkZipFile(FilenameUtils.getBaseName((String)this.fileName));
        }

        @Override
        public IFile next() {
            return this.wrapper;
        }
    }
}

