/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.cda.core.profile.Inline;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.ui.properties.sections.ResettableModelerPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class InlineSection
extends ResettableModelerPropertySection {
    protected Element modelElement;
    private Button isInlinePublication;
    private boolean isInlinePublicationModified = false;
    private Text filterText;
    private boolean isFilterTextModified = false;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (InlineSection.this.filterText == event.getSource()) {
                InlineSection.this.isFilterTextModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                InlineSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            InlineSection.this.modifyFields();
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Class));
        this.modelElement = (Class)element;
    }

    protected void modifyFields() {
        if (!this.isInlinePublicationModified && !this.isFilterTextModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.modelElement);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    Inline inline;
                    Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)InlineSection.this.modelElement, (String)"CDATemplate");
                    if (stereotype == null) {
                        stereotype = CDAProfileUtil.applyCDAStereotype((Element)InlineSection.this.modelElement, (String)"Inline");
                    }
                    if (InlineSection.this.isInlinePublicationModified) {
                        InlineSection.this.isInlinePublicationModified = false;
                        inline = CDAProfileUtil.getInline((Class)((Class)InlineSection.this.modelElement));
                        if (inline != null) {
                            inline.setPublishSeperately(InlineSection.this.isInlinePublication.getSelection());
                        }
                    }
                    if (InlineSection.this.isFilterTextModified) {
                        InlineSection.this.isFilterTextModified = false;
                        inline = CDAProfileUtil.getInline((Class)((Class)InlineSection.this.modelElement));
                        if (inline != null) {
                            inline.setFilter(InlineSection.this.filterText.getText());
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Group composite = this.getWidgetFactory().createGroup(parent, "Inline Section");
        FormLayout layout = new FormLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 4;
        layout.spacing = 7;
        composite.setLayout((Layout)layout);
        FormData data = null;
        this.filterText = this.getWidgetFactory().createText((Composite)composite, "");
        CLabel filterLabel = this.getWidgetFactory().createCLabel((Composite)composite, "Filter : ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.filterText, 0, 0x1000000);
        filterLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)filterLabel, 0);
        data.width = 200;
        data.top = new FormAttachment(0, 2, 4);
        this.filterText.setLayoutData((Object)data);
        this.isInlinePublication = this.getWidgetFactory().createButton((Composite)composite, "Publish As Separate Topic", 32);
        this.isInlinePublication.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                InlineSection.this.isInlinePublicationModified = true;
                InlineSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                InlineSection.this.isInlinePublicationModified = true;
                InlineSection.this.modifyFields();
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)this.filterText, 5);
        data.top = new FormAttachment((Control)this.isInlinePublication, 0, 0x1000000);
        this.isInlinePublication.setLayoutData((Object)data);
        this.createRestoreDefaultsButton((Composite)composite);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.isInlinePublication, 0, 131072);
        this.restoreDefaultsButton.setLayoutData((Object)data);
    }

    public void refresh() {
        super.refresh();
        Inline inline = CDAProfileUtil.getInline((Class)((Class)this.modelElement));
        if (inline != null) {
            this.isInlinePublication.setSelection(inline.isPublishSeperately());
        } else {
            this.isInlinePublication.setSelection(false);
        }
        this.filterText.removeModifyListener(this.modifyListener);
        this.filterText.removeKeyListener(this.keyListener);
        this.filterText.removeFocusListener(this.focusListener);
        if (inline != null) {
            this.filterText.setText(inline.getFilter() != null ? inline.getFilter() : "");
        } else {
            this.filterText.setText("");
        }
        this.filterText.addModifyListener(this.modifyListener);
        this.filterText.addKeyListener(this.keyListener);
        this.filterText.addFocusListener(this.focusListener);
    }

    protected void resetFields() {
    }
}

