/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.osgi.framework.Bundle;

public class ImportDitaReferences
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    private ISelection selection;

    public static void importDitaProject(IWorkspace workspace, IProject includeFrom, IProject selectedProject) {
        IFolder ditaFolder = selectedProject.getFolder("dita/classes/" + includeFrom.getName());
        if (includeFrom.getFolder("dita/classes/").exists()) {
            try {
                if (ditaFolder.exists()) {
                    ditaFolder.delete(true, null);
                }
                ditaFolder.create(true, true, null);
                IResource[] resources = new IResource[]{includeFrom.getFolder("dita/classes/")};
                workspace.copy(resources, workspace.getRoot().getFolder(ditaFolder.getFullPath()).getFullPath(), true, null);
                ImportDitaReferences.fixRelativePaths(workspace.getRoot().getFolder(ditaFolder.getFullPath()).getLocation().toFile());
                selectedProject.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private static void fixRelativePaths(File dir) {
        if (dir.list() != null) {
            String[] stringArray = dir.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                try {
                    String fixedContents;
                    String contents;
                    File file = new File(dir, child);
                    if (child.endsWith(".dita") && !(contents = CDACommonUtils.stringFromFile((File)file)).equals(fixedContents = contents.replace("<xref href=\"../../terminology/", "<xref href=\"../../../../terminology/"))) {
                        CDACommonUtils.stringToFile((String)fixedContents, (File)file);
                    }
                    ImportDitaReferences.fixRelativePaths(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject selectedProject = null;
                if (element instanceof IProject) {
                    selectedProject = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    selectedProject = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (selectedProject == null) continue;
                LabelProvider projectLabelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        IProject p = (IProject)element;
                        return p.getName();
                    }
                };
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.activePart.getSite().getShell(), (ILabelProvider)projectLabelProvider);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                ArrayList projects = new ArrayList();
                Collections.addAll(projects, workspace.getRoot().getProjects());
                final String selectedProjectName = selectedProject.getName();
                Predicate<IProject> predicate = new Predicate<IProject>(){

                    public boolean apply(IProject arg0) {
                        return arg0.getName() != null && arg0.getName().endsWith(".doc") && !selectedProjectName.equals(arg0.getName());
                    }
                };
                Collection docProjects = Collections2.filter(projects, (Predicate)predicate);
                dialog.setMultipleSelection(true);
                dialog.setElements((Object[])docProjects.toArray(new IProject[docProjects.size()]));
                dialog.setTitle("Dita Projects to Import");
                dialog.open();
                dialog.getResult();
                if (dialog.getReturnCode() != 0) continue;
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    ImportDitaReferences.importDitaProject(workspace, (IProject)object, selectedProject);
                    ++n2;
                }
                try {
                    this.importReferences(selectedProject);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    public void selectionChanged(IAction arg0, ISelection selection) {
        this.selection = selection;
    }

    void importReferences(IProject project) throws Exception {
        CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.activePart.getSite().getShell());
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mdht.uml.cda.ui");
        ArrayList<URI> elements = new ArrayList<URI>();
        Enumeration entries = bundle.findEntries("resources/dita/content", "References.dita", true);
        while (entries.hasMoreElements()) {
            elements.add(FileLocator.toFileURL((URL)new URL(bundle.getEntry("/"), ((URL)entries.nextElement()).getPath())).toURI());
        }
        URI[] ditauris = new URI[elements.size()];
        elements.toArray(ditauris);
        copyOperation.copyFiles(ditauris, (IContainer)project.getFolder((IPath)new Path("dita/content")));
        entries = bundle.findEntries("resources/dita/content", "content.ditamap", true);
        while (entries.hasMoreElements()) {
            elements.add(FileLocator.toFileURL((URL)new URL(bundle.getEntry("/"), ((URL)entries.nextElement()).getPath())).toURI());
        }
        ditauris = new URI[elements.size()];
        elements.toArray(ditauris);
        copyOperation.copyFiles(ditauris, (IContainer)project.getFolder((IPath)new Path("dita/content")));
    }
}

