/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public class CompareTemplateAction
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    protected ISelection currentSelection;
    protected Class selectedElement;
    protected Package selectedPackage;

    private static void appendAggregateRules(PrintWriter writer, Class umlClass) {
        Class parent;
        Package xrefSource = UMLUtil.getTopPackage((Element)umlClass);
        ArrayList<Class> allParents = new ArrayList<Class>((Collection<Class>)umlClass.allParents());
        allParents.add(0, umlClass);
        ArrayList<Property> allProperties = new ArrayList<Property>();
        ArrayList<Property> allAttributes = new ArrayList<Property>();
        ArrayList<Constraint> allConstraints = new ArrayList<Constraint>();
        int i = allParents.size() - 1;
        while (i >= 0) {
            parent = (Class)allParents.get(i);
            if (!CDAModelUtil.isCDAModel((Element)parent)) {
                for (Property property : parent.getOwnedAttributes()) {
                    int index = CompareTemplateAction.findProperty(allProperties, property.getName());
                    if (index >= 0) {
                        allProperties.set(index, property);
                        continue;
                    }
                    allProperties.add(property);
                }
            }
            --i;
        }
        i = allParents.size() - 1;
        while (i >= 0) {
            parent = (Class)allParents.get(i);
            for (Constraint constraint : parent.getOwnedRules()) {
                allConstraints.add(constraint);
            }
            --i;
        }
        writer.println("");
        i = allParents.size() - 1;
        while (i > 0) {
            parent = (Class)allParents.get(i);
            String message = CDAModelUtil.computeGeneralizationConformanceMessage((Class)parent, (boolean)false, (Package)xrefSource);
            if (message.length() > 0) {
                writer.println(message);
                writer.println("");
            }
            --i;
        }
        for (Property property : allProperties) {
            if (!CDAModelUtil.isXMLAttribute((Property)property)) continue;
            allAttributes.add(property);
        }
        allProperties.removeAll(allAttributes);
        Collections.sort(allAttributes, new NamedElementComparator());
        writer.println("");
        for (Property property : allAttributes) {
            writer.println(String.valueOf(CompareTemplateAction.modelPrefix((NamedElement)property)) + CDAModelUtil.computeConformanceMessage((Property)property, (boolean)false, (Package)xrefSource));
            writer.println("");
        }
        writer.println("");
        for (Property property : allProperties) {
            writer.println(String.valueOf(CompareTemplateAction.modelPrefix((NamedElement)property)) + CDAModelUtil.computeConformanceMessage((Property)property, (boolean)false, (Package)xrefSource));
            writer.println("");
        }
        writer.println("");
        for (Constraint constraint : allConstraints) {
            writer.println(String.valueOf(CompareTemplateAction.modelPrefix((NamedElement)constraint)) + CDAModelUtil.computeConformanceMessage((Constraint)constraint, (boolean)false));
            writer.println("");
        }
    }

    private static int findProperty(List<Property> properties, String name) {
        if (name != null) {
            int i = 0;
            while (i < properties.size()) {
                if (name.equals(properties.get(i).getName())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private static String modelPrefix(NamedElement element) {
        StringBuffer prefix = new StringBuffer();
        String modelPrefix = CDAModelUtil.getModelPrefix((Element)element);
        if (modelPrefix != null && modelPrefix.length() > 0) {
            prefix.append("[");
            prefix.append(modelPrefix);
            prefix.append("] ");
        }
        return prefix.toString();
    }

    protected View getSelectedView() {
        for (Object element : (IStructuredSelection)this.currentSelection) {
            View view = (View)((IAdaptable)element).getAdapter(View.class);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    public void run(IAction action) {
        Class compareTarget;
        if (this.selectedElement != null && (compareTarget = (Class)DialogLaunchUtil.chooseElement((java.lang.Class[])new java.lang.Class[]{Class.class}, (ResourceSet)this.selectedElement.eResource().getResourceSet(), (Shell)this.activePart.getSite().getShell())) != null) {
            StringWriter leftsw = new StringWriter();
            PrintWriter leftpw = new PrintWriter(leftsw);
            CompareTemplateAction.appendAggregateRules(leftpw, this.selectedElement);
            StringBuffer leftsb = leftsw.getBuffer();
            StringWriter rightsw = new StringWriter();
            PrintWriter rightpw = new PrintWriter(rightsw);
            CompareTemplateAction.appendAggregateRules(rightpw, compareTarget);
            StringBuffer rightsb = rightsw.getBuffer();
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftLabel("Constraints as defined by " + this.selectedElement.getQualifiedName());
            cc.setRightLabel("Constraints as defined by " + compareTarget.getQualifiedName());
            cc.setLeftEditable(false);
            cc.setRightEditable(false);
            CompareUI.openCompareDialog((CompareEditorInput)new CompareInput(cc, this.selectedElement.getQualifiedName(), leftsb.toString(), compareTarget.getQualifiedName(), rightsb.toString()));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
        this.selectedElement = null;
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof View) {
                selected = ((View)selected).getElement();
            }
            if (selected instanceof Class) {
                this.selectedElement = (Class)selected;
            }
        }
        if (this.selectedElement != null && CDAProfileUtil.getAppliedCDAProfile((Element)this.selectedElement) != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }

    public static class CompareInput
    extends CompareEditorInput {
        String leftSource;
        String leftTemplate;
        String rightSource;
        String rightTemplate;

        public CompareInput(CompareConfiguration compareConfiguration, String leftSource, String leftTemplate, String rightSource, String rightTemplate) {
            super(compareConfiguration);
            this.leftSource = leftSource;
            this.leftTemplate = leftTemplate;
            this.rightSource = rightSource;
            this.rightTemplate = rightTemplate;
            this.setTitle("MDHT CDA Template Comparison");
        }

        protected Object prepareInput(IProgressMonitor pm) {
            CompareItem left = new CompareItem(this.leftSource, this.leftTemplate, 0L);
            CompareItem right = new CompareItem(this.rightSource, this.rightTemplate, 0L);
            DiffNode foo = new DiffNode((ITypedElement)left, (ITypedElement)right);
            return foo;
        }
    }

    public static class CompareItem
    implements IStreamContentAccessor,
    ITypedElement,
    IModificationDate {
        private String contents;
        private String name;
        private long time;

        CompareItem(String name, String contents, long time) {
            this.name = name;
            this.contents = contents;
            this.time = time;
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.contents.getBytes());
        }

        public Image getImage() {
            return null;
        }

        public long getModificationDate() {
            return this.time;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.contents;
        }

        public String getType() {
            return "???";
        }
    }
}

