/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.EncompassingEncounter;
import org.eclipse.mdht.uml.cda.Patient;
import org.eclipse.mdht.uml.cda.Person;
import org.eclipse.mdht.uml.cda.PlayingEntity;
import org.eclipse.mdht.uml.cda.Subject;
import org.eclipse.mdht.uml.cda.SubjectPerson;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.INT;
import org.eclipse.mdht.uml.hl7.datatypes.ST;

public class TestSTDC {
    static void populate(EObject cd, int depth) {
        if (depth++ > 8) {
            return;
        }
        for (EAttribute ea : cd.eClass().getEAllAttributes()) {
            Object value = null;
            EDataType type = (EDataType)ea.getEType();
            if (type instanceof EEnum) {
                value = EcoreUtil.createFromString((EDataType)type, (String)((EEnum)type).getEEnumLiteral(0).getLiteral());
            } else {
                EStructuralFeature feature = cd.eClass().getEStructuralFeature(ea.getName());
                if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    try {
                        value = EcoreUtil.createFromString((EDataType)type, (String)"Test");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (value == null) continue;
            if (ea.isMany()) {
                List list = (List)cd.eGet((EStructuralFeature)ea);
                list.add(value);
                continue;
            }
            cd.eSet((EStructuralFeature)ea, value);
        }
        for (EAttribute ea : cd.eClass().getEAllReferences()) {
            List list;
            EClassifier ec = ea.getEType();
            if (!(ec instanceof EClass)) continue;
            EClass ec1 = (EClass)ec;
            if (!ec1.isAbstract()) {
                EObject eo = EcoreUtil.create((EClass)((EClass)ec));
                if (!"http://www.openhealthtools.org/mdht/uml/hl7/datatypes".equals(ec1.getEPackage().getNsURI())) {
                    TestSTDC.populate(eo, depth);
                }
                if (ea.isMany()) {
                    list = (List)cd.eGet((EStructuralFeature)ea);
                    list.add(eo);
                    continue;
                }
                cd.eSet((EStructuralFeature)ea, (Object)eo);
                continue;
            }
            ST st = DatatypesFactory.eINSTANCE.createST("asdasdfasdf");
            if (ea.isMany()) {
                list = (List)cd.eGet((EStructuralFeature)ea);
                list.add(st);
                continue;
            }
            cd.eSet((EStructuralFeature)ea, (Object)st);
        }
    }

    public static void main(String[] args) throws Exception {
        Patient p = CDAFactory.eINSTANCE.createPatient();
        p.getSDTCEthnicGroupCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("EthnicGroupCode", "EthnicGroupCodeSystem"));
        p.getSDTCRaceCodes().add((Object)DatatypesFactory.eINSTANCE.createCE("RaceCode", "RaceCodeSystem"));
        p.setSDTCDeceasedInd(DatatypesFactory.eINSTANCE.createBL(Boolean.valueOf(false)));
        p.setSDTCDeceasedTime(DatatypesFactory.eINSTANCE.createTS("1900"));
        p.setSDTCDesc(DatatypesFactory.eINSTANCE.createED("Description"));
        p.setSDTCMultipleBirthInd(DatatypesFactory.eINSTANCE.createBL(Boolean.valueOf(false)));
        INT i = DatatypesFactory.eINSTANCE.createINT();
        i.setValue(Integer.valueOf(3));
        p.setSDTCMultipleBirthOrderNumber(i);
        CDAUtil.saveSnippet((EObject)p, System.out);
        SubjectPerson sp = CDAFactory.eINSTANCE.createSubjectPerson();
        TestSTDC.populate((EObject)sp, 4);
        CDAUtil.saveSnippet((EObject)sp, System.out);
        Person person = CDAFactory.eINSTANCE.createPerson();
        TestSTDC.populate((EObject)person, 4);
        CDAUtil.saveSnippet((EObject)person, System.out);
        Subject subject = CDAFactory.eINSTANCE.createSubject();
        TestSTDC.populate((EObject)subject, 4);
        CDAUtil.saveSnippet((EObject)subject, System.out);
        PlayingEntity playingEntity = CDAFactory.eINSTANCE.createPlayingEntity();
        TestSTDC.populate((EObject)playingEntity, 4);
        CDAUtil.saveSnippet((EObject)playingEntity, System.out);
        EncompassingEncounter ee = CDAFactory.eINSTANCE.createEncompassingEncounter();
        TestSTDC.populate((EObject)ee, 1);
        System.out.println("");
        System.out.println("EncompassingEncounter");
        CDAUtil.saveSnippet((EObject)ee, System.out);
        TestSTDC.showSDTC((EObject)CDAFactory.eINSTANCE.createEncompassingEncounter());
        TestSTDC.showSDTC((EObject)CDAFactory.eINSTANCE.createParticipant2());
        TestSTDC.showSDTC((EObject)CDAFactory.eINSTANCE.createPerformer2());
        TestSTDC.showSDTC((EObject)CDAFactory.eINSTANCE.createOrganizer());
    }

    public static void showSDTC(EObject eObject) throws Exception {
        System.out.println("");
        System.out.println("=================================================");
        System.out.println(eObject.eClass().getName());
        TestSTDC.populate(eObject, 6);
        CDAUtil.saveSnippet(eObject, System.out);
        System.out.println("");
        System.out.println("=================================================");
    }
}

