/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mdht.uml.common.util.PropertyList;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class RIMModelUtil {
    public static final String RIM_PACKAGE_NAME = "rim";

    public static List<Class> getAssociationTypes(Association association) {
        ArrayList<Class> associationTypes = new ArrayList<Class>();
        Type srcType = null;
        for (Property property : association.getMemberEnds()) {
            if (property.isNavigable()) {
                property.getType();
                continue;
            }
            srcType = property.getType();
        }
        if (srcType instanceof Class) {
            PropertyList propertyList = new PropertyList((Class)srcType);
            List associationEnds = propertyList.getAssociationEnds();
            for (Property property : associationEnds) {
                if (RIMModelUtil.isActRelationship(association) && RIMModelUtil.isActRelationship(property.getType())) {
                    associationTypes.add((Class)property.getType());
                    continue;
                }
                if (!RIMModelUtil.isParticipation(association) || !RIMModelUtil.isParticipation(property.getType())) continue;
                associationTypes.add((Class)property.getType());
            }
        }
        return associationTypes;
    }

    public static Class getRIMClass(Class umlClass) {
        Class cdaClass = null;
        if (RIMModelUtil.isRIMModel((Element)umlClass)) {
            return umlClass;
        }
        for (Classifier parent : umlClass.allParents()) {
            if (parent.getNearestPackage() == null || !RIMModelUtil.isRIMModel((Element)parent) || !(parent instanceof Class)) continue;
            cdaClass = (Class)parent;
            break;
        }
        return cdaClass;
    }

    public static List<EnumerationLiteral> getTypeCodes(Class associationType) {
        Property typeCode;
        ArrayList<EnumerationLiteral> typeCodes = new ArrayList<EnumerationLiteral>();
        if (associationType != null && (typeCode = associationType.getOwnedAttribute("typeCode", null)) != null && typeCode.getType() instanceof Enumeration) {
            typeCodes.addAll((Collection<EnumerationLiteral>)((Enumeration)typeCode.getType()).getOwnedLiterals());
        }
        return typeCodes;
    }

    public static boolean isAct(Type umlClass) {
        return RIMModelUtil.isRIMType(umlClass, "Act");
    }

    public static boolean isActRelationship(Association association) {
        Type srcType = null;
        Type targetType = null;
        for (Property property : association.getMemberEnds()) {
            if (property.isNavigable()) {
                targetType = property.getType();
                continue;
            }
            srcType = property.getType();
        }
        return RIMModelUtil.isAct(srcType) && RIMModelUtil.isAct(targetType);
    }

    public static boolean isActRelationship(Type umlClass) {
        return RIMModelUtil.isRIMType(umlClass, "ActRelationship");
    }

    public static boolean isEntity(Type umlClass) {
        return RIMModelUtil.isRIMType(umlClass, "Entity");
    }

    public static boolean isParticipation(Association association) {
        Type act = null;
        Type role = null;
        for (Property property : association.getMemberEnds()) {
            if (RIMModelUtil.isAct(property.getType())) {
                act = property.getType();
            }
            if (!RIMModelUtil.isRole(property.getType())) continue;
            role = property.getType();
        }
        return act != null && role != null;
    }

    public static boolean isParticipation(Type umlClass) {
        return RIMModelUtil.isRIMType(umlClass, "Participation");
    }

    public static boolean isRIMModel(Element element) {
        return RIM_PACKAGE_NAME.equals(element.getNearestPackage() != null ? element.getNearestPackage().getName() : "");
    }

    public static boolean isRIMType(Type umlClass, String typeName) {
        Class rimClass;
        return umlClass instanceof Class && typeName != null && (rimClass = RIMModelUtil.getRIMClass((Class)umlClass)) != null && typeName.equals(rimClass.getName());
    }

    public static boolean isRole(Type umlClass) {
        return RIMModelUtil.isRIMType(umlClass, "Role");
    }
}

