/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.core.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.profile.EntryRelationship;
import org.eclipse.mdht.uml.cda.core.profile.EntryRelationshipKind;
import org.eclipse.mdht.uml.cda.core.profile.Inline;
import org.eclipse.mdht.uml.cda.core.profile.LogicalConstraint;
import org.eclipse.mdht.uml.cda.core.profile.LogicalOperator;
import org.eclipse.mdht.uml.cda.core.profile.SeverityKind;
import org.eclipse.mdht.uml.cda.core.profile.Validation;
import org.eclipse.mdht.uml.cda.core.profile.ValidationKind;
import org.eclipse.mdht.uml.cda.core.util.CDACommonUtils;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.CDATemplateComputeBuilder;
import org.eclipse.mdht.uml.cda.core.util.NameUtilities;
import org.eclipse.mdht.uml.cda.core.util.RIMModelUtil;
import org.eclipse.mdht.uml.cda.core.util.TransformProvider;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.PropertyList;
import org.eclipse.mdht.uml.term.core.profile.BindingKind;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemConstraint;
import org.eclipse.mdht.uml.term.core.profile.CodeSystemVersion;
import org.eclipse.mdht.uml.term.core.profile.ValueSetConstraint;
import org.eclipse.mdht.uml.term.core.profile.ValueSetVersion;
import org.eclipse.mdht.uml.term.core.util.TermProfileUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CDAModelUtil {
    public static final String CDA_PACKAGE_NAME = "cda";
    public static final String DATATYPES_NS_URI = "http://www.openhealthtools.org/mdht/uml/hl7/datatypes";
    public static String INFOCENTER_URL = "http://www.cdatools.org/infocenter";
    public static final String SEVERITY_ERROR = "ERROR";
    public static final String SEVERITY_WARNING = "WARNING";
    public static final String SEVERITY_INFO = "INFO";
    private static final String EPACKAGE = "Ecore::EPackage";
    private static final String EREFERENCE = "Ecore::EReference";
    public static final String XMLNAMESPACE = "xmlNamespace";
    private static final String NSPREFIX = "nsPrefix";
    private static final String NSURI = "nsURI";
    private static final String NULLFLAVOR_SECTION_MESSAGE = "If section/@nullFlavor is not present, ";
    public static boolean cardinalityAfterElement = false;
    public static boolean disablePdfGeneration = false;
    public static boolean isAppendConformanceRules = false;
    private static final String[] OL = new String[]{"<ol>", "</ol>"};
    private static final String[] LI = new String[]{"<li>", "</li>"};
    private static final String[] NOOL = new String[]{"", " "};
    private static final String[] NOLI = new String[]{"", " "};
    private static final String[] lowNames = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] tensNames = new String[]{"twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] bigNames = new String[]{"thousand", "million", "billion"};

    public static Class getCDAClass(Classifier templateClass) {
        Class cdaClass = null;
        if (CDAModelUtil.isCDAModel((Element)templateClass) && templateClass instanceof Class) {
            return (Class)templateClass;
        }
        for (Classifier parent : templateClass.allParents()) {
            if (parent.getNearestPackage() == null || !CDAModelUtil.isCDAModel((Element)parent) || !(parent instanceof Class)) continue;
            cdaClass = (Class)parent;
            break;
        }
        return cdaClass;
    }

    public static Property getCDAProperty(Property templateProperty) {
        if (templateProperty.getClass_() == null) {
            return null;
        }
        if (CDAModelUtil.isCDAModel((Element)templateProperty) || CDAModelUtil.isDatatypeModel((Element)templateProperty)) {
            return templateProperty;
        }
        for (Classifier parent : templateProperty.getClass_().allParents()) {
            for (Property inherited : parent.getAttributes()) {
                Property cdaProperty = CDAModelUtil.transformToCDAProperty(templateProperty);
                if (cdaProperty == null || CDAModelUtil.getCDAName(inherited) == null || !CDAModelUtil.getCDAName(inherited).equals(CDAModelUtil.getCDAName(cdaProperty)) || !CDAModelUtil.isCDAModel((Element)inherited) && !CDAModelUtil.isDatatypeModel((Element)inherited)) continue;
                return inherited;
            }
        }
        return null;
    }

    @Deprecated
    public static Property getInheritedProperty(Property templateProperty) {
        if (templateProperty.getClass_() == null) {
            return null;
        }
        return org.eclipse.mdht.uml.common.util.UMLUtil.getInheritedProperty((Property)templateProperty);
    }

    public static boolean isDatatypeModel(Element element) {
        Stereotype ePackage;
        if (element != null && element.getNearestPackage() != null && (ePackage = element.getNearestPackage().getAppliedStereotype(EPACKAGE)) != null) {
            return DATATYPES_NS_URI.equals(element.getNearestPackage().getValue(ePackage, NSURI));
        }
        return false;
    }

    public static boolean isCDAModel(Element element) {
        Package neareastPackage;
        if (element != null && (neareastPackage = element.getNearestPackage()) != null) {
            Package topPackage = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Package)neareastPackage);
            return CDA_PACKAGE_NAME.equals(topPackage != null ? topPackage.getName() : "");
        }
        return false;
    }

    public static Class getCDADatatype(Classifier datatype) {
        Class result = null;
        if (CDAModelUtil.isDatatypeModel((Element)datatype) && datatype instanceof Class) {
            result = (Class)datatype;
        } else {
            for (Classifier parent : datatype.allParents()) {
                if (parent.getNearestPackage() == null || !CDAModelUtil.isDatatypeModel((Element)parent) || !(parent instanceof Class)) continue;
                result = (Class)parent;
                break;
            }
        }
        return result;
    }

    public static boolean isCDAType(Type templateClass, String typeName) {
        Class cdaClass;
        return templateClass instanceof Class && typeName != null && (cdaClass = CDAModelUtil.getCDAClass((Classifier)((Class)templateClass))) != null && typeName.equals(cdaClass.getName());
    }

    public static boolean isClinicalDocument(Type templateClass) {
        return CDAModelUtil.isCDAType(templateClass, "ClinicalDocument");
    }

    public static boolean isSection(Type templateClass) {
        return CDAModelUtil.isCDAType(templateClass, "Section");
    }

    public static boolean isOrganizer(Type templateClass) {
        return CDAModelUtil.isCDAType(templateClass, "Organizer");
    }

    public static boolean isEntry(Type templateClass) {
        return CDAModelUtil.isCDAType(templateClass, "Entry");
    }

    public static boolean isClinicalStatement(Type templateClass) {
        if (templateClass instanceof Class) {
            String cdaName;
            Class cdaClass = CDAModelUtil.getCDAClass((Classifier)((Class)templateClass));
            String string = cdaName = cdaClass == null ? null : cdaClass.getName();
            if (cdaClass != null && ("Act".equals(cdaName) || "Encounter".equals(cdaName) || "Observation".equals(cdaName) || "ObservationMedia".equals(cdaName) || "Organizer".equals(cdaName) || "Procedure".equals(cdaName) || "RegionOfInterest".equals(cdaName) || "SubstanceAdministration".equals(cdaName) || "Supply".equals(cdaName))) {
                return true;
            }
        }
        return false;
    }

    public static void composeAllConformanceMessages(Element element, final PrintStream stream, final boolean markup) {
        final TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
        while (iterator != null && iterator.hasNext()) {
            EObject child = (EObject)iterator.next();
            UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

                public Object caseAssociation(Association association) {
                    iterator.prune();
                    return association;
                }

                public Object caseClass(Class umlClass) {
                    String message = CDAModelUtil.computeConformanceMessage(umlClass, markup);
                    stream.println(message);
                    return umlClass;
                }

                public Object caseGeneralization(Generalization generalization) {
                    String message = CDAModelUtil.computeConformanceMessage(generalization, markup);
                    if (message.length() > 0) {
                        stream.println(message);
                    }
                    return generalization;
                }

                public Object caseProperty(Property property) {
                    String message = CDAModelUtil.computeConformanceMessage(property, markup);
                    if (message.length() > 0) {
                        stream.println(message);
                    }
                    return property;
                }

                public Object caseConstraint(Constraint constraint) {
                    String message = CDAModelUtil.computeConformanceMessage(constraint, markup);
                    if (message.length() > 0) {
                        stream.println(message);
                    }
                    return constraint;
                }
            };
            umlSwitch.doSwitch(child);
        }
    }

    public static String getValidationMessage(Element element) {
        return CDAModelUtil.getValidationMessage(element, "Validation");
    }

    public static String getValidationMessage(Element element, String validationStereotypeName) {
        String message = null;
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype(element, validationStereotypeName);
        if (validationSupport != null) {
            message = (String)element.getValue(validationSupport, "message");
        }
        if (message == null || message.length() == 0) {
            message = CDAModelUtil.computeConformanceMessage(element, false);
        }
        return message;
    }

    public static String computeConformanceMessage(Element element, final boolean markup) {
        UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

            public Object caseAssociation(Association association) {
                String message = null;
                Property property = CDAModelUtil.getNavigableEnd(association);
                if (property != null) {
                    message = CDAModelUtil.computeConformanceMessage(property, false);
                }
                return message;
            }

            public Object caseClass(Class umlClass) {
                return CDAModelUtil.computeConformanceMessage(umlClass, markup);
            }

            public Object caseGeneralization(Generalization generalization) {
                return CDAModelUtil.computeConformanceMessage(generalization, markup);
            }

            public Object caseProperty(Property property) {
                return CDAModelUtil.computeConformanceMessage(property, markup);
            }

            public Object caseConstraint(Constraint constraint) {
                return CDAModelUtil.computeConformanceMessage(constraint, markup);
            }
        };
        return (String)umlSwitch.doSwitch((EObject)element);
    }

    public static String computeConformanceMessage(Class template, final boolean markup) {
        String templateId = CDAModelUtil.getTemplateId(template);
        String templateVersion = CDAModelUtil.getTemplateVersion(template);
        String ruleIds = CDAModelUtil.getConformanceRuleIds((Element)template);
        if (templateId == null) {
            templateId = "";
        }
        String templateMultiplicity = CDATemplateComputeBuilder.getMultiplicityRange(CDAModelUtil.getMultiplicityRange(template));
        final String templateIdAsBusinessName = "=\"" + templateId + "\"";
        final String templateVersionAsBusinessName = "=\"" + templateVersion + "\"";
        final String multiplicityRange = templateMultiplicity.isEmpty() ? "" : " [" + templateMultiplicity + "]";
        CDATemplateComputeBuilder cdaTemplater = new CDATemplateComputeBuilder(){

            @Override
            public String addTemplateIdMultiplicity() {
                return CDAModelUtil.multiplicityElementToggle(markup, "templateId", multiplicityRange, "");
            }

            @Override
            public String addRootMultiplicity() {
                return CDAModelUtil.multiplicityElementToggle(markup, "@root", " [1..1]", templateIdAsBusinessName);
            }

            @Override
            public String addTemplateVersion() {
                return CDAModelUtil.multiplicityElementToggle(markup, "@extension", " [1..1]", templateVersionAsBusinessName);
            }
        };
        return cdaTemplater.setRequireMarkup(markup).setRuleIds(ruleIds).setTemplateVersion(templateVersion).setMultiplicity(multiplicityRange).compute().toString();
    }

    public static String computeConformanceMessage(Generalization generalization, boolean markup) {
        return CDAModelUtil.computeConformanceMessage(generalization, markup, org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)generalization));
    }

    public static String computeConformanceMessage(Generalization generalization, boolean markup, Package xrefSource) {
        Class general = (Class)generalization.getGeneral();
        StringBuffer message = new StringBuffer(CDAModelUtil.computeGeneralizationConformanceMessage(general, markup, xrefSource));
        CDAModelUtil.appendConformanceRuleIds((Element)generalization, message, markup);
        return message.toString();
    }

    public static String computeGeneralizationConformanceMessage(Class general, boolean markup, Package xrefSource) {
        StringBuffer message = new StringBuffer();
        String prefix = !org.eclipse.mdht.uml.common.util.UMLUtil.isSameModel((Element)xrefSource, (Element)general) ? String.valueOf(CDAModelUtil.getModelPrefix((Element)general)) + " " : "";
        String xref = CDAModelUtil.computeXref((Element)xrefSource, (Classifier)general);
        boolean showXref = markup && xref != null;
        String format = showXref && xref.endsWith(".html") ? "format=\"html\" " : "";
        Class cdaGeneral = CDAModelUtil.getCDAClass((Classifier)general);
        if (cdaGeneral != null) {
            message.append(markup ? "<b>" : "");
            message.append("SHALL");
            message.append(markup ? "</b>" : "");
            message.append(" conform to ");
        } else {
            message.append("Extends ");
        }
        message.append(showXref ? "<xref " + format + "href=\"" + xref + "\">" : "");
        message.append(prefix).append(org.eclipse.mdht.uml.common.util.UMLUtil.splitName((NamedElement)general));
        message.append(showXref ? "</xref>" : "");
        String templateId = CDAModelUtil.getTemplateId(general);
        String templateVersion = CDAModelUtil.getTemplateVersion(general);
        if (templateId != null) {
            message.append(" template (templateId: ");
            message.append(markup ? "<tt>" : "");
            message.append(templateId);
            if (!StringUtils.isEmpty((String)templateVersion)) {
                message.append(":" + templateVersion);
            }
            message.append(markup ? "</tt>" : "");
            message.append(")");
        }
        return message.toString();
    }

    private static String getBusinessName(NamedElement property) {
        String businessName = NamedElementUtil.getBusinessName((NamedElement)property);
        if (!property.getName().equals(businessName)) {
            return " (" + businessName + ")";
        }
        return "";
    }

    private static StringBuffer multiplicityElementToggle(Property property, boolean markup, String elementName) {
        StringBuffer message = new StringBuffer();
        message.append(CDAModelUtil.multiplicityElementToggle(markup, elementName, CDAModelUtil.getMultiplicityRange(property), CDAModelUtil.getBusinessName((NamedElement)property)));
        return message;
    }

    private static String multiplicityElementToggle(boolean markup, String elementName, String multiplicityRange, String businessName) {
        StringBuffer message = new StringBuffer();
        if (!cardinalityAfterElement) {
            message.append(multiplicityRange);
        }
        message.append(" ");
        message.append(markup ? "<tt><b>" : "");
        message.append(elementName);
        message.append(markup ? "</b>" : "");
        message.append(businessName);
        message.append(markup ? "</tt>" : "");
        if (cardinalityAfterElement) {
            message.append(multiplicityRange);
        }
        return message.toString();
    }

    public static String computeAssociationConformanceMessage(Property property, boolean markup, Package xrefSource, boolean appendNestedConformanceRules) {
        String keyword;
        Class endType;
        Class clazz = endType = property.getType() instanceof Class ? (Class)property.getType() : null;
        if (!CDAModelUtil.isInlineClass(endType) && CDAModelUtil.getTemplateId(property.getClass_()) != null) {
            return CDAModelUtil.computeTemplateAssociationConformanceMessage(property, markup, xrefSource, appendNestedConformanceRules);
        }
        StringBuffer message = new StringBuffer();
        Association association = property.getAssociation();
        if (!markup) {
            message.append(CDAModelUtil.getPrefixedSplitName((NamedElement)property.getClass_())).append(" ");
        }
        if (CDAModelUtil.getTemplateId(property.getClass_()) != null) {
            CDAModelUtil.appendNullflavorSectionMessage(property, message);
        }
        if ((keyword = CDAModelUtil.getValidationKeywordWithPropertyRange((Element)association, property)) != null) {
            message.append(markup ? "<b>" : "");
            message.append(keyword);
            message.append(markup ? "</b>" : "");
            message.append(" contain ");
            if (property.getUpper() == 0 && CDAModelUtil.isClosed(property)) {
                message.append("any ");
            }
        } else {
            if (property.getUpper() < 0 || property.getUpper() > 1) {
                message.append("contains ");
            } else {
                message.append("contain ");
            }
            if (property.getUpper() == 0 && CDAModelUtil.isClosed(property)) {
                message.append("any ");
            }
        }
        String elementName = CDAModelUtil.resolveCdaPropertyName(property);
        String propertyPrefix = CDAModelUtil.getNameSpacePrefix(org.eclipse.mdht.uml.common.util.UMLUtil.getInheritedProperty((Property)property) != null ? org.eclipse.mdht.uml.common.util.UMLUtil.getInheritedProperty((Property)property) : property);
        if (propertyPrefix != null && !elementName.contains(":")) {
            elementName = String.valueOf(propertyPrefix) + ":" + elementName;
        }
        message.append(CDAModelUtil.getMultiplicityText(property));
        message.append(CDAModelUtil.multiplicityElementToggle(property, markup, elementName));
        if (appendNestedConformanceRules && endType != null) {
            if (markup && CDAModelUtil.isDisplayInline(endType)) {
                StringBuilder sb = new StringBuilder();
                message.append(CDAModelUtil.openOrClosed(property));
                CDAModelUtil.appendConformanceRuleIds(association, message, markup);
                CDAModelUtil.appendPropertyComments(sb, property, markup);
                CDAModelUtil.appendConformanceRules(sb, endType, "", markup);
                message.append(" " + sb + " ");
            } else {
                message.append(", where its type is ");
                String prefix = !org.eclipse.mdht.uml.common.util.UMLUtil.isSameModel((Element)xrefSource, (Element)endType) ? String.valueOf(CDAModelUtil.getModelPrefix((Element)endType)) + " " : "";
                String xref = CDAModelUtil.computeXref((Element)xrefSource, (Classifier)endType);
                boolean showXref = markup && xref != null;
                String format = showXref && xref.endsWith(".html") ? "format=\"html\" " : "";
                message.append(showXref ? "<xref " + format + "href=\"" + xref + "\">" : "");
                message.append(prefix).append(org.eclipse.mdht.uml.common.util.UMLUtil.getAnchorText((NamedElement)endType));
                message.append(showXref ? "</xref>" : "");
                CDAModelUtil.appendConformanceRuleIds(association, message, markup);
            }
        } else {
            CDAModelUtil.appendConformanceRuleIds(association, message, markup);
        }
        return message.toString();
    }

    private static String computeTemplateAssociationConformanceMessage(Property property, boolean markup, Package xrefSource, boolean appendNestedConformanceRules) {
        String assocConstraints;
        StringBuffer message = new StringBuffer();
        Association association = property.getAssociation();
        String elementName = CDAModelUtil.resolveCdaPropertyName(property);
        if (!markup) {
            message.append(CDAModelUtil.getPrefixedSplitName((NamedElement)property.getClass_())).append(" ");
        }
        CDAModelUtil.appendNullflavorSectionMessage(property, message);
        String keyword = CDAModelUtil.getValidationKeyword((Element)association);
        if (keyword != null) {
            message.append(markup ? "<b>" : "");
            message.append(keyword);
            message.append(markup ? "</b>" : "");
            message.append(" contain ");
        } else if (property.getUpper() < 0 || property.getUpper() > 1) {
            message.append("contains ");
        } else {
            message.append("contain ");
        }
        message.append(CDAModelUtil.multiplicityElementToggle(property, markup, elementName));
        message.append(CDAModelUtil.openOrClosed(property));
        CDAModelUtil.appendConformanceRuleIds(association, message, markup);
        if (appendNestedConformanceRules && property.getType() instanceof Class) {
            Class inlinedClass = (Class)property.getType();
            if (markup && CDAModelUtil.isInlineClass(inlinedClass)) {
                StringBuilder sb = new StringBuilder();
                CDAModelUtil.appendPropertyComments(sb, property, markup);
                CDAModelUtil.appendConformanceRules(sb, inlinedClass, String.valueOf(property.getUpper() == 1 ? "This " : "Such ") + (property.getUpper() == 1 ? elementName : NameUtilities.pluralize(elementName)) + " ", markup);
                message.append(" " + sb);
            }
        }
        if (!markup && (assocConstraints = CDAModelUtil.computeAssociationConstraints(property, markup)).length() > 0) {
            message.append(assocConstraints);
        }
        return message.toString();
    }

    private static void appendNullflavorSectionMessage(Property property, StringBuffer message) {
        Association association = property.getAssociation();
        for (Property p : association.getMemberEnds()) {
            Class class1;
            Property nullFlavor;
            if (p.getName() == null || p.getName().isEmpty() || p.getOwner() == null || p.getType() == null || (!CDAModelUtil.isSection((Type)((Class)p.getOwner())) || !CDAModelUtil.isClinicalStatement(p.getType())) && !CDAModelUtil.isEntry(p.getType()) || property.eContainer() instanceof Class && (nullFlavor = CDACommonUtils.findAttribute(class1 = (Class)property.eContainer(), "nullFlavor")) != null && nullFlavor.upperBound() == 0) continue;
            message.append(NULLFLAVOR_SECTION_MESSAGE);
        }
    }

    public static String computeAssociationConstraints(Property property, boolean markup) {
        Class endType;
        StringBuffer message = new StringBuffer();
        Association association = property.getAssociation();
        Package xrefSource = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)property);
        EntryRelationship entryRelationship = CDAProfileUtil.getEntryRelationship(association);
        EntryRelationshipKind typeCode = entryRelationship != null ? entryRelationship.getTypeCode() : null;
        Class clazz = endType = property.getType() instanceof Class ? (Class)property.getType() : null;
        if (typeCode != null) {
            message.append(markup ? "\n<li>" : " ");
            message.append("Contains ");
            message.append(markup ? "<tt><b>" : "").append("@typeCode=\"").append(markup ? "</b>" : "");
            message.append((Object)typeCode).append("\" ");
            message.append(markup ? "</tt>" : "");
            message.append(markup ? "<i>" : "");
            message.append(typeCode.getLiteral());
            message.append(markup ? "</i>" : "");
            message.append(markup ? "</li>" : ", and");
        }
        if (endType != null && CDAModelUtil.getCDAClass((Classifier)endType) != null && !CDAModelUtil.isInlineClass(endType) && !CDAModelUtil.isInlineClass(property.getClass_())) {
            message.append(markup ? "\n<li>" : " ");
            message.append("Conforms to ");
            String prefix = "";
            String xref = CDAModelUtil.computeXref((Element)xrefSource, (Classifier)endType);
            boolean showXref = markup && xref != null;
            String format = showXref && xref.endsWith(".html") ? "format=\"html\" " : "";
            message.append(showXref ? "<xref " + format + "href=\"" + xref + "\">" : "");
            message.append(prefix).append(org.eclipse.mdht.uml.common.util.UMLUtil.splitName((NamedElement)endType));
            message.append(showXref ? "</xref>" : "");
            String templateId = CDAModelUtil.getTemplateId(endType);
            String templateVersion = CDAModelUtil.getTemplateVersion(endType);
            if (templateId != null) {
                message.append(" (templateId: ");
                message.append(markup ? "<tt>" : "");
                message.append(templateId);
                if (!StringUtils.isEmpty((String)templateVersion)) {
                    message.append(":" + templateVersion);
                }
                message.append(markup ? "</tt>" : "");
                message.append(")");
            }
            if (!org.eclipse.mdht.uml.common.util.UMLUtil.isSameModel((Element)xrefSource, (Element)endType)) {
                message.append(" from " + CDAModelUtil.getModelPrefix((Element)endType));
            }
            message.append(markup ? "</li>" : "");
        }
        return message.toString();
    }

    public static String computeConformanceMessage(Property property, boolean markup) {
        return CDAModelUtil.computeConformanceMessage(property, markup, org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)property));
    }

    private static String getNameSpacePrefix(Property property) {
        Package topPackage;
        Stereotype ePackageStereoetype;
        String nameSpace;
        Stereotype eReferenceStereoetype;
        Property cdaBaseProperty = CDAModelUtil.getCDAProperty(property);
        String nameSpacePrefix = null;
        if (cdaBaseProperty != null && (eReferenceStereoetype = cdaBaseProperty.getAppliedStereotype(EREFERENCE)) != null && !StringUtils.isEmpty((String)(nameSpace = (String)cdaBaseProperty.getValue(eReferenceStereoetype, XMLNAMESPACE))) && (ePackageStereoetype = (topPackage = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Package)cdaBaseProperty.getNearestPackage())).getApplicableStereotype(EPACKAGE)) != null) {
            if (nameSpace.equals(topPackage.getValue(ePackageStereoetype, NSURI))) {
                nameSpacePrefix = (String)topPackage.getValue(ePackageStereoetype, NSPREFIX);
            } else {
                for (Package nestedPackage : topPackage.getNestedPackages()) {
                    if (!nameSpace.equals(nestedPackage.getValue(ePackageStereoetype, NSURI))) continue;
                    nameSpacePrefix = (String)nestedPackage.getValue(ePackageStereoetype, NSPREFIX);
                }
            }
        }
        return nameSpacePrefix;
    }

    public static String computeConformanceMessage(Property property, boolean markup, Package xrefSource) {
        return CDAModelUtil.computeConformanceMessage(property, markup, xrefSource, true);
    }

    private static String openOrClosed(Property property) {
        if (CDAModelUtil.isClosed(property)) {
            return " ";
        }
        return " such that it ";
    }

    private static boolean isClosed(Property property) {
        Validation validation = (Validation)UMLUtil.getStereotypeApplication((Element)(property.getAssociation() != null ? property.getAssociation() : property), Validation.class);
        return validation != null && validation.getKind().equals((Object)ValidationKind.CLOSED);
    }

    public static String computeConformanceMessage(Property property, boolean markup, Package xrefSource, boolean appendNestedConformanceRules) {
        String vocab;
        String value;
        String keyword;
        if (property.getType() == null) {
            System.out.println("Property has null type: " + property.getQualifiedName());
        }
        if (property.getAssociation() != null && property.isNavigable()) {
            return CDAModelUtil.computeAssociationConformanceMessage(property, markup, xrefSource, appendNestedConformanceRules);
        }
        StringBuffer message = new StringBuffer();
        if (!markup) {
            message.append(CDAModelUtil.getPrefixedSplitName((NamedElement)property.getClass_())).append(" ");
        }
        if ((keyword = CDAModelUtil.getValidationKeywordWithPropertyRange(property)) != null) {
            message.append(markup ? "<b>" : "");
            message.append(keyword);
            message.append(markup ? "</b>" : "");
            message.append(" contain ");
            if (property.getUpper() == 0 && CDAModelUtil.isClosed(property)) {
                message.append("any ");
            }
        } else {
            if (property.getUpper() < 0 || property.getUpper() > 1) {
                message.append("contains ");
            } else {
                message.append("contain ");
            }
            if (property.getUpper() == 0 && CDAModelUtil.isClosed(property)) {
                message.append("any ");
            }
        }
        message.append(CDAModelUtil.getMultiplicityText(property));
        if (!cardinalityAfterElement) {
            message.append(CDAModelUtil.getMultiplicityRange(property));
        }
        message.append(" ");
        message.append(markup ? "<tt><b>" : "");
        if (CDAModelUtil.isXMLAttribute(property)) {
            message.append("@");
        }
        String propertyPrefix = CDAModelUtil.getNameSpacePrefix(property);
        String cdaPropertyName = CDAModelUtil.resolveCdaPropertyName(property);
        message.append(propertyPrefix != null ? String.valueOf(propertyPrefix) + ":" + cdaPropertyName : cdaPropertyName);
        message.append(markup ? "</b>" : "");
        message.append(CDAModelUtil.getBusinessName((NamedElement)property));
        if (property.getDefault() != null) {
            message.append("=\"").append(property.getDefault()).append("\" ");
        }
        message.append(markup ? "</tt>" : "");
        if (cardinalityAfterElement) {
            message.append(CDAModelUtil.getMultiplicityRange(property));
        }
        Stereotype nullFlavorSpecification = CDAProfileUtil.getAppliedCDAStereotype((Element)property, "NullFlavor");
        Stereotype textValue = CDAProfileUtil.getAppliedCDAStereotype((Element)property, "TextValue");
        if (nullFlavorSpecification != null) {
            String nullFlavor = CDAModelUtil.getLiteralValue((Element)property, nullFlavorSpecification, "nullFlavor");
            Enumeration profileEnum = (Enumeration)nullFlavorSpecification.getProfile().getOwnedType("NullFlavorKind");
            String nullFlavorLabel = CDAModelUtil.getLiteralValueLabel((Element)property, nullFlavorSpecification, "nullFlavor", profileEnum);
            if (nullFlavor != null) {
                message.append(markup ? "<tt>" : "");
                message.append("/@nullFlavor");
                message.append(markup ? "</tt>" : "");
                message.append(" = \"").append(nullFlavor).append("\" ");
                message.append(markup ? "<i>" : "");
                message.append(nullFlavorLabel);
                message.append(markup ? "</i>" : "");
            }
        }
        if (textValue != null && (value = (String)property.getValue(textValue, "value")) != null && value.length() > 0) {
            SeverityKind level = (SeverityKind)((Object)property.getValue(textValue, "severity"));
            message.append(" which ").append(markup ? "<b>" : "").append(level != null ? CDAModelUtil.getValidationKeyword(level.getLiteral()) : keyword).append(markup ? "</b>" : "").append(" equal \"").append(value).append("\"");
        }
        Property cdaProperty = CDAModelUtil.transformToCDAProperty(property);
        if (property.getType() instanceof Classifier && cdaProperty != null && cdaProperty.getType() instanceof Classifier) {
            Classifier propertyType = (Classifier)property.getType();
            Classifier cdaPropertyType = (Classifier)cdaProperty.getType();
            Class propertyCdaType = CDAModelUtil.getCDAClass(propertyType);
            if (propertyCdaType == null) {
                propertyCdaType = CDAModelUtil.getCDADatatype(propertyType);
            }
            if (propertyCdaType != null && cdaPropertyType != null && propertyCdaType != cdaPropertyType && propertyCdaType.getName() != null && !propertyCdaType.getName().isEmpty()) {
                message.append(" with ");
                message.append(markup ? "<tt><b>" : "");
                message.append("@xsi:type");
                message.append(markup ? "</b>" : "");
                message.append("=\"");
                message.append(propertyCdaType.getName());
                message.append("\"");
                message.append(markup ? "</tt>" : "");
            }
        }
        if (CDAModelUtil.isHL7VocabAttribute(property)) {
            String ruleIds = CDAModelUtil.getTerminologyConformanceRuleIds(property);
            if (ruleIds.length() > 0) {
                CDAModelUtil.appendConformanceRuleIds(property, message, markup);
            }
        } else {
            CDAModelUtil.appendConformanceRuleIds(property, message, markup);
        }
        Stereotype codeSystemConstraint = TermProfileUtil.getAppliedStereotype((Element)property, (String)"CodeSystemConstraint");
        Stereotype valueSetConstraint = TermProfileUtil.getAppliedStereotype((Element)property, (String)"ValueSetConstraint");
        if (codeSystemConstraint != null) {
            vocab = CDAModelUtil.computeCodeSystemMessage(property, markup);
            message.append(vocab);
        } else if (valueSetConstraint != null) {
            vocab = CDAModelUtil.computeValueSetMessage(property, markup, xrefSource);
            message.append(vocab);
        } else if (CDAModelUtil.isHL7VocabAttribute(property) && property.getDefault() != null) {
            vocab = CDAModelUtil.computeHL7VocabAttributeMessage(property, markup);
            message.append(vocab);
        }
        if (CDAModelUtil.isHL7VocabAttribute(property)) {
            String ruleIds = CDAModelUtil.getTerminologyConformanceRuleIds(property);
            if (ruleIds.length() > 0) {
                CDAModelUtil.appendTerminologyConformanceRuleIds(property, message, markup);
            } else {
                CDAModelUtil.appendConformanceRuleIds(property, message, markup);
            }
        } else {
            CDAModelUtil.appendTerminologyConformanceRuleIds(property, message, markup);
        }
        if (property.getType() != null && appendNestedConformanceRules && property.getType() instanceof Class && CDAModelUtil.isInlineClass((Class)property.getType())) {
            if (CDAModelUtil.isPublishSeperately((Class)property.getType())) {
                boolean showXref;
                String xref = property.getType() instanceof Classifier && org.eclipse.mdht.uml.common.util.UMLUtil.isSameProject((Element)property, (Element)property.getType()) ? CDAModelUtil.computeXref((Element)xrefSource, (Classifier)property.getType()) : null;
                boolean bl = showXref = markup && xref != null;
                if (showXref) {
                    String format = showXref && xref.endsWith(".html") ? "format=\"html\" " : "";
                    message.append(showXref ? "<xref " + format + "href=\"" + xref + "\">" : "");
                    message.append(org.eclipse.mdht.uml.common.util.UMLUtil.splitName((NamedElement)property.getType()));
                    message.append(showXref ? "</xref>" : "");
                }
            } else {
                StringBuilder sb = new StringBuilder();
                boolean hadSideEffect = CDAModelUtil.appendPropertyComments(sb, property, markup);
                if (isAppendConformanceRules) {
                    int len = sb.length();
                    CDAModelUtil.appendConformanceRules(sb, (Class)property.getType(), "", markup);
                    hadSideEffect |= sb.length() > len;
                }
                if (hadSideEffect) {
                    if (cdaProperty.upperBound() != 1 && property.getType() instanceof Class && CDAModelUtil.isInlineClass((Class)property.getType())) {
                        message.append(String.valueOf(CDAModelUtil.openOrClosed(property)) + " " + sb);
                    } else {
                        message.append(" " + sb);
                    }
                }
            }
        }
        return message.toString();
    }

    private static String resolveCdaPropertyName(Property property) {
        Property cdaProperty = CDAModelUtil.transformToCDAProperty(property);
        String propertyCdaName = null;
        propertyCdaName = cdaProperty != null ? CDAModelUtil.getCDAName(cdaProperty) : CDAModelUtil.getCDAElementName(property);
        return propertyCdaName;
    }

    private static Property transformToCDAProperty(Property property) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.mdht.uml.cda.core.TransformProvider");
        IExtension[] extensions = ep.getExtensions();
        TransformProvider newContributor = null;
        Property cdaProperty = null;
        try {
            newContributor = (TransformProvider)extensions[0].getConfigurationElements()[0].createExecutableExtension("transform-class");
            cdaProperty = newContributor.GetTransform(property);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cdaProperty;
    }

    private static String getCDAName(Property cdaProperty) {
        EList redefines = cdaProperty.getRedefinedProperties();
        String name = CDAModelUtil.getStereotypeName(cdaProperty);
        if (name != null && !name.isEmpty()) {
            return name;
        }
        if (redefines != null && redefines.size() > 0) {
            return CDAModelUtil.getCDAName((Property)redefines.get(0));
        }
        return cdaProperty.getName();
    }

    private static String getStereotypeName(Property cdaProperty) {
        Stereotype eAttribute = cdaProperty.getAppliedStereotype("Ecore::EAttribute");
        String name = null;
        if (eAttribute != null) {
            name = (String)cdaProperty.getValue(eAttribute, "xmlName");
        }
        return name;
    }

    private static void appendSubsetsNotation(Property property, StringBuffer message, boolean markup, Package xrefSource) {
        StringBuffer notation = new StringBuffer();
        for (Property subsets : property.getSubsettedProperties()) {
            if (subsets.getClass_() == null) continue;
            if (notation.length() == 0) {
                notation.append(" {subsets ");
            } else {
                notation.append(", ");
            }
            String xref = CDAModelUtil.computeXref((Element)xrefSource, (Classifier)subsets.getClass_());
            boolean showXref = markup && xref != null;
            String format = showXref && xref.endsWith(".html") ? "format=\"html\" " : "";
            notation.append(showXref ? " <xref " + format + "href=\"" + xref + "\">" : " ");
            notation.append(org.eclipse.mdht.uml.common.util.UMLUtil.splitName((NamedElement)subsets.getClass_()));
            notation.append(showXref ? "</xref>" : "");
            notation.append("::" + subsets.getName());
        }
        if (notation.length() > 0) {
            notation.append("}");
        }
        message.append(notation);
    }

    public static void appendConformanceRules(StringBuilder appendB, Class umlClass, String prefix, boolean markup) {
        String[] ol = markup ? OL : NOOL;
        String[] li = markup ? LI : NOLI;
        StringBuilder sb = new StringBuilder();
        boolean hasRules = false;
        if (!CDAModelUtil.isInlineClass(umlClass)) {
            for (Generalization generalization : umlClass.getGeneralizations()) {
                String message;
                Classifier general = generalization.getGeneral();
                if (RIMModelUtil.isRIMModel((Element)general) || CDAModelUtil.isCDAModel((Element)general) || CDAModelUtil.isDatatypeModel((Element)general) || (message = CDAModelUtil.computeConformanceMessage(generalization, markup)).length() <= 0) continue;
                hasRules = true;
                sb.append(String.valueOf(li[0]) + prefix + message + li[1]);
            }
        }
        ArrayList<Constraint> unprocessedConstraints = new ArrayList<Constraint>();
        HashMap<String, List<Constraint>> constraintMap = new HashMap<String, List<Constraint>>();
        HashMap<Constraint, List<Constraint>> subConstraintMap = new HashMap<Constraint, List<Constraint>>();
        for (Constraint constraint : umlClass.getOwnedRules()) {
            unprocessedConstraints.add(constraint);
            if (CDAProfileUtil.getLogicalConstraint(constraint) != null) continue;
            for (Element element : constraint.getConstrainedElements()) {
                List<Object> rules;
                if (element instanceof Property) {
                    String name = ((Property)element).getName();
                    rules = (ArrayList<Constraint>)constraintMap.get(name);
                    if (rules == null) {
                        rules = new ArrayList<Constraint>();
                        constraintMap.put(name, rules);
                    }
                    rules.add(constraint);
                    continue;
                }
                if (!(element instanceof Constraint)) continue;
                Constraint subConstraint = (Constraint)element;
                rules = (List)subConstraintMap.get(subConstraint);
                if (rules == null) {
                    rules = new ArrayList();
                    subConstraintMap.put(subConstraint, rules);
                }
                rules.add(constraint);
            }
        }
        PropertyList propertyList = new PropertyList(umlClass, CDAModelUtil.isInlineClass(umlClass));
        for (Property property : propertyList.getAttributes()) {
            if (!CDAModelUtil.hasOwnPDFSection(property)) continue;
            hasRules |= CDAModelUtil.appendPropertyList((Element)umlClass, property, markup, ol, sb, prefix, li, constraintMap, unprocessedConstraints, subConstraintMap);
        }
        for (Property property : propertyList.getAssociationEnds()) {
            hasRules |= CDAModelUtil.appendPropertyList((Element)umlClass, property, markup, ol, sb, prefix, li, constraintMap, unprocessedConstraints, subConstraintMap);
        }
        for (Constraint constraint : unprocessedConstraints) {
            hasRules = true;
            sb.append(String.valueOf(li[0]) + prefix + CDAModelUtil.computeConformanceMessage(constraint, markup) + li[1]);
        }
        if (hasRules) {
            appendB.append(ol[0]);
            appendB.append((CharSequence)sb);
            appendB.append(ol[1]);
        }
    }

    public static boolean hasOwnPDFSection(Property property) {
        Class clazz = (Class)property.eContainer();
        for (Constraint constraint : clazz.getOwnedRules()) {
            LogicalConstraint logicConstraint;
            if (!constraint.getConstrainedElements().contains((Object)property) || (logicConstraint = CDAProfileUtil.getLogicalConstraint(constraint)) == null) continue;
            if (logicConstraint.getOperation() == LogicalOperator.IFTHEN && constraint.getConstrainedElements().indexOf((Object)property) == 1) {
                Validation cv = CDAProfileUtil.getValidation((Element)property);
                return cv != null;
            }
            if (logicConstraint.getOperation() != LogicalOperator.XOR) continue;
            return false;
        }
        return true;
    }

    private static boolean appendPropertyList(Element umlClass, Property property, boolean markup, String[] ol, StringBuilder sb, String prefix, String[] li, Map<String, List<Constraint>> constraintMap, List<Constraint> unprocessedConstraints, Map<Constraint, List<Constraint>> subConstraintMap) {
        boolean result = false;
        if (!(CDAModelUtil.isCDAModel(umlClass) || CDAModelUtil.isCDAModel((Element)property) || CDAModelUtil.isDatatypeModel((Element)property))) {
            result = true;
            String ccm = CDAModelUtil.computeConformanceMessage(property, markup);
            boolean order = ccm.trim().endsWith(ol[1]);
            boolean currentlyItem = false;
            if (order) {
                int olIndex = ccm.lastIndexOf(ol[1]);
                ccm = ccm.substring(0, olIndex);
                currentlyItem = ccm.trim().endsWith(li[1]);
            }
            sb.append(String.valueOf(li[0]) + prefix + ccm);
            StringBuilder propertyComments = new StringBuilder();
            if (currentlyItem &= CDAModelUtil.appendPropertyComments(propertyComments, property, markup)) {
                int pos = ccm.indexOf(propertyComments.toString());
                if (pos < 0 || pos >= ccm.indexOf(li[0])) {
                    sb.append(li[0]).append((CharSequence)propertyComments).append(li[1]);
                }
            } else {
                sb.append((CharSequence)propertyComments);
            }
            CDAModelUtil.appendPropertyRules(sb, property, constraintMap, subConstraintMap, unprocessedConstraints, markup, !order);
            if (order) {
                sb.append(ol[1]);
            }
            sb.append(li[1]);
        }
        return result;
    }

    private static boolean appendPropertyComments(StringBuilder sb, Property property, boolean markup) {
        Association association = property.getAssociation();
        int startingStrLength = sb.length();
        if (association != null && association.getOwnedComments().size() > 0) {
            if (markup) {
                sb.append("<p><lines><i>");
            }
            for (Comment comment : association.getOwnedComments()) {
                sb.append(CDAModelUtil.fixNonXMLCharacters(comment.getBody()));
            }
            if (markup) {
                sb.append("</i></lines></p>");
            }
        }
        if (property.getOwnedComments().size() > 0) {
            if (markup) {
                sb.append("<p><lines><i>");
            }
            for (Comment comment : property.getOwnedComments()) {
                sb.append(CDAModelUtil.fixNonXMLCharacters(comment.getBody()));
            }
            if (markup) {
                sb.append("</i></lines></p>");
            }
        }
        return sb.length() > startingStrLength;
    }

    private static void appendPropertyRules(StringBuilder sb, Property property, Map<String, List<Constraint>> constraintMap, Map<Constraint, List<Constraint>> subConstraintMap, List<Constraint> unprocessedConstraints, boolean markup, boolean newOrder) {
        String[] ol = markup && newOrder ? OL : NOOL;
        String[] li = markup ? LI : NOLI;
        String assocConstraints = "";
        if (property.getAssociation() != null) {
            assocConstraints = CDAModelUtil.computeAssociationConstraints(property, markup);
        }
        StringBuffer ruleConstraints = new StringBuffer();
        List<Constraint> rules = constraintMap.get(property.getName());
        if (rules != null && !rules.isEmpty()) {
            for (Constraint constraint : rules) {
                unprocessedConstraints.remove(constraint);
                ruleConstraints.append(String.valueOf(li[0]) + CDAModelUtil.computeConformanceMessage(constraint, markup));
                CDAModelUtil.appendSubConstraintRules(ruleConstraints, constraint, subConstraintMap, unprocessedConstraints, markup);
                ruleConstraints.append(li[1]);
            }
        }
        if (assocConstraints.length() > 0 || ruleConstraints.length() > 0) {
            sb.append(ol[0]);
            sb.append(assocConstraints);
            sb.append(ruleConstraints);
            sb.append(ol[1]);
        }
    }

    private static void appendSubConstraintRules(StringBuffer ruleConstraints, Constraint constraint, Map<Constraint, List<Constraint>> subConstraintMap, List<Constraint> unprocessedConstraints, boolean markup) {
        String[] li;
        String[] ol;
        if (markup) {
            ol = OL;
            li = LI;
        } else {
            ol = NOOL;
            li = NOLI;
        }
        List<Constraint> subConstraints = subConstraintMap.get(constraint);
        if (subConstraints != null && subConstraints.size() > 0) {
            ruleConstraints.append(ol[0]);
            for (Constraint subConstraint : subConstraints) {
                unprocessedConstraints.remove(subConstraint);
                ruleConstraints.append(String.valueOf(li[0]) + CDAModelUtil.computeConformanceMessage(subConstraint, markup));
                CDAModelUtil.appendSubConstraintRules(ruleConstraints, subConstraint, subConstraintMap, unprocessedConstraints, markup);
                ruleConstraints.append(li[1]);
            }
            ruleConstraints.append(ol[1]);
        }
    }

    private static boolean isHL7VocabAttribute(Property property) {
        String name = property.getName();
        return "classCode".equals(name) || "moodCode".equals(name) || "typeCode".equals(name);
    }

    private static String computeHL7VocabAttributeMessage(Property property, boolean markup) {
        StringBuffer message = new StringBuffer();
        Class rimClass = RIMModelUtil.getRIMClass(property.getClass_());
        String code = property.getDefault();
        String displayName = null;
        String codeSystemId = null;
        String codeSystemName = null;
        if (rimClass != null && "Act".equals(rimClass.getName())) {
            if ("classCode".equals(property.getName())) {
                codeSystemName = "HL7ActClass";
                codeSystemId = "2.16.840.1.113883.5.6";
                if ("ACT".equals(code)) {
                    displayName = "Act";
                } else if ("OBS".equals(code)) {
                    displayName = "Observation";
                }
            } else if ("moodCode".equals(property.getName())) {
                codeSystemName = "HL7ActMood";
                codeSystemId = "2.16.840.1.113883.5.1001";
                if ("EVN".equals(code)) {
                    displayName = "Event";
                }
            }
        }
        if (displayName != null) {
            message.append(markup ? "<i>" : "");
            message.append(displayName);
            message.append(markup ? "</i>" : "");
        }
        if (codeSystemId != null || codeSystemName != null) {
            message.append(" (CodeSystem:");
            message.append(markup ? "<tt>" : "");
            if (codeSystemId != null) {
                message.append(" ").append(codeSystemId);
            }
            if (codeSystemName != null) {
                message.append(" ").append(codeSystemName);
            }
            message.append(markup ? "</tt>" : "");
            message.append(")");
        }
        return message.toString();
    }

    private static String computeCodeSystemMessage(Property property, boolean markup) {
        Stereotype codeSystemConstraintStereotype = TermProfileUtil.getAppliedStereotype((Element)property, (String)"CodeSystemConstraint");
        CodeSystemConstraint codeSystemConstraint = TermProfileUtil.getCodeSystemConstraint((Property)property);
        String keyword = CDAModelUtil.getValidationKeyword((Element)property, codeSystemConstraintStereotype);
        String id = null;
        String name = null;
        String code = null;
        String displayName = null;
        if (codeSystemConstraint != null) {
            if (codeSystemConstraint.getReference() != null) {
                CodeSystemVersion codeSystemVersion = codeSystemConstraint.getReference();
                id = codeSystemVersion.getIdentifier();
                name = codeSystemVersion.getEnumerationName();
                codeSystemVersion.getVersion();
            } else {
                id = codeSystemConstraint.getIdentifier();
                name = codeSystemConstraint.getName();
                codeSystemConstraint.getVersion();
            }
            codeSystemConstraint.getBinding();
            code = codeSystemConstraint.getCode();
            displayName = codeSystemConstraint.getDisplayName();
        }
        StringBuffer message = new StringBuffer();
        if (code != null) {
            message.append(markup ? "<tt><b>" : "");
            message.append("/@code");
            message.append(markup ? "</b>" : "");
            message.append("=\"").append(code).append("\" ");
            message.append(markup ? "</tt>" : "");
            if (displayName != null) {
                message.append(markup ? "<i>" : "");
                message.append(displayName);
                message.append(markup ? "</i>" : "");
            }
        } else {
            message.append(CDAModelUtil.mandatoryOrNotMessage(property));
            if (keyword != null) {
                message.append(markup ? "<b>" : "");
                message.append(keyword);
                message.append(markup ? "</b>" : "");
                message.append(" be");
            } else {
                message.append("is");
            }
            message.append(" selected from");
        }
        if (id != null || name != null) {
            message.append(" (CodeSystem:");
            message.append(markup ? "<tt>" : "");
            if (id != null) {
                message.append(" ").append(id);
            }
            if (name != null) {
                message.append(" ").append(name);
            }
            message.append(markup ? "</tt>" : "");
            message.append(")");
        }
        return message.toString();
    }

    private static String computeValueSetMessage(Property property, boolean markup, Package xrefSource) {
        Stereotype valueSetConstraintStereotype = TermProfileUtil.getAppliedStereotype((Element)property, (String)"ValueSetConstraint");
        ValueSetConstraint valueSetConstraint = TermProfileUtil.getValueSetConstraint((Property)property);
        String keyword = CDAModelUtil.getValidationKeyword((Element)property, valueSetConstraintStereotype);
        String id = null;
        String name = null;
        String version = null;
        BindingKind binding = null;
        String xref = null;
        String xrefFormat = "";
        boolean showXref = false;
        if (valueSetConstraint != null) {
            if (valueSetConstraint.getReference() != null) {
                ValueSetVersion valueSetVersion = valueSetConstraint.getReference();
                id = valueSetVersion.getIdentifier();
                name = valueSetVersion.getEnumerationName();
                version = valueSetVersion.getVersion();
                binding = valueSetVersion.getBinding();
                if (valueSetVersion.getBase_Enumeration() != null) {
                    xref = CDAModelUtil.computeTerminologyXref((Element)property.getClass_(), valueSetVersion.getBase_Enumeration());
                }
                showXref = markup && xref != null;
                xrefFormat = showXref && xref.endsWith(".html") ? "format=\"html\" " : "";
            } else {
                id = valueSetConstraint.getIdentifier();
                name = valueSetConstraint.getName();
                version = valueSetConstraint.getVersion();
                binding = valueSetConstraint.getBinding();
            }
        }
        StringBuffer message = new StringBuffer();
        message.append(CDAModelUtil.mandatoryOrNotMessage(property));
        if (keyword != null) {
            message.append(markup ? "<b>" : "");
            message.append(keyword);
            message.append(markup ? "</b>" : "");
            message.append(" be");
        } else {
            message.append("is");
        }
        message.append(" selected from ValueSet");
        message.append(markup ? "<tt>" : "");
        if (name != null) {
            message.append(" ");
            message.append(showXref ? "<xref " + xrefFormat + "href=\"" + xref + "\">" : "");
            message.append(name);
            message.append(showXref ? "</xref>" : "");
        }
        if (id != null) {
            message.append(" ").append(id);
        }
        message.append(markup ? "</tt>" : "");
        message.append(markup ? "<b>" : "");
        message.append(" ").append(binding.getName().toUpperCase());
        message.append(markup ? "</b>" : "");
        if (BindingKind.STATIC == binding && version != null) {
            message.append(" ").append(version);
        }
        return message.toString();
    }

    public static String computeConformanceMessage(Constraint constraint, boolean markup) {
        LogicalConstraint logicConstraint = CDAProfileUtil.getLogicalConstraint(constraint);
        if (logicConstraint != null) {
            return CDAModelUtil.computeLogicalConformanceMessage(constraint, logicConstraint, markup);
        }
        return CDAModelUtil.computeCustomConformanceMessage(constraint, markup);
    }

    private static String computeCustomConformanceMessage(Constraint constraint, boolean markup) {
        EList stereotypes;
        StringBuffer message = new StringBuffer();
        String strucTextBody = null;
        String analysisBody = null;
        HashMap<String, String> langBodyMap = new HashMap<String, String>();
        CDAProfileUtil.getLogicalConstraint(constraint);
        ValueSpecification spec = constraint.getSpecification();
        if (spec instanceof OpaqueExpression) {
            int i = 0;
            while (i < ((OpaqueExpression)spec).getLanguages().size()) {
                String lang = (String)((OpaqueExpression)spec).getLanguages().get(i);
                String body = (String)((OpaqueExpression)spec).getBodies().get(i);
                if ("StrucText".equals(lang)) {
                    strucTextBody = body;
                } else if ("Analysis".equals(lang)) {
                    analysisBody = body;
                } else {
                    langBodyMap.put(lang, body);
                }
                ++i;
            }
        }
        String displayBody = null;
        if (strucTextBody != null && strucTextBody.trim().length() > 0) {
            displayBody = strucTextBody;
        } else if (analysisBody != null && analysisBody.trim().length() > 0) {
            Boolean ditaEnabled = false;
            try {
                Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)constraint, "ConstraintValidation");
                ditaEnabled = (Boolean)constraint.getValue(stereotype, "enabledDitaForConstraints");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (markup && !ditaEnabled.booleanValue()) {
                displayBody = CDAModelUtil.escapeMarkupCharacters(analysisBody);
                displayBody = CDAModelUtil.replaceSeverityWithBold(displayBody);
            } else {
                displayBody = analysisBody;
            }
        }
        if (displayBody == null && (stereotypes = constraint.getAppliedStereotypes()).isEmpty()) {
            return "";
        }
        if (!markup) {
            message.append(CDAModelUtil.getPrefixedSplitName((NamedElement)constraint.getContext())).append(" ");
        }
        if (displayBody == null || !CDAModelUtil.containsSeverityWord(displayBody)) {
            String keyword = CDAModelUtil.getValidationKeyword((Element)constraint);
            if (keyword == null) {
                keyword = "SHALL";
            }
            message.append(markup ? "<b>" : "");
            message.append(keyword);
            message.append(markup ? "</b>" : "");
            message.append(" satisfy: ");
        }
        if (displayBody == null) {
            message.append(constraint.getName());
        } else {
            message.append(displayBody);
        }
        CDAModelUtil.appendConformanceRuleIds((Element)constraint, message, markup);
        if (!markup) {
            int index;
            while ((index = message.indexOf("\r")) >= 0) {
                message.deleteCharAt(index);
            }
            while ((index = message.indexOf("\n")) >= 0) {
                message.deleteCharAt(index);
                if (message.charAt(index) == ' ') continue;
                message.insert(index, " ");
            }
        }
        return message.toString();
    }

    private static String computeLogicalConformanceMessage(Constraint constraint, LogicalConstraint logicConstraint, boolean markup) {
        StringBuffer message = new StringBuffer();
        logicConstraint.getMessage();
        String keyword = CDAModelUtil.getValidationKeyword((Element)constraint);
        if (keyword == null) {
            keyword = "SHALL";
        }
        if (!logicConstraint.getOperation().equals((Object)LogicalOperator.IFTHEN)) {
            message.append(markup ? "<b>" : "");
            message.append(keyword);
            message.append(markup ? "</b>" : "");
        }
        switch (logicConstraint.getOperation()) {
            case XOR: {
                message.append(" contain one and only one of the following ");
                break;
            }
            case AND: {
                message.append(" contain all of the following ");
                break;
            }
            case OR: {
                message.append(" contain one or more of the following ");
            }
            case IFTHEN: {
                message.append("if ");
                break;
            }
            case NOTBOTH: {
                message.append(" contain zero or one of the following but not both ");
                break;
            }
            default: {
                message.append(" satisfy the following ");
            }
        }
        if (logicConstraint.getOperation().equals((Object)LogicalOperator.IFTHEN) && constraint.getConstrainedElements().size() == 2) {
            String propertyKeyword = CDAModelUtil.getValidationKeyword((Element)constraint.getConstrainedElements().get(0));
            String conformanceMessage = CDAModelUtil.computeConformanceMessage((Element)constraint.getConstrainedElements().get(0), markup);
            if (propertyKeyword != null) {
                conformanceMessage = conformanceMessage.replace("<b>" + propertyKeyword + "</b> contain", "there is contained");
                conformanceMessage = conformanceMessage.replace(propertyKeyword, "");
                message.append(conformanceMessage);
            } else {
                message.append(conformanceMessage);
            }
            message.append(" then it ").append(markup ? "<lines>" : "").append(markup ? "<b>" : "").append(keyword).append(markup ? "</b> " : " ");
            message.append(CDAModelUtil.computeConformanceMessage((Element)constraint.getConstrainedElements().get(1), markup));
            message.append(markup ? "</lines>" : "");
        } else {
            if (markup) {
                message.append("<ol>");
            }
            for (Element element : constraint.getConstrainedElements()) {
                String computeAssociationConstraintsMsg;
                message.append(LI[0]);
                message.append(CDAModelUtil.computeConformanceMessage(element, markup));
                String propertyRules = "";
                if (element instanceof Property) {
                    Property property = (Property)element;
                    propertyRules = CDAModelUtil.appendPropertyRules(message, property);
                }
                if (propertyRules.length() > 0) {
                    message.append(propertyRules);
                } else if (element instanceof Property && !(computeAssociationConstraintsMsg = CDAModelUtil.computeAssociationConstraints((Property)element, markup)).isEmpty()) {
                    message.append("<ol>");
                    message.append(computeAssociationConstraintsMsg);
                    message.append("</ol>");
                }
                message.append(LI[1]);
            }
            if (markup) {
                message.append("</ol>");
            }
        }
        CDAModelUtil.appendConformanceRuleIds((Element)constraint, message, markup);
        return message.toString();
    }

    private static String appendPropertyRules(StringBuffer message, Property property) {
        Class umlClass = property.getClass_();
        ArrayList<Constraint> unprocessedConstraints = new ArrayList<Constraint>();
        HashMap<String, List<Constraint>> constraintMap = new HashMap<String, List<Constraint>>();
        HashMap<Constraint, List<Constraint>> subConstraintMap = new HashMap<Constraint, List<Constraint>>();
        for (Constraint constraint : umlClass.getOwnedRules()) {
            unprocessedConstraints.add(constraint);
            for (Element element : constraint.getConstrainedElements()) {
                List<Object> rules;
                if (CDAProfileUtil.getLogicalConstraint(constraint) != null) continue;
                if (element instanceof Property) {
                    String name = ((Property)element).getName();
                    rules = (ArrayList<Constraint>)constraintMap.get(name);
                    if (rules == null) {
                        rules = new ArrayList<Constraint>();
                        constraintMap.put(name, rules);
                    }
                    rules.add(constraint);
                    continue;
                }
                if (!(element instanceof Constraint)) continue;
                Constraint subConstraint = (Constraint)element;
                rules = (List)subConstraintMap.get(subConstraint);
                if (rules == null) {
                    rules = new ArrayList();
                    subConstraintMap.put(subConstraint, rules);
                }
                rules.add(constraint);
            }
        }
        StringBuilder sb = new StringBuilder();
        CDAModelUtil.appendPropertyRules(sb, property, constraintMap, subConstraintMap, unprocessedConstraints, true, true);
        return sb.toString();
    }

    private static boolean containsSeverityWord(String text) {
        return text.indexOf("SHALL") >= 0 || text.indexOf("SHOULD") >= 0 || text.indexOf("MAY") >= 0;
    }

    private static String replaceSeverityWithBold(String input) {
        String output = input.replaceAll("SHALL", "<b>SHALL</b>");
        output = output.replaceAll("SHOULD", "<b>SHOULD</b>");
        output = output.replaceAll("MAY", "<b>MAY</b>");
        output = output.replaceAll("\\<b>SHALL\\</b> NOT", "<b>SHALL NOT</b>");
        output = output.replaceAll("\\<b>SHOULD\\</b> NOT", "<b>SHOULD NOT</b>");
        return output;
    }

    public static IProject getElementModelProject(Element element) {
        try {
            Package elementPackage = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)element);
            if (elementPackage != null && elementPackage.eResource() != null) {
                FindResourcesByNameVisitor visitor = new FindResourcesByNameVisitor(elementPackage.eResource().getURI().lastSegment());
                IWorkspace iw = ResourcesPlugin.getWorkspace();
                iw.getRoot().accept((IResourceVisitor)visitor);
                if (!visitor.getResources().isEmpty()) {
                    return visitor.getResources().get(0).getProject();
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static IProject getModelDocProject(IProject modelProject) {
        if (modelProject != null && modelProject.exists()) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(modelProject.getName().replace(".model", ".doc"));
        }
        return null;
    }

    public static String computeXref(Element source, Classifier target) {
        if (target == null) {
            return null;
        }
        if (target instanceof Enumeration) {
            return CDAModelUtil.computeTerminologyXref(source, (Enumeration)target);
        }
        if (org.eclipse.mdht.uml.common.util.UMLUtil.isSameProject((Element)source, (Element)target)) {
            return "../" + CDAModelUtil.normalizeCodeName(target.getName()) + ".dita";
        }
        if (target instanceof Class && CDAModelUtil.isPublishSeperately((Class)target)) {
            return "../" + CDAModelUtil.normalizeCodeName(target.getName()) + ".dita";
        }
        if (!CDAModelUtil.isCDAModel((Element)target)) {
            String packageName;
            Path projectPath;
            IFolder referenceDitaFolder;
            IProject sourceProject = CDAModelUtil.getElementModelProject(source);
            sourceProject = CDAModelUtil.getModelDocProject(sourceProject);
            IProject targetProject = CDAModelUtil.getElementModelProject((Element)target);
            if ((targetProject = CDAModelUtil.getModelDocProject(targetProject)) != null && sourceProject != null && (referenceDitaFolder = sourceProject.getFolder((IPath)(projectPath = new Path("/dita/classes/" + targetProject.getName())))).exists()) {
                return "../" + targetProject.getName() + "/classes/" + CDAModelUtil.normalizeCodeName(target.getName()) + ".dita";
            }
            String pathFolder = "classes";
            String basePackage = "";
            String prefix = "";
            String string = packageName = target.getNearestPackage() != null ? target.getNearestPackage().getName() : "";
            if ("rim".equals(packageName)) {
                basePackage = "org.openhealthtools.mdht.uml.hl7.rim";
            } else if (CDA_PACKAGE_NAME.equals(packageName)) {
                basePackage = "org.openhealthtools.mdht.uml.cda";
            } else {
                basePackage = CDAModelUtil.getModelBasePackage((Element)target);
                prefix = CDAModelUtil.getModelNamespacePrefix((Element)target);
            }
            if (basePackage == null || basePackage.trim().length() == 0) {
                basePackage = "org.openhealthtools.mdht.uml.cda";
            }
            if (prefix != null && prefix.trim().length() > 0) {
                prefix = String.valueOf(prefix) + ".";
            }
            return String.valueOf(INFOCENTER_URL) + "/" + CDAModelUtil.getTemplateId((Class)target) + CDAModelUtil.getTemplateId((Class)target) + ".html";
        }
        return null;
    }

    protected static String computeTerminologyXref(Element source, Enumeration target) {
        String href = null;
        if (org.eclipse.mdht.uml.common.util.UMLUtil.isSameProject((Element)source, (Element)target)) {
            href = "../../terminology/" + CDAModelUtil.normalizeCodeName(target.getName()) + ".dita";
        }
        return href;
    }

    public static Property getNavigableEnd(Association association) {
        Property navigableEnd = null;
        for (Property end : association.getMemberEnds()) {
            if (!end.isNavigable()) continue;
            if (navigableEnd != null) {
                return null;
            }
            navigableEnd = end;
        }
        return navigableEnd;
    }

    private static String getExtensionNamespace(Type type) {
        Object object;
        Stereotype ecoreStereotype;
        String nameSpace = null;
        if (type != null && type.getNearestPackage() != null && !CDA_PACKAGE_NAME.equals(type.getNearestPackage().getName()) && (ecoreStereotype = type.getNearestPackage().getAppliedStereotype(EPACKAGE)) != null && (object = type.getNearestPackage().getValue(ecoreStereotype, NSPREFIX)) instanceof String) {
            nameSpace = (String)object;
        }
        return nameSpace;
    }

    public static String getNameSpacePrefix(Class cdaSourceClass) {
        Object object;
        Stereotype ecoreStereotype;
        if (cdaSourceClass != null && cdaSourceClass.getPackage() != null && !CDA_PACKAGE_NAME.equals(cdaSourceClass.getPackage().getName()) && (ecoreStereotype = cdaSourceClass.getPackage().getAppliedStereotype(EPACKAGE)) != null && (object = cdaSourceClass.getPackage().getValue(ecoreStereotype, NSPREFIX)) instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static String getCDAElementName(Property property) {
        Class cdaSourceClass;
        String elementName = null;
        if (property.getType() instanceof Class && (cdaSourceClass = CDAModelUtil.getCDAClass((Classifier)property.getClass_())) != null) {
            String modelPrefix;
            Property cdaProperty;
            for (Property redefinedProperty : property.getRedefinedProperties()) {
                Property cdaProperty2;
                if (redefinedProperty.getType() == null || (cdaProperty2 = cdaSourceClass.getOwnedAttribute(redefinedProperty.getName(), (Type)CDAModelUtil.getCDAClass((Classifier)redefinedProperty.getType()))) == null || cdaProperty2.getName() == null) continue;
                String modelPrefix2 = CDAModelUtil.getExtensionNamespace(cdaProperty2.getType());
                elementName = !StringUtils.isEmpty((String)modelPrefix2) ? String.valueOf(modelPrefix2) + ":" + cdaProperty2.getName() : cdaProperty2.getName();
                break;
            }
            if (elementName == null && (cdaProperty = cdaSourceClass.getOwnedAttribute(property.getName(), (Type)CDAModelUtil.getCDAClass((Classifier)property.getType()))) != null && cdaProperty.getName() != null) {
                modelPrefix = CDAModelUtil.getExtensionNamespace(cdaProperty.getType());
                String string = elementName = !StringUtils.isEmpty((String)modelPrefix) ? String.valueOf(modelPrefix) + ":" + cdaProperty.getName() : cdaProperty.getName();
            }
            if (elementName == null && (cdaProperty = cdaSourceClass.getOwnedAttribute(null, (Type)CDAModelUtil.getCDAClass((Classifier)property.getType()))) != null && cdaProperty.getName() != null) {
                modelPrefix = CDAModelUtil.getExtensionNamespace(cdaProperty.getType());
                String string = elementName = !StringUtils.isEmpty((String)modelPrefix) ? String.valueOf(modelPrefix) + ":" + cdaProperty.getName() : cdaProperty.getName();
            }
        }
        if (elementName == null) {
            elementName = CDAModelUtil.getCDAAssociationElementName(property);
        }
        if (elementName == null) {
            elementName = property.getName();
        }
        return elementName;
    }

    public static String getCDAAssociationElementName(Property property) {
        Class cdaSourceClass = CDAModelUtil.getCDAClass((Classifier)property.getClass_());
        Class endType = property.getType() instanceof Class ? (Class)property.getType() : null;
        Class cdaTargetClass = endType != null ? CDAModelUtil.getCDAClass((Classifier)endType) : null;
        String elementName = null;
        if (cdaSourceClass == null) {
            elementName = property.getName();
        } else if ("ClinicalDocument".equals(cdaSourceClass.getName()) && (CDAModelUtil.isSection((Type)cdaTargetClass) || CDAModelUtil.isClinicalStatement((Type)cdaTargetClass))) {
            elementName = "component";
        } else if (CDAModelUtil.isSection((Type)cdaSourceClass) && CDAModelUtil.isSection((Type)cdaTargetClass)) {
            elementName = "component";
        } else if (CDAModelUtil.isSection((Type)cdaSourceClass) && (CDAModelUtil.isClinicalStatement((Type)cdaTargetClass) || CDAModelUtil.isEntry((Type)cdaTargetClass))) {
            elementName = "entry";
        } else if (CDAModelUtil.isOrganizer((Type)cdaSourceClass) && CDAModelUtil.isClinicalStatement((Type)cdaTargetClass)) {
            elementName = "component";
        } else if (CDAModelUtil.isClinicalStatement((Type)cdaSourceClass) && CDAModelUtil.isClinicalStatement((Type)cdaTargetClass)) {
            elementName = "entryRelationship";
        } else if (CDAModelUtil.isClinicalStatement((Type)cdaSourceClass) && cdaTargetClass != null && "ParticipantRole".equals(cdaTargetClass.getName())) {
            elementName = "participant";
        } else if (CDAModelUtil.isClinicalStatement((Type)cdaSourceClass) && cdaTargetClass != null && "AssignedEntity".equals(cdaTargetClass.getName())) {
            elementName = "performer";
        }
        return elementName;
    }

    private static String getMultiplicityRange(Property property) {
        StringBuffer message = new StringBuffer();
        String lower = Integer.toString(property.getLower());
        String upper = property.getUpper() == -1 ? "*" : Integer.toString(property.getUpper());
        message.append(" [").append(lower).append("..").append(upper).append("]");
        return message.toString();
    }

    private static String getMultiplicityText(Property property) {
        StringBuffer message = new StringBuffer();
        if (property.getLower() == property.getUpper()) {
            if (property.getLower() != 0) {
                message.append("exactly ").append(CDAModelUtil.convertNumberToWords(property.getUpper()));
            }
        } else if (property.getLower() == 0) {
            if (property.getUpper() != 0) {
                if (property.getUpper() == 1) {
                    message.append("zero or one");
                } else if (property.getUpper() == -1) {
                    message.append("zero or more");
                } else {
                    message.append("not more than " + CDAModelUtil.convertNumberToWords(property.getUpper()));
                }
            }
        } else if (property.getLower() == 1) {
            if (property.getUpper() == -1) {
                message.append("at least one");
            } else {
                message.append("at least " + CDAModelUtil.convertNumberToWords(property.getLower()) + " and not more than " + CDAModelUtil.convertNumberToWords(property.getUpper()));
            }
        } else {
            message.append("at least " + CDAModelUtil.convertNumberToWords(property.getLower()));
            if (property.getUpper() != -1) {
                message.append(" and not more than " + CDAModelUtil.convertNumberToWords(property.getUpper()));
            }
        }
        return message.toString();
    }

    private static String convertNumberToWords(int n) {
        if (n < 0) {
            return "minus " + CDAModelUtil.convertNumberToWords(-n);
        }
        if (n <= 999) {
            return CDAModelUtil.convert999(n);
        }
        String s = null;
        int t = 0;
        while (n > 0) {
            if (n % 1000 != 0) {
                String s2 = CDAModelUtil.convert999(n % 1000);
                if (t > 0) {
                    s2 = String.valueOf(s2) + " " + bigNames[t - 1];
                }
                s = s == null ? s2 : String.valueOf(s2) + ", " + s;
            }
            n /= 1000;
            ++t;
        }
        return s;
    }

    private static String convert999(int n) {
        String s1 = String.valueOf(lowNames[n / 100]) + " hundred";
        String s2 = CDAModelUtil.convert99(n % 100);
        if (n <= 99) {
            return s2;
        }
        if (n % 100 == 0) {
            return s1;
        }
        return String.valueOf(s1) + " " + s2;
    }

    private static String convert99(int n) {
        if (n < 20) {
            return lowNames[n];
        }
        String s = tensNames[n / 10 - 2];
        if (n % 10 == 0) {
            return s;
        }
        return String.valueOf(s) + "-" + lowNames[n % 10];
    }

    public static boolean isXMLAttribute(Property property) {
        Stereotype eAttribute;
        Property cdaProperty = CDAModelUtil.getCDAProperty(property);
        return cdaProperty != null && (eAttribute = cdaProperty.getAppliedStereotype("Ecore::EAttribute")) != null;
    }

    private static String getMultiplicityRange(Class template) {
        String templateId = null;
        Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)template, "CDATemplate");
        if (hl7Template != null && template.hasValue(hl7Template, "templateMultiplicity")) {
            templateId = (String)template.getValue(hl7Template, "templateMultiplicity");
        } else {
            for (Classifier parent : template.getGenerals()) {
                templateId = CDAModelUtil.getMultiplicityRange((Class)parent);
                if (templateId != null) break;
            }
        }
        return templateId;
    }

    public String getPath(Class baseSourceClass, Class targetClass, Property sourceProperty) {
        Property property = null;
        for (Property rededfinedProperty : sourceProperty.getRedefinedProperties()) {
            property = baseSourceClass.getOwnedAttribute(rededfinedProperty.getName(), rededfinedProperty.getType(), true, null, false);
        }
        if (property == null) {
            property = baseSourceClass.getOwnedAttribute(null, (Type)targetClass, true, null, false);
        }
        if (property == null) {
            for (Classifier c : targetClass.allParents()) {
                property = baseSourceClass.getOwnedAttribute(null, (Type)c, true, null, false);
                if (property != null || CDAModelUtil.isCDAModel((Element)c)) break;
            }
        }
        if (property == null) {
            property = baseSourceClass.getOwnedAttribute(sourceProperty.getName(), null, true, null, false);
        }
        if (property != null) {
            return property.getName();
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    public static String getQualifiedName(org.eclipse.mdht.uml.cda.core.profile.ValueSetConstraint vsc) {
        block3: {
            if (vsc.getBase_Property() == null) break block3;
            properties = new Stack<Property>();
            properties.push(vsc.getBase_Property());
            owner = vsc.getBase_Property().getOwner();
            if (owner != null) ** GOTO lbl13
            return "INVALID " + EcoreUtil.getID((EObject)vsc);
lbl-1000:
            // 1 sources

            {
                c = (Class)owner.getOwner();
                properties.push(c.getAttribute(null, (Type)owner));
                if (owner.getOwner() == null) break;
                owner = owner.getOwner();
lbl13:
                // 2 sources

                ** while (owner.getOwner() instanceof Class)
            }
lbl14:
            // 2 sources

            qualifiedName = new StringBuffer();
            for (Property p : properties) {
                if (p != null) {
                    qualifiedName.insert(0, "/");
                    qualifiedName.insert(0, p.getName());
                    continue;
                }
                qualifiedName.insert(0, "/");
                qualifiedName.insert(0, "NULL PROPERTY");
            }
            qualifiedName.insert(0, "/");
            qualifiedName.insert(0, CDAModelUtil.getCDAClass((Classifier)owner).getName());
            return qualifiedName.toString();
        }
        return "INVALID " + EcoreUtil.getID((EObject)vsc);
    }

    public static String getValueSetName(org.eclipse.mdht.uml.cda.core.profile.ValueSetConstraint vsc) {
        if (vsc.getReference() != null) {
            if (!StringUtils.isEmpty((String)vsc.getReference().getFullName())) {
                return vsc.getReference().getFullName();
            }
            return vsc.getReference().getEnumerationName();
        }
        return "INVALID";
    }

    public static String getTemplateClassName(org.eclipse.mdht.uml.cda.core.profile.ValueSetConstraint vsc) {
        if (vsc.getBase_Property() != null && vsc.getBase_Property().getOwner() != null) {
            Element owner = vsc.getBase_Property().getOwner();
            while (owner.getOwner() instanceof Class) {
                owner = owner.getOwner();
            }
            return ((NamedElement)owner).getName();
        }
        return "INVALID " + vsc.getRuleId().toString();
    }

    public static String getValidationKeyword(org.eclipse.mdht.uml.cda.core.profile.ValueSetConstraint vsc) {
        String templateId = "";
        if (vsc.getBase_Property() != null) {
            templateId = CDAModelUtil.getValidationKeyword(vsc.getBase_Property());
        }
        return templateId;
    }

    public Boolean fileExists(String filepath) throws IOException {
        java.nio.file.Path p = Paths.get(filepath, new String[0]);
        p.normalize();
        File f = new File(filepath);
        return f.exists();
    }

    public String createHeader(String filepath) throws IOException {
        java.nio.file.Path p = Paths.get(filepath, new String[0]);
        p.normalize();
        File f = new File(filepath);
        if (!f.exists()) {
            f.createNewFile();
            BufferedWriter bw = null;
            FileWriter fw = null;
            fw = new FileWriter(f.getAbsoluteFile(), true);
            bw = new BufferedWriter(fw);
            bw.write("Template ID\tTemplate Name\tPath\tOID\tName\tSeverity\tCombined1\tCombined2");
            bw.close();
        }
        return "";
    }

    public static String getTemplateId2(org.eclipse.mdht.uml.cda.core.profile.ValueSetConstraint vsc) {
        if (vsc.getBase_Property() != null) {
            Element owner = vsc.getBase_Property().getOwner();
            while (owner instanceof Class) {
                Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype(owner, "CDATemplate");
                if (hl7Template != null) {
                    String result = (String)owner.getValue(hl7Template, "templateId");
                    String version = (String)owner.getValue(hl7Template, "templateVersion");
                    return String.valueOf(result) + (StringUtils.isEmpty((String)version) ? "" : "v" + version);
                }
                owner = owner.getOwner();
            }
        }
        return "MISSING";
    }

    public static String getVersion(org.eclipse.mdht.uml.cda.core.profile.ValueSetConstraint vsc) {
        if (vsc.getBase_Property() != null) {
            Element owner = vsc.getBase_Property().getOwner();
            while (owner instanceof Class) {
                Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype(owner, "CDATemplate");
                if (hl7Template != null) {
                    String version = (String)owner.getValue(hl7Template, "templateVersion");
                    if (StringUtils.isEmpty((String)version)) {
                        return "1.2";
                    }
                    return "2.1";
                }
                owner = owner.getOwner();
            }
        }
        return "MISSING";
    }

    public static String getTemplateId(Class template) {
        String templateId = null;
        Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)template, "CDATemplate");
        if (hl7Template != null) {
            templateId = (String)template.getValue(hl7Template, "templateId");
        } else {
            for (Classifier parent : template.getGenerals()) {
                templateId = CDAModelUtil.getTemplateId((Class)parent);
                if (templateId != null) break;
            }
        }
        return templateId;
    }

    public static String getTemplateVersion(Class template) {
        String templateVersion = null;
        Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)template, "CDATemplate");
        if (hl7Template != null) {
            templateVersion = (String)template.getValue(hl7Template, "templateVersion");
        } else {
            for (Classifier parent : template.getGenerals()) {
                templateVersion = CDAModelUtil.getTemplateId((Class)parent);
                if (templateVersion != null) break;
            }
        }
        return templateVersion;
    }

    public static String getAssigningAuthorityName(Class template) {
        String assigningAuthorityName = null;
        Stereotype hl7Template = CDAProfileUtil.getAppliedCDAStereotype((Element)template, "CDATemplate");
        if (hl7Template != null) {
            assigningAuthorityName = (String)template.getValue(hl7Template, "assigningAuthorityName");
        } else {
            for (Classifier parent : template.getGenerals()) {
                assigningAuthorityName = CDAModelUtil.getAssigningAuthorityName((Class)parent);
                if (assigningAuthorityName != null) break;
            }
        }
        return assigningAuthorityName;
    }

    public static String getModelPrefix(Element element) {
        String prefix = null;
        Package thePackage = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)element);
        if (thePackage != null) {
            Stereotype codegenSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)thePackage, "CodegenSupport");
            if (codegenSupport != null) {
                prefix = (String)thePackage.getValue(codegenSupport, "prefix");
            } else if (CDA_PACKAGE_NAME.equals(thePackage.getName())) {
                prefix = "CDA";
            } else if ("rim".equals(thePackage.getName())) {
                prefix = "RIM";
            }
        }
        return prefix != null ? prefix : "";
    }

    public static String getModelNamespacePrefix(Element element) {
        String prefix = null;
        Package model = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)element);
        Stereotype codegenSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)model, "CodegenSupport");
        if (codegenSupport != null) {
            prefix = (String)model.getValue(codegenSupport, NSPREFIX);
        }
        return prefix;
    }

    public static String getModelBasePackage(Element element) {
        String basePackage = null;
        Package model = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)element);
        Stereotype codegenSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)model, "CodegenSupport");
        if (codegenSupport != null) {
            basePackage = (String)model.getValue(codegenSupport, "basePackage");
        }
        return basePackage;
    }

    public static String getEcorePackageURI(Element element) {
        String nsURI = null;
        Package model = org.eclipse.mdht.uml.common.util.UMLUtil.getTopPackage((Element)element);
        Stereotype codegenSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)model, "CodegenSupport");
        if (codegenSupport != null) {
            nsURI = (String)model.getValue(codegenSupport, NSURI);
        }
        if (nsURI == null) {
            if (model.getName().equals(CDA_PACKAGE_NAME)) {
                nsURI = "urn:hl7-org:v3";
            } else if (model.getName().equals("datatypes")) {
                nsURI = DATATYPES_NS_URI;
            } else if (model.getName().equals("vocab")) {
                nsURI = "http://www.openhealthtools.org/mdht/uml/hl7/vocab";
            }
        }
        return nsURI;
    }

    public static String getPrefixedSplitName(NamedElement element) {
        StringBuffer buffer = new StringBuffer();
        String modelPrefix = CDAModelUtil.getModelPrefix((Element)element);
        if (modelPrefix != null && modelPrefix.length() > 0) {
            buffer.append(modelPrefix).append(" ");
        }
        buffer.append(org.eclipse.mdht.uml.common.util.UMLUtil.splitName((NamedElement)element));
        return buffer.toString();
    }

    public static List<String> getConformanceRuleIdList(Element element) {
        ArrayList<String> ruleIds = new ArrayList<String>();
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype(element, "Validation");
        if (validationSupport != null) {
            Validation validation = (Validation)element.getStereotypeApplication(validationSupport);
            for (String ruleId : validation.getRuleId()) {
                ruleIds.add(ruleId);
            }
        }
        return ruleIds;
    }

    protected static void appendTerminologyConformanceRuleIds(Property property, StringBuffer message, boolean markup) {
        String ruleIds = CDAModelUtil.getTerminologyConformanceRuleIds(property);
        if (ruleIds.length() > 0) {
            message.append(" (");
            message.append(ruleIds);
            message.append(")");
        }
    }

    protected static void appendConformanceRuleIds(Property property, StringBuffer message, boolean markup) {
        String ruleIds = CDAModelUtil.getConformanceRuleIds(property);
        if (ruleIds.length() > 0) {
            message.append(" (");
            message.append(ruleIds);
            message.append(")");
        }
    }

    protected static void appendConformanceRuleIds(Association association, StringBuffer message, boolean markup) {
        String ruleIds = CDAModelUtil.getConformanceRuleIds(association);
        if (ruleIds.length() > 0) {
            message.append(" (");
            message.append(ruleIds);
            message.append(")");
        }
    }

    protected static void appendConformanceRuleIds(Element element, StringBuffer message, boolean markup) {
        String ruleIds = CDAModelUtil.getConformanceRuleIds(element);
        if (ruleIds.length() > 0) {
            message.append(" (");
            message.append(ruleIds);
            message.append(")");
        }
    }

    protected static void appendConformanceRuleIds(Element element, Stereotype stereotype, StringBuffer message, boolean markup) {
        String ruleIds = CDAModelUtil.getConformanceRuleIds(element, stereotype);
        if (ruleIds.length() > 0) {
            message.append(" (");
            message.append(ruleIds);
            message.append(")");
        }
    }

    public static String getConformanceRuleIds(Property property) {
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)property, "PropertyValidation");
        return CDAModelUtil.getConformanceRuleIds((Element)property, validationSupport);
    }

    public static String getTerminologyConformanceRuleIds(Property property) {
        Stereotype terminologyConstraint = CDAModelUtil.getTerminologyConstraint((Element)property);
        return CDAModelUtil.getConformanceRuleIds((Element)property, terminologyConstraint);
    }

    public static String getConformanceRuleIds(Association association) {
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype((Element)association, "AssociationValidation");
        return CDAModelUtil.getConformanceRuleIds((Element)association, validationSupport);
    }

    public static String getConformanceRuleIds(Element element) {
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype(element, "Validation");
        return CDAModelUtil.getConformanceRuleIds(element, validationSupport);
    }

    public static String getConformanceRuleIds(Element element, Stereotype validationSupport) {
        StringBuffer ruleIdDisplay = new StringBuffer();
        if (validationSupport != null) {
            Validation validation = (Validation)element.getStereotypeApplication(validationSupport);
            for (String ruleId : validation.getRuleId()) {
                if (ruleIdDisplay.length() > 0) {
                    ruleIdDisplay.append(", ");
                }
                ruleIdDisplay.append(ruleId);
            }
        }
        return ruleIdDisplay.toString();
    }

    public static Stereotype getTerminologyConstraint(Element element) {
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype(element, "ConceptDomainConstraint");
        if (stereotype == null) {
            stereotype = CDAProfileUtil.getAppliedCDAStereotype(element, "CodeSystemConstraint");
        }
        if (stereotype == null) {
            stereotype = CDAProfileUtil.getAppliedCDAStereotype(element, "ValueSetConstraint");
        }
        return stereotype;
    }

    public static boolean hasValidationSupport(Element element) {
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype(element, "Validation");
        return validationSupport != null;
    }

    @Deprecated
    public static String getValidationSeverity(Property property) {
        return CDAModelUtil.getValidationSeverity(property, "PropertyValidation");
    }

    public static String getValidationSeverity(Property property, String validationStereotypeName) {
        Stereotype validationStereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)property, validationStereotypeName);
        return CDAModelUtil.getValidationSeverity((Element)property, validationStereotype);
    }

    public static String getValidationSeverity(Element element) {
        return CDAModelUtil.getValidationSeverity(element, "Validation");
    }

    public static String getValidationSeverity(Element element, String validationStereotypeName) {
        Stereotype validationStereotype = CDAProfileUtil.getAppliedCDAStereotype(element, validationStereotypeName);
        return CDAModelUtil.getValidationSeverity(element, validationStereotype);
    }

    public static String getValidationSeverity(Element element, Stereotype validationStereotype) {
        String severity = null;
        if (validationStereotype != null && CDAProfileUtil.isValidationStereotype(validationStereotype)) {
            Object value = element.getValue(validationStereotype, "severity");
            if (value instanceof EnumerationLiteral) {
                severity = ((EnumerationLiteral)value).getName();
            } else if (value instanceof Enumerator) {
                severity = ((Enumerator)value).getName();
            }
        }
        return severity;
    }

    public static Boolean getValidationNegation(Element element, Stereotype validationStereotype) {
        Object value;
        Boolean negation = false;
        if (validationStereotype != null && CDAProfileUtil.isValidationStereotype(validationStereotype) && (value = element.getValue(validationStereotype, "negationIndicator")) instanceof Boolean) {
            negation = (Boolean)value;
        }
        return negation;
    }

    public static String getValidationKeywordWithPropertyRange(Property property) {
        String keyword = CDAModelUtil.getValidationKeyword(property);
        return CDAModelUtil.addShallNot(keyword, property);
    }

    public static String getValidationKeyword(Property property) {
        String severity = CDAModelUtil.getValidationSeverity(property, "PropertyValidation");
        Stereotype validationStereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)property, "PropertyValidation");
        boolean isNegated = CDAModelUtil.getValidationNegation((Element)property, validationStereotype);
        if (severity == null) {
            severity = CDAModelUtil.getValidationSeverity((Element)property);
        }
        String keyword = CDAModelUtil.getValidationKeyword(severity);
        if (isNegated) {
            keyword = String.valueOf(keyword) + " NOT";
        }
        return keyword;
    }

    public static String getValidationKeywordWithPropertyRange(Element element, Property property) {
        String keyword = CDAModelUtil.getValidationKeyword(element);
        keyword = CDAModelUtil.addShallNot(keyword, property);
        return keyword;
    }

    private static String addShallNot(String keyword, Property property) {
        if (property.getLower() == 0 && property.getUpper() == 0 && "SHALL".equals(keyword)) {
            keyword = String.valueOf(keyword) + " NOT";
        }
        return keyword;
    }

    public static String getValidationKeyword(Element element) {
        String severity = CDAModelUtil.getValidationSeverity(element);
        return CDAModelUtil.getValidationKeyword(severity);
    }

    public static String getValidationKeyword(Element element, Stereotype validationStereotype) {
        String severity = CDAModelUtil.getValidationSeverity(element, validationStereotype);
        return CDAModelUtil.getValidationKeyword(severity);
    }

    private static String getValidationKeyword(String severity) {
        String keyword = null;
        if (SEVERITY_INFO.equals(severity)) {
            keyword = "MAY";
        } else if (SEVERITY_WARNING.equals(severity)) {
            keyword = "SHOULD";
        } else if (SEVERITY_ERROR.equals(severity)) {
            keyword = "SHALL";
        }
        return keyword;
    }

    public static void setValidationMessage(Element constrainedElement, String message) {
        Stereotype validationSupport = CDAProfileUtil.getAppliedCDAStereotype(constrainedElement, "Validation");
        if (validationSupport != null) {
            constrainedElement.setValue(validationSupport, "message", (Object)message);
        }
    }

    protected static String getLiteralValue(Element element, Stereotype stereotype, String propertyName) {
        Object value = element.getValue(stereotype, propertyName);
        String name = null;
        if (value instanceof EnumerationLiteral) {
            name = ((EnumerationLiteral)value).getName();
        } else if (value instanceof Enumerator) {
            name = ((Enumerator)value).getName();
        }
        return name;
    }

    protected static String getLiteralValueLabel(Element element, Stereotype stereotype, String propertyName, Enumeration umlEnumeration) {
        Object value = element.getValue(stereotype, propertyName);
        String name = null;
        if (value instanceof EnumerationLiteral) {
            name = ((EnumerationLiteral)value).getLabel();
        } else if (value instanceof Enumerator) {
            name = ((Enumerator)value).getName();
            if (umlEnumeration != null) {
                name = umlEnumeration.getOwnedLiteral(name).getLabel();
            }
        }
        return name;
    }

    public static String fixNonXMLCharacters(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer newText = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\u201d') {
                newText.append("\"");
            } else if (text.charAt(i) == '\u201c') {
                newText.append("\"");
            } else if (text.charAt(i) == '\u2019') {
                newText.append("'");
            } else if (text.charAt(i) == '\u2018') {
                newText.append("'");
            } else {
                newText.append(text.charAt(i));
            }
            ++i;
        }
        return newText.toString().replace("&lt;/p>", "").replace("&lt;p>", "").replace("<p>", "").replace("</p>", "");
    }

    public static String escapeMarkupCharacters(String text) {
        if (text == null) {
            return null;
        }
        text = CDAModelUtil.fixNonXMLCharacters(text);
        StringBuffer newText = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '<') {
                newText.append("&lt;");
            } else if (text.charAt(i) == '>') {
                newText.append("&gt;");
            } else {
                newText.append(text.charAt(i));
            }
            ++i;
        }
        return newText.toString();
    }

    public static String normalizeCodeName(String name) {
        String[] parts;
        if (StringUtils.isEmpty((String)name)) {
            return SEVERITY_ERROR;
        }
        String result = "";
        String[] stringArray = parts = name.split(" ");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result = String.valueOf(result) + part.substring(0, 1).toUpperCase() + part.substring(1);
            ++n2;
        }
        result = UML2Util.getValidJavaIdentifier((String)result);
        return result;
    }

    private static String mandatoryOrNotMessage(Property curProperty) {
        boolean mandatory = CDAProfileUtil.isMandatory((Element)curProperty);
        return mandatory ? ", where the @code " : ", which ";
    }

    public static boolean isInlineClass(Class _class) {
        Inline inline = CDAProfileUtil.getInline(_class);
        if (inline != null) {
            return true;
        }
        if (_class.getOwner() instanceof Class) {
            return true;
        }
        for (Comment comment : _class.getOwnedComments()) {
            if (!comment.getBody().startsWith("INLINE")) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisplayInline(Class endType) {
        if (endType == null) {
            return false;
        }
        return CDAModelUtil.isInlineClass(endType) && !CDAModelUtil.isPublishSeperately(endType);
    }

    public static boolean isDisplayInline(Property property) {
        Class endType = property.getType() instanceof Class ? (Class)property.getType() : null;
        return CDAModelUtil.isDisplayInline(endType);
    }

    public static String getInlineFilter(Class inlineClass) {
        Inline inline = CDAProfileUtil.getInline(inlineClass);
        if (inline != null) {
            return inline.getFilter() != null ? inline.getFilter() : "";
        }
        String filter = "";
        for (Comment comment : inlineClass.getOwnedComments()) {
            if (!comment.getBody().startsWith("INLINE&")) continue;
            String[] temp = comment.getBody().split("&");
            if (temp.length != 2) break;
            filter = String.format("->select(%s)", temp[1]);
            break;
        }
        if ("".equals(filter)) {
            for (Classifier next : inlineClass.getGenerals()) {
                if (next instanceof Class && !"".equals(filter = CDAModelUtil.getInlineFilter((Class)next))) break;
            }
        }
        return filter;
    }

    public static boolean isPublishSeperately(Class _class) {
        boolean publish = false;
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)_class, "Inline");
        if (stereotype != null) {
            Boolean result = (Boolean)_class.getValue(stereotype, "publishSeperately");
            publish = result;
        }
        return publish;
    }

    public static class FindResourcesByNameVisitor
    implements IResourceVisitor {
        private String resourceName;
        private ArrayList<IResource> resources = new ArrayList();

        public ArrayList<IResource> getResources() {
            return this.resources;
        }

        public FindResourcesByNameVisitor(String resourceName) {
            this.resourceName = resourceName;
        }

        public boolean visit(IResource arg0) throws CoreException {
            if (this.resourceName != null && this.resourceName.equals(arg0.getName())) {
                this.resources.add(arg0);
            }
            return true;
        }
    }
}

