/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValueSetBinding implements Enumerator
{
    DIRECT(0, "Direct", "Direct"),
    INDIRECT(1, "Indirect", "Indirect");

    public static final int DIRECT_VALUE = 0;
    public static final int INDIRECT_VALUE = 1;
    private static final ValueSetBinding[] VALUES_ARRAY;
    public static final List<ValueSetBinding> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValueSetBinding[]{DIRECT, INDIRECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValueSetBinding get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueSetBinding result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueSetBinding getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueSetBinding result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueSetBinding get(int value) {
        switch (value) {
            case 0: {
                return DIRECT;
            }
            case 1: {
                return INDIRECT;
            }
        }
        return null;
    }

    private ValueSetBinding(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

