/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.term.core.profile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Guidance implements Enumerator
{
    FIXED(0, "FIXED", "FIXED"),
    CLOSED(1, "CLOSED", "CLOSED"),
    EXTEND(2, "EXTEND", "EXTEND"),
    RESTRICT(3, "RESTRICT", "RESTRICT"),
    OPEN(4, "OPEN", "OPEN");

    public static final int FIXED_VALUE = 0;
    public static final int CLOSED_VALUE = 1;
    public static final int EXTEND_VALUE = 2;
    public static final int RESTRICT_VALUE = 3;
    public static final int OPEN_VALUE = 4;
    private static final Guidance[] VALUES_ARRAY;
    public static final List<Guidance> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Guidance[]{FIXED, CLOSED, EXTEND, RESTRICT, OPEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Guidance get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Guidance result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Guidance getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Guidance result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Guidance get(int value) {
        switch (value) {
            case 0: {
                return FIXED;
            }
            case 1: {
                return CLOSED;
            }
            case 2: {
                return EXTEND;
            }
            case 3: {
                return RESTRICT;
            }
            case 4: {
                return OPEN;
            }
        }
        return null;
    }

    private Guidance(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

