/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.ui.properties.internal.UmlUiEditor;
import org.eclipse.mdht.uml.ui.properties.internal.sections.ConstraintEditor;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileEnvironment;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileEnvironmentFactory;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.uml.OCL;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintSection
extends WrapperAwareModelerPropertySection {
    public Constraint constraint;
    public CCombo languageCombo;
    private boolean languageModified = false;
    private boolean ditaModified = false;
    private Button closeErrorTextButton;
    private Text errorText;
    private Button ditaEnableButton;
    private CLabel currentLanguagesLabel;
    protected Text bodyText;
    public boolean bodyModified = false;
    private List<String> languages = new ArrayList<String>();
    private Map<String, ConstraintEditor> contributors = new LinkedHashMap<String, ConstraintEditor>();
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (ConstraintSection.this.bodyText == event.getSource()) {
                ConstraintSection.this.bodyModified = true;
            }
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if ('\r' == e.character || '\u1000050' == e.character) {
                ConstraintSection.this.modifyFields();
            }
        }
    };
    private FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            ConstraintSection.this.modifyFields();
        }
    };
    private static String T1 = "ConstraintValidation";

    private void validateOCL() {
        block7: {
            if (this.constraint.getContext() instanceof Classifier) {
                ResourceSet rset = this.constraint.eResource().getResourceSet();
                OCL oclEnv = OCL.newInstance((EnvironmentFactory)new EcoreProfileEnvironmentFactory(rset));
                OCL.Helper helper = oclEnv.createOCLHelper();
                String ocl = this.bodyText.getText().trim();
                helper.setContext((Object)((Classifier)this.constraint.getContext()));
                try {
                    try {
                        if (EcoreProfileEnvironment.isQueryConstraint((Constraint)this.constraint)) {
                            helper.createQuery(ocl);
                            break block7;
                        }
                        helper.createInvariant(ocl);
                    }
                    catch (ParserException pe) {
                        Shell shell = new Shell();
                        MessageBox messageBox = new MessageBox(shell, 8);
                        messageBox.setText("OCL Error ");
                        messageBox.setMessage(pe.getMessage());
                        messageBox.open();
                        oclEnv.dispose();
                    }
                }
                finally {
                    oclEnv.dispose();
                }
            }
        }
    }

    public void modifyFields() {
        if (!(this.bodyModified || this.languageModified || this.ditaModified)) {
            return;
        }
        if (this.languageCombo.getSelectionIndex() == 1) {
            this.validateOCL();
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.constraint);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    int languageIndex = ConstraintSection.this.languageCombo.getSelectionIndex();
                    if (languageIndex == -1) {
                        languageIndex = 0;
                    }
                    String language = (String)ConstraintSection.this.languages.get(languageIndex);
                    String body = ConstraintSection.this.bodyText.getText().trim();
                    ValueSpecification spec = ConstraintSection.this.constraint.getSpecification();
                    if (spec == null) {
                        spec = ConstraintSection.this.constraint.createSpecification(null, null, UMLPackage.eINSTANCE.getOpaqueExpression());
                    }
                    if (spec instanceof OpaqueExpression) {
                        OpaqueExpression oESpec = (OpaqueExpression)spec;
                        if (ConstraintSection.this.bodyModified) {
                            ConstraintSection.this.bodyModified = false;
                            this.setLabel("Set Constraint Body");
                            int specIndex = -1;
                            int i = 0;
                            while (i < oESpec.getLanguages().size()) {
                                String lang = (String)oESpec.getLanguages().get(i);
                                if (language.equals(lang)) {
                                    specIndex = i;
                                }
                                ++i;
                            }
                            if (specIndex >= 0) {
                                if (body.length() == 0) {
                                    oESpec.getLanguages().remove(specIndex);
                                    oESpec.getBodies().remove(specIndex);
                                } else {
                                    oESpec.getBodies().set(specIndex, (Object)body);
                                }
                            } else if (body.length() > 0) {
                                oESpec.getLanguages().add((Object)language);
                                oESpec.getBodies().add((Object)body);
                            }
                        }
                        if (ConstraintSection.this.ditaModified) {
                            ConstraintSection.this.ditaModified = false;
                            ((ConstraintEditor)ConstraintSection.this.contributors.get(language)).setDitaEnabled(ConstraintSection.this.ditaEnableButton.getSelection());
                            if (!ConstraintSection.this.ditaEnableButton.getSelection()) {
                                ConstraintSection.this.errorText.setVisible(false);
                                ConstraintSection.this.closeErrorTextButton.setVisible(false);
                            }
                        }
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    ConstraintSection.this.refresh();
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void loadUIExtensions() throws CoreException {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.mdht.uml.ui.properties.ConstraintEditor");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] ce = ext.getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String language = ce[j].getAttribute("language");
                ConstraintEditor newContributor = (ConstraintEditor)ce[j].createExecutableExtension("component");
                ConstraintEditor previousContributor = this.contributors.get(language);
                if (!(previousContributor instanceof UmlUiEditor)) {
                    if (previousContributor == null) {
                        this.languages.add(language);
                        this.contributors.put(language, newContributor);
                    }
                } else {
                    this.contributors.put(language, newContributor);
                }
                ++j;
            }
            ++i;
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        try {
            this.loadUIExtensions();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(shell.getFont());
        Point point = gc.textExtent("");
        int charHeight = point.y;
        gc.dispose();
        shell.dispose();
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        this.languageCombo = this.getWidgetFactory().createCCombo(composite, 0x800008);
        this.languageCombo.setItems(this.languages.toArray(new String[1]));
        this.languageCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ConstraintSection.this.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                ConstraintSection.this.refresh();
            }
        });
        CLabel languageLabel = this.getWidgetFactory().createCLabel(composite, "Language:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.languageCombo, 0, 0x1000000);
        languageLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)languageLabel, 0);
        data.top = new FormAttachment(0, 4);
        this.languageCombo.setLayoutData((Object)data);
        CLabel assignedLabel = this.getWidgetFactory().createCLabel(composite, "Assigned Expressions:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.languageCombo, 5);
        data.top = new FormAttachment((Control)this.languageCombo, 0, 0x1000000);
        assignedLabel.setLayoutData((Object)data);
        this.currentLanguagesLabel = this.getWidgetFactory().createCLabel(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)assignedLabel, 0);
        data.top = new FormAttachment((Control)this.languageCombo, 0, 0x1000000);
        this.currentLanguagesLabel.setLayoutData((Object)data);
        this.ditaEnableButton = this.getWidgetFactory().createButton(composite, "Enable DITA", 32);
        data = new FormData();
        data.left = new FormAttachment((Control)this.currentLanguagesLabel, 5);
        data.top = new FormAttachment((Control)this.languageCombo, 0, 0x1000000);
        this.ditaEnableButton.setLayoutData((Object)data);
        this.ditaEnableButton.setEnabled(true);
        this.ditaEnableButton.setVisible(false);
        this.ditaEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ConstraintSection.this.ditaModified = true;
                ConstraintSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ConstraintSection.this.ditaModified = true;
                ConstraintSection.this.modifyFields();
            }
        });
        this.bodyText = this.getWidgetFactory().createText(composite, "", 576);
        for (ConstraintEditor ce : this.contributors.values()) {
            ce.setText(this.bodyText);
        }
        CLabel bodyLabel = this.getWidgetFactory().createCLabel(composite, "Body:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.languageCombo, 0, 1024);
        bodyLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)bodyLabel, 0);
        data.width = 300;
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.languageCombo, 0, 1024);
        data.height = charHeight * 4;
        this.bodyText.setLayoutData((Object)data);
        this.errorText = this.getWidgetFactory().createText(composite, "Error message here", 576);
        data = new FormData();
        data.left = new FormAttachment((Control)bodyLabel, 0);
        data.width = 300;
        data.right = new FormAttachment(85, 0);
        data.top = new FormAttachment((Control)this.bodyText, 0, 1024);
        data.height = charHeight * 2;
        this.errorText.setLayoutData((Object)data);
        this.errorText.setEnabled(false);
        this.errorText.setVisible(false);
        this.closeErrorTextButton = this.getWidgetFactory().createButton(composite, "Close DITA Error", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.errorText, 5);
        data.top = new FormAttachment((Control)this.errorText, 0, 0x1000000);
        this.closeErrorTextButton.setLayoutData((Object)data);
        this.closeErrorTextButton.setEnabled(true);
        this.closeErrorTextButton.setVisible(false);
        this.closeErrorTextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConstraintSection.this.closeErrorTextButton.setVisible(false);
                ConstraintSection.this.errorText.setVisible(false);
            }
        });
        for (ConstraintEditor ce : this.contributors.values()) {
            ce.setCloseErrorText(this.closeErrorTextButton);
            ce.setErrorText(this.errorText);
        }
    }

    @Override
    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.constraint != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.constraint)) != null && editingDomain.isReadOnly(this.constraint.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Constraint));
        this.constraint = (Constraint)element;
        this.initializeLanguageSelection();
    }

    public void dispose() {
        super.dispose();
    }

    private void initializeLanguageSelection() {
        int languageIndex;
        OpaqueExpression spec = this.constraint.getSpecification() instanceof OpaqueExpression ? (OpaqueExpression)this.constraint.getSpecification() : null;
        int currentIndex = this.languageCombo.getSelectionIndex();
        String currentLanguage = currentIndex == -1 ? "" : this.languageCombo.getItem(currentIndex);
        int n = languageIndex = currentIndex == -1 ? 0 : currentIndex;
        if (spec != null) {
            EList specLangs = spec.getLanguages();
            EList specBodies = spec.getBodies();
            if (!specLangs.contains(currentLanguage)) {
                int i = 0;
                while (i < specBodies.size() && i < specLangs.size()) {
                    if (!UML2Util.isEmpty((String)((String)specBodies.get(i))) && this.languages.contains(specLangs.get(i))) {
                        languageIndex = this.languages.indexOf(specLangs.get(i));
                        break;
                    }
                    ++i;
                }
            }
        }
        this.languageCombo.select(languageIndex);
    }

    public void refresh() {
        for (ConstraintEditor ce : this.contributors.values()) {
            ce.setConstraint(this.constraint);
        }
        OpaqueExpression spec = this.constraint.getSpecification() instanceof OpaqueExpression ? (OpaqueExpression)this.constraint.getSpecification() : null;
        String language = null;
        String body = null;
        int languageIndex = this.languageCombo.getSelectionIndex();
        if (languageIndex == -1) {
            languageIndex = 0;
            if (spec != null) {
                EList specLangs = spec.getLanguages();
                EList specBodies = spec.getBodies();
                int i = 0;
                while (i < specBodies.size() && i < specLangs.size()) {
                    if (!UML2Util.isEmpty((String)((String)specBodies.get(i))) && this.languages.contains(specLangs.get(i))) {
                        languageIndex = this.languages.indexOf(specLangs.get(i));
                        body = (String)specBodies.get(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        language = this.languages.get(languageIndex);
        StringBuilder languagesList = new StringBuilder();
        if (spec != null) {
            int i = 0;
            while (i < spec.getLanguages().size()) {
                String lang = (String)spec.getLanguages().get(i);
                if (languagesList.length() > 0) {
                    languagesList.append(", ");
                }
                languagesList.append(lang);
                if (language.equals(lang)) {
                    body = (String)spec.getBodies().get(i);
                }
                ++i;
            }
        }
        this.languageCombo.select(languageIndex);
        this.currentLanguagesLabel.setText(languagesList.toString());
        this.bodyText.removeModifyListener(this.modifyListener);
        this.bodyText.removeKeyListener(this.keyListener);
        this.bodyText.removeFocusListener(this.focusListener);
        this.bodyText.setText(body != null ? body : "");
        this.bodyText.addModifyListener(this.modifyListener);
        this.bodyText.addKeyListener(this.keyListener);
        this.bodyText.addFocusListener(this.focusListener);
        if (this.isReadOnly()) {
            this.languageCombo.setEnabled(false);
            this.bodyText.setEnabled(false);
        } else {
            this.languageCombo.setEnabled(true);
            this.bodyText.setEnabled(true);
        }
        if ("Analysis".equals(this.languageCombo.getText())) {
            this.ditaEnableButton.setSelection(this.contributors.get(language).isDitaEnabled());
            this.ditaEnableButton.setVisible(true);
        } else {
            this.ditaEnableButton.setVisible(false);
            this.closeErrorTextButton.setVisible(false);
            this.errorText.setVisible(false);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ConstraintSection.this.isDisposed() && ConstraintSection.this.constraint.eResource() != null) {
                        ConstraintSection.this.refresh();
                    }
                }
            });
        }
    }
}

