/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;

public class PropertyList {
    private Class clazz;
    private List<Property> attributes;
    private List<Property> associationEnds;
    private boolean isOmitAssociations = false;
    private boolean isAllSuperclasses = true;
    private boolean isSorted = false;

    public PropertyList(Class clazz) {
        this.clazz = clazz;
    }

    public PropertyList(Class clazz, boolean isAllSuperclasses) {
        this.clazz = clazz;
        this.isAllSuperclasses = isAllSuperclasses;
    }

    public List<Property> getAttributes() {
        if (this.attributes == null) {
            this.fillPropertyLists();
        }
        return this.attributes;
    }

    public List<Property> getAssociationEnds() {
        if (this.associationEnds == null) {
            this.fillPropertyLists();
        }
        return this.associationEnds;
    }

    public Property getForName(String name) {
        if (name != null) {
            for (Property property : this.getAttributes()) {
                if (!name.equals(property.getName())) continue;
                return property;
            }
            for (Property property : this.getAssociationEnds()) {
                if (!name.equals(property.getName())) continue;
                return property;
            }
        }
        return null;
    }

    private void fillPropertyLists() {
        this.attributes = new ArrayList<Property>();
        this.associationEnds = new ArrayList<Property>();
        this.addProperties(this.clazz);
        if (this.isSorted) {
            Collections.sort(this.attributes, new NamedElementComparator());
            Collections.sort(this.associationEnds, new NamedElementComparator());
        }
    }

    private boolean hasBeenRedefined(Property property) {
        if (this.attributes != null) {
            for (Property attribute : this.attributes) {
                for (Property redefinedProperty : attribute.getRedefinedProperties()) {
                    if (!property.equals(redefinedProperty)) continue;
                    return true;
                }
            }
        }
        if (this.associationEnds != null) {
            for (Property attribute : this.associationEnds) {
                for (Property redefinedProperty : attribute.getRedefinedProperties()) {
                    if (!property.equals(redefinedProperty)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void addProperties(Class aClass) {
        ArrayList ownedAttributes = new ArrayList(aClass.getOwnedAttributes());
        Collections.reverse(ownedAttributes);
        for (Property property : ownedAttributes) {
            if (property.getAssociation() != null && this.isOmitAssociations || this.hasBeenRedefined(property) || this.getForName(property.getName()) != null) continue;
            if (property.getAssociation() == null) {
                this.attributes.add(0, property);
                continue;
            }
            this.associationEnds.add(0, property);
        }
        if (this.isAllSuperclasses) {
            for (Classifier general : aClass.getGenerals()) {
                if (!(general instanceof Class)) continue;
                this.addProperties((Class)general);
            }
        }
    }
}

