/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.UpdateConfig;

final class ImmutableUpdateConfig
implements UpdateConfig {
    @Nullable
    private final Long parallelism;
    @Nullable
    private final Long delay;
    @Nullable
    private final String failureAction;
    @Nullable
    private final String order;

    private ImmutableUpdateConfig(@Nullable Long parallelism, @Nullable Long delay, @Nullable String failureAction, @Nullable String order) {
        this.parallelism = parallelism;
        this.delay = delay;
        this.failureAction = failureAction;
        this.order = order;
    }

    @Override
    @JsonProperty(value="Parallelism")
    @Nullable
    public Long parallelism() {
        return this.parallelism;
    }

    @Override
    @JsonProperty(value="Delay")
    @Nullable
    public Long delay() {
        return this.delay;
    }

    @Override
    @JsonProperty(value="FailureAction")
    @Nullable
    public String failureAction() {
        return this.failureAction;
    }

    @Override
    @JsonProperty(value="Order")
    @Nullable
    public String order() {
        return this.order;
    }

    public final ImmutableUpdateConfig withParallelism(@Nullable Long value) {
        if (Objects.equals(this.parallelism, value)) {
            return this;
        }
        return new ImmutableUpdateConfig(value, this.delay, this.failureAction, this.order);
    }

    public final ImmutableUpdateConfig withDelay(@Nullable Long value) {
        if (Objects.equals(this.delay, value)) {
            return this;
        }
        return new ImmutableUpdateConfig(this.parallelism, value, this.failureAction, this.order);
    }

    public final ImmutableUpdateConfig withFailureAction(@Nullable String value) {
        if (Objects.equals(this.failureAction, value)) {
            return this;
        }
        return new ImmutableUpdateConfig(this.parallelism, this.delay, value, this.order);
    }

    public final ImmutableUpdateConfig withOrder(@Nullable String value) {
        if (Objects.equals(this.order, value)) {
            return this;
        }
        return new ImmutableUpdateConfig(this.parallelism, this.delay, this.failureAction, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUpdateConfig && this.equalTo(0, (ImmutableUpdateConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableUpdateConfig another) {
        return Objects.equals(this.parallelism, another.parallelism) && Objects.equals(this.delay, another.delay) && Objects.equals(this.failureAction, another.failureAction) && Objects.equals(this.order, another.order);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parallelism);
        h += (h << 5) + Objects.hashCode(this.delay);
        h += (h << 5) + Objects.hashCode(this.failureAction);
        h += (h << 5) + Objects.hashCode(this.order);
        return h;
    }

    public String toString() {
        return "UpdateConfig{parallelism=" + this.parallelism + ", delay=" + this.delay + ", failureAction=" + this.failureAction + ", order=" + this.order + "}";
    }

    public static ImmutableUpdateConfig copyOf(UpdateConfig instance) {
        if (instance instanceof ImmutableUpdateConfig) {
            return (ImmutableUpdateConfig)instance;
        }
        return ImmutableUpdateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private Long parallelism;
        private Long delay;
        private String failureAction;
        private String order;

        private Builder() {
        }

        public final Builder from(UpdateConfig instance) {
            String orderValue;
            String failureActionValue;
            Long delayValue;
            Objects.requireNonNull(instance, "instance");
            Long parallelismValue = instance.parallelism();
            if (parallelismValue != null) {
                this.parallelism(parallelismValue);
            }
            if ((delayValue = instance.delay()) != null) {
                this.delay(delayValue);
            }
            if ((failureActionValue = instance.failureAction()) != null) {
                this.failureAction(failureActionValue);
            }
            if ((orderValue = instance.order()) != null) {
                this.order(orderValue);
            }
            return this;
        }

        @JsonProperty(value="Parallelism")
        public final Builder parallelism(@Nullable Long parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        @JsonProperty(value="Delay")
        public final Builder delay(@Nullable Long delay) {
            this.delay = delay;
            return this;
        }

        @JsonProperty(value="FailureAction")
        public final Builder failureAction(@Nullable String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @JsonProperty(value="Order")
        public final Builder order(@Nullable String order) {
            this.order = order;
            return this;
        }

        public ImmutableUpdateConfig build() {
            return new ImmutableUpdateConfig(this.parallelism, this.delay, this.failureAction, this.order);
        }
    }
}

