/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Platform;

final class ImmutablePlatform
implements Platform {
    @Nullable
    private final String architecture;
    private final String os;

    private ImmutablePlatform(@Nullable String architecture, String os) {
        this.architecture = architecture;
        this.os = os;
    }

    @Override
    @JsonProperty(value="Architecture")
    @Nullable
    public String architecture() {
        return this.architecture;
    }

    @Override
    @JsonProperty(value="OS")
    public String os() {
        return this.os;
    }

    public final ImmutablePlatform withArchitecture(@Nullable String value) {
        if (Objects.equals(this.architecture, value)) {
            return this;
        }
        return new ImmutablePlatform(value, this.os);
    }

    public final ImmutablePlatform withOs(String value) {
        String newValue = Objects.requireNonNull(value, "os");
        if (this.os.equals(newValue)) {
            return this;
        }
        return new ImmutablePlatform(this.architecture, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePlatform && this.equalTo(0, (ImmutablePlatform)another);
    }

    private boolean equalTo(int synthetic, ImmutablePlatform another) {
        return Objects.equals(this.architecture, another.architecture) && this.os.equals(another.os);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.architecture);
        h += (h << 5) + this.os.hashCode();
        return h;
    }

    public String toString() {
        return "Platform{architecture=" + this.architecture + ", os=" + this.os + "}";
    }

    public static ImmutablePlatform copyOf(Platform instance) {
        if (instance instanceof ImmutablePlatform) {
            return (ImmutablePlatform)instance;
        }
        return ImmutablePlatform.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_OS = 1L;
        private long initBits = 1L;
        private String architecture;
        private String os;

        private Builder() {
        }

        public final Builder from(Platform instance) {
            Objects.requireNonNull(instance, "instance");
            String architectureValue = instance.architecture();
            if (architectureValue != null) {
                this.architecture(architectureValue);
            }
            this.os(instance.os());
            return this;
        }

        @JsonProperty(value="Architecture")
        public final Builder architecture(@Nullable String architecture) {
            this.architecture = architecture;
            return this;
        }

        @JsonProperty(value="OS")
        public final Builder os(String os) {
            this.os = Objects.requireNonNull(os, "os");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePlatform build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePlatform(this.architecture, this.os);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("os");
            }
            return "Cannot build Platform, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

