/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch.ui.rdt.proxy;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.linuxtools.internal.profiling.launch.ui.rdt.proxy.Activator;
import org.eclipse.linuxtools.internal.profiling.launch.ui.rdt.proxy.Messages;
import org.eclipse.linuxtools.profiling.launch.ui.IRemoteResourceSelectorProxy;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.swt.widgets.Shell;

public class RDTResourceSelectorProxy
implements IRemoteResourceSelectorProxy {
    private URI getEmptyPathURI(String scheme) {
        try {
            return new URI(scheme, null, "/", null);
        }
        catch (URISyntaxException e) {
            Activator.log(4, Messages.RDTResourceSelectorProxy_URI_syntax_error, e);
            return null;
        }
    }

    private URI selectResource(String scheme, String initialPath, String prompt, Shell shell, ResourceType resourceType) {
        URI uri;
        boolean schemeSwitch = false;
        try {
            uri = new URI(initialPath);
            if (!scheme.equals(uri.getScheme())) {
                uri = this.getEmptyPathURI(scheme);
                schemeSwitch = true;
            }
        }
        catch (URISyntaxException e) {
            uri = this.getEmptyPathURI(scheme);
            schemeSwitch = true;
        }
        IRemoteServicesManager sm = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType ct = sm.getConnectionType(uri);
        IRemoteConnection connection = ct.getConnection(uri);
        IRemoteFileService fileService = (IRemoteFileService)connection.getService(IRemoteFileService.class);
        IRemoteUIFileService uiFileService = (IRemoteUIFileService)ct.getService(IRemoteUIFileService.class);
        uiFileService.showConnections(true);
        if (!schemeSwitch) {
            uiFileService.setConnection(connection);
        }
        String selectedPath = null;
        switch (resourceType.ordinal()) {
            case 0: {
                selectedPath = uiFileService.browseFile(shell, prompt, uri.getPath(), 0);
                break;
            }
            case 1: {
                selectedPath = uiFileService.browseDirectory(shell, prompt, uri.getPath(), 0);
                break;
            }
            default: {
                Activator.log(4, Messages.RDTResourceSelectorProxy_unsupported_resourceType + String.valueOf((Object)resourceType));
                return null;
            }
        }
        URI selectedURI = null;
        if (selectedPath != null) {
            connection = uiFileService.getConnection();
            fileService = (IRemoteFileService)connection.getService(IRemoteFileService.class);
            selectedURI = fileService.toURI(selectedPath);
        }
        return selectedURI;
    }

    public URI selectFile(String scheme, String initialPath, String prompt, Shell shell) {
        return this.selectResource(scheme, initialPath, prompt, shell, ResourceType.FILE);
    }

    public URI selectDirectory(String scheme, String initialPath, String prompt, Shell shell) {
        return this.selectResource(scheme, initialPath, prompt, shell, ResourceType.DIRECTORY);
    }

    private static enum ResourceType {
        FILE,
        DIRECTORY;

    }
}

