/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindDescription;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFile;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFunction;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindLine;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindOutput;
import org.eclipse.linuxtools.valgrind.core.ValgrindParserUtils;

public final class CachegrindParser {
    private static final String COLON = ":";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String CMD = "cmd";
    private static final String DESC = "desc";
    private static final String FL = "fl";
    private static final String FN = "fn";
    private static final String EVENTS = "events";
    private static final String SUMMARY = "summary";
    private static final String COMMA = ",";
    protected static CachegrindParser instance;

    private CachegrindParser() {
    }

    public static CachegrindParser getParser() {
        if (instance == null) {
            instance = new CachegrindParser();
        }
        return instance;
    }

    public void parse(CachegrindOutput output, File cgOut) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(cgOut));){
            String line;
            output.setPid(ValgrindParserUtils.parsePID((String)cgOut.getName(), (String)"cachegrind_"));
            CachegrindFile curFl = null;
            CachegrindFunction curFn = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("events:")) {
                    output.setEvents(ValgrindParserUtils.parseStrValue((String)line, (String)": ").split(SPACE));
                    continue;
                }
                if (line.startsWith("cmd:")) continue;
                if (line.startsWith("desc:")) {
                    CachegrindDescription description = this.parseDescription(line);
                    output.addDescription(description);
                    continue;
                }
                if (line.startsWith("fl=")) {
                    curFl = new CachegrindFile(output, ValgrindParserUtils.parseStrValue((String)line, (String)EQUALS));
                    output.addFile(curFl);
                    continue;
                }
                if (line.startsWith("fn=")) {
                    if (curFl != null) {
                        curFn = new CachegrindFunction(curFl, ValgrindParserUtils.parseStrValue((String)line, (String)EQUALS));
                        curFl.addFunction(curFn);
                        continue;
                    }
                    ValgrindParserUtils.fail((String)line);
                    continue;
                }
                if (line.startsWith("summary:")) {
                    long[] summary = this.parseData(line, ValgrindParserUtils.parseStrValue((String)line, (String)": ").split(SPACE));
                    output.setSummary(summary);
                    continue;
                }
                String[] tokens = line.split(SPACE, 2);
                if (ValgrindParserUtils.isNumber((String)tokens[0])) {
                    int lineNo = Integer.parseInt(tokens[0]);
                    long[] data = this.parseData(line, tokens[1].split(SPACE));
                    if (curFn != null) {
                        curFn.addLine(new CachegrindLine(curFn, lineNo, data));
                        continue;
                    }
                    ValgrindParserUtils.fail((String)line);
                    continue;
                }
                ValgrindParserUtils.fail((String)line);
            }
        }
    }

    private long[] parseData(String line, String[] data) throws IOException {
        long[] result = new long[data.length];
        for (int i = 0; i < data.length; ++i) {
            if (!ValgrindParserUtils.isNumber((String)data[i])) {
                ValgrindParserUtils.fail((String)line);
            }
            result[i] = Long.parseLong(data[i]);
        }
        return result;
    }

    private CachegrindDescription parseDescription(String line) throws IOException {
        CachegrindDescription desc = null;
        String[] tokens = line.split(":\\s+");
        if (tokens.length == 3) {
            String name = tokens[1];
            if ((tokens = tokens[2].split(", ")).length == 3) {
                desc = new CachegrindDescription(name);
            } else {
                ValgrindParserUtils.fail((String)line);
            }
        } else {
            ValgrindParserUtils.fail((String)line);
        }
        return desc;
    }
}

