/*******************************************************************************
 *   Copyright (c) 2010 Eteration A.S. and others.
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *      Naci Dai and Murat Yener, Eteration A.S. - Initial API and implementation
 *******************************************************************************/
package org.eclipse.libra.framework.knopflerfish;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.knopflerfish.internal.KnopflerfishConfigurationPublishHelper;
import org.eclipse.wst.server.core.IModule;


public class Knopflerfish31Handler implements IKnopflerfishVersionHandler {

	public IStatus verifyInstallPath(IPath location) {

		File f = location.append("osgi").toFile();
		if (f == null || !f.exists())
			return new Status(IStatus.ERROR, KnopflerfishPlugin.PLUGIN_ID, 0,
					Messages.warningCantReadConfig, null);
		File[] conf = f.listFiles();
		if (conf != null) {
			int size = conf.length;
			for (int i = 0; i < size; i++) {
				if (!f.canRead())
					return new Status(IStatus.WARNING,
							KnopflerfishPlugin.PLUGIN_ID, 0,
							Messages.warningCantReadConfig, null);
			}
		}

		File f2 = location.append("osgi").append("framework.jar").toFile();
		if (f2 == null || !f2.exists())
			return new Status(
					IStatus.ERROR,
					KnopflerfishPlugin.PLUGIN_ID,
					0,
					"Cannot locate framework.jar.  Invalid installation folder",
					null);

		return Status.OK_STATUS;
	}

	public String getFrameworkClass() {
		return "org.knopflerfish.framework.Main";
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public List getFrameworkClasspath(IPath installPath, IPath configPath) {

		List cp = new ArrayList();

		IPath binPath = installPath.append("osgi");
		if (binPath.toFile().exists()) {
			IPath path = binPath.append("framework.jar");
			cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry(path));
		}

		return cp;
	}

	public String[] getFrameworkProgramArguments(IPath configPath, boolean debug,
			boolean starting) {
		return new String[] {
				"-init",
				"-xargs",
				"file:"
						+ configPath.append("osami.xargs").makeAbsolute()
								.toOSString() };
	}

	public String[] getExcludedFrameworkProgramArguments(boolean debug,
			boolean starting) {
		return null;
	}

	public String[] getFrameworkVMArguments(IPath installPath, IPath configPath,
			IPath deployPath, boolean isTestEnv) {

		return new String[] {};
	}

	public IStatus canAddModule(IModule module) {
		String id = module.getModuleType().getId();
		// String version = module.getModuleType().getVersion();
		if ("osami.bundle".equals(id))
			return Status.OK_STATUS;

		return new Status(IStatus.ERROR, KnopflerfishPlugin.PLUGIN_ID, 0,
				Messages.errorNotBundle, null);
	}

	public IStatus prepareFrameworkInstanceDirectory(IPath baseDir) {
		return Status.OK_STATUS;// TomcatVersionHelper.createCatalinaInstanceDirectory(baseDir);
	}

	public IStatus prepareDeployDirectory(IPath deployPath) {

		if (Trace.isTraceEnabled())
			Trace.trace(Trace.FINER, "Creating runtime directory at "
					+ deployPath.toOSString());

		// Prepare a felix directory structure
		File temp = deployPath.append("plugins").toFile();
		if (!temp.exists())
			temp.mkdirs();

		return Status.OK_STATUS;
	}

	public boolean supportsServeModulesWithoutPublish() {
		return true;
	}

	private void writeXargs(IPath installPath, IPath confPath, PrintWriter out,
			KnopflerfishConfigurationPublishHelper publishHelper,
			FrameworkInstanceConfiguration configuration) {

		out.println("#");
		out.println("# Generated by OSAMI Tools");
		out.println("# for Knopflerfish release 3.1.0");
		out.println("# Copyright 2010 eteration a.s.");

		out.println("# load common properties");
		out.println("-xargs file:"
				+ confPath.append("props.xargs").toOSString());

		out.println("# Semicolon seprated list of base URLs for searching (completing)");
		out.println("# bundle URLs in '-install URL' command line options and in the console.");
		out.println("-Dorg.knopflerfish.gosg.jars=file:"
				+ installPath.append("osgi").append("jars").toOSString());

		out.println("-init");


//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("cm/cm_all-3.0.1.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("console/console_all-3.0.1.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("log/log_all-3.0.5.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("event/event_all-3.0.4.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("consoletty/consoletty-3.0.1.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("frameworkcommands/frameworkcommands-3.0.3.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("logcommands/logcommands-3.0.1.jar"));
//		out.println("-istart  file:"+ installPath.append("osgi").append("jars").append("useradmin/useradmin_api-3.0.1.jar"));
		

		out.println("## Basic KF bundles");
		out.println("-initlevel 3");
		String kb[] = publishHelper.getTargetBundlePaths(configuration);
		for (String kernelBundle : kb) {
			out.println("-install file:" + kernelBundle);
		}
		for (String kernelBundle : kb) {
			out.println("-start file:" + kernelBundle);
		}
		out.println("-startlevel 3");
		
//		out.println("## Workspace bundles");
//		String wb[] = publishHelper.getWorkspaceBundlePaths(configuration);
//		out.println("-initlevel 4");
//		for (String workspaceBundle : wb) {
//			out.println("-install file:" + workspaceBundle);
//		}
//		for (String workspaceBundle : wb) {
//			out.println("-start file:" + workspaceBundle);
//		}
//
//		out.println("-startlevel 4");
		
//		wb = publishHelper.getWorkspaceBundlePaths(configuration);
//		for (String workspaceBundle : wb) {
//			out.println("-start "+ workspaceBundle);
//		}
		

		out.println("-launch");
		out.println("");
		out.flush();
	}

	private void writePropsXargs(PrintWriter out,
			KnopflerfishConfigurationPublishHelper publishHelper,
			FrameworkInstanceConfiguration configuration) {

		out.println("#");
		out.println("# Generated by OSAMI Tools");
		out.println("# for Knopflerfish release 3.1.0");
		out.println("# Copyright 2010 eteration a.s.");

		out.println("# Common properties used by different init.xargs files");
		out.println("-Forg.osgi.provisioning.spid=knopflerfish");
		out.println("-Forg.knopflerfish.framework.debug.errors=true");
		out.println("-Forg.knopflerfish.framework.bundlestorage.file.reference=true");
		out.println("-Forg.knopflerfish.startlevel.use=true");

		out.println("# Web server properties");
		out.println("-Forg.knopflerfish.http.dnslookup=false");
		out.println("-Forg.osgi.service.http.port=8080");

		out.println("# Web server properties");
		out.println("-Forg.knopflerfish.http.dnslookup=false");
		out.println("-Forg.osgi.service.http.port=8080");

		out.println("# Log service properties");
		out.println("-Forg.knopflerfish.log.out=false");
		out.println("-Forg.knopflerfish.log.level=info");
		out.println("-Forg.knopflerfish.log.grabio=true");
		out.println("-Forg.knopflerfish.log.file=true");
		out.println("-Forg.knopflerfish.log.memory.size=250");

		out.println("#consoletelnet properties");
		out.println("-Forg.knopflerfish.consoletelnet.user=admin");
		out.println("-Forg.knopflerfish.consoletelnet.pwd=admin");
		out.println("-Forg.knopflerfish.consoletelnet.port=2323");
		out.flush();

	}

	public void prepareFrameworkConfigurationFile(IPath installPath,
			IPath confDir,
			KnopflerfishConfigurationPublishHelper publishHelper,
			FrameworkInstanceConfiguration configuration) {

		OutputStream out = null;
		try {
			out = new FileOutputStream(confDir.append("osami.xargs")
					.makeAbsolute().toFile());

			PrintWriter pw = new PrintWriter(out);
			writeXargs(installPath, confDir, pw, publishHelper, configuration);
			out.flush();
			out.close();

			out = new FileOutputStream(confDir.append("props.xargs")
					.makeAbsolute().toFile());
			pw = new PrintWriter(out);
			writePropsXargs(pw, publishHelper, configuration);
			out.close();
			out = null;

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (IOException e) {
				}
		}
	}
}
