/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.stub;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.eclipse.keyple.plugin.stub.StubReader;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.eclipse.keyple.seproxy.plugin.AbstractThreadedObservablePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StubPlugin
extends AbstractThreadedObservablePlugin {
    private static final StubPlugin uniqueInstance = new StubPlugin();
    private static final Logger logger = LoggerFactory.getLogger(StubPlugin.class);
    private final Map<String, String> parameters = new HashMap<String, String>();
    private static SortedSet<String> connectedStubNames = new ConcurrentSkipListSet<String>();

    private StubPlugin() {
        super("StubPlugin");
        this.threadWaitTimeout = 50L;
    }

    public static StubPlugin getInstance() {
        return uniqueInstance;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public void plugStubReader(String name, Boolean synchronous) {
        logger.info("Plugging a new reader with name " + name);
        Boolean exist = connectedStubNames.contains(name);
        if (!exist.booleanValue() && synchronous.booleanValue()) {
            this.readers.add(new StubReader(name));
        }
        connectedStubNames.add(name);
        if (exist.booleanValue()) {
            logger.error("Reader with name " + name + " was already plugged");
        }
    }

    public void plugStubReaders(Set<String> names, Boolean synchronous) {
        logger.debug("Plugging {} readers ..", (Object)names.size());
        HashSet<String> newNames = new HashSet<String>(names);
        newNames.removeAll(connectedStubNames);
        logger.debug("New readers to be created #{}", (Object)newNames.size());
        if (newNames.size() > 0) {
            if (synchronous.booleanValue()) {
                ArrayList<StubReader> newReaders = new ArrayList<StubReader>();
                for (String name : newNames) {
                    newReaders.add(new StubReader(name));
                }
                this.readers.addAll(newReaders);
            }
            connectedStubNames.addAll(names);
        } else {
            logger.error("All {} readers were already plugged", (Object)names.size());
        }
    }

    public void unplugStubReader(String name, Boolean synchronous) throws KeypleReaderException, InterruptedException {
        if (!connectedStubNames.contains(name)) {
            logger.warn("unplugStubReader() No reader found with name {}", (Object)name);
        } else {
            if (synchronous.booleanValue()) {
                connectedStubNames.remove(name);
                this.readers.remove(this.getReader(name));
            } else {
                connectedStubNames.remove(name);
            }
            logger.info("Unplugged reader with name {}, connectedStubNames size {}", (Object)name, (Object)connectedStubNames.size());
        }
    }

    public void unplugStubReaders(Set<String> names, Boolean synchronous) {
        logger.info("Unplug {} stub readers", (Object)names.size());
        logger.debug("Unplug stub readers.. {}", names);
        ArrayList<StubReader> readersToDelete = new ArrayList<StubReader>();
        for (String name : names) {
            try {
                readersToDelete.add((StubReader)this.getReader(name));
            }
            catch (KeypleReaderNotFoundException e) {
                logger.warn("unplugStubReaders() No reader found with name {}", (Object)name);
            }
        }
        connectedStubNames.removeAll(names);
        if (synchronous.booleanValue()) {
            this.readers.removeAll(readersToDelete);
        }
    }

    protected SortedSet<String> fetchNativeReadersNames() {
        if (connectedStubNames.isEmpty()) {
            logger.trace("No reader available.");
        }
        return connectedStubNames;
    }

    protected SortedSet<AbstractObservableReader> initNativeReaders() throws KeypleReaderException {
        ConcurrentSkipListSet<AbstractObservableReader> newNativeReaders = new ConcurrentSkipListSet<AbstractObservableReader>();
        return newNativeReaders;
    }

    protected AbstractObservableReader fetchNativeReader(String name) {
        for (AbstractObservableReader reader : this.readers) {
            if (!reader.getName().equals(name)) continue;
            return reader;
        }
        StubReader reader = null;
        if (connectedStubNames.contains(name)) {
            reader = new StubReader(name);
        }
        return reader;
    }
}

