/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.jwt.meta.model.core.ModelElement;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.core.ModelElementFigure;
import org.eclipse.jwt.we.figures.core.NamedElementFigure;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.parts.EditPartAdapter;
import org.eclipse.jwt.we.parts.core.doubleClick.DoubleClickHandler;
import org.eclipse.jwt.we.parts.internal.EditPartAdapterSupport;

public class GraphicalModelElementEditPart
extends AbstractGraphicalEditPart
implements EditPartAdapterSupport {
    private static final Logger logger = Logger.getLogger(GraphicalModelElementEditPart.class);
    protected WEEditor weeditor;
    private EditPartAdapter adapter = new EditPartAdapter(this);

    public Adapter getAdapter() {
        return this.adapter;
    }

    public Class getModelClass() {
        return ModelElement.class;
    }

    public IImageFactory getImageFactory() {
        return Plugin.getInstance().getFactoryRegistry().getImageFactory(Views.getInstance().getSelectedView());
    }

    public AdapterFactory getModelAdapterFactory() {
        return this.adapter.getModelAdapterFactory();
    }

    protected IFigure createFigure() {
        IFigure figure = Plugin.getInstance().getFactoryRegistry().getFigureFactory().createFigure(this.getModelClass());
        if (figure instanceof NamedElementFigure) {
            ((NamedElementFigure)figure).setImageFactory(this.getImageFactory());
        }
        return figure;
    }

    public IFigure getContentPane() {
        if (this.getFigure() != null && this.getFigure() instanceof ModelElementFigure) {
            return ((ModelElementFigure)this.getFigure()).getContentPane();
        }
        return super.getContentPane();
    }

    protected void createEditPolicies() {
    }

    public void notifyChanged(Notification notification) {
    }

    public Object getAdapter(Class key) {
        logger.enter(key.getName());
        if (EditingDomain.class.isAssignableFrom(key)) {
            return this.adapter.getEmfEditingDomain();
        }
        return super.getAdapter(key);
    }

    protected void refreshSourceConnections() {
        if (this.getParent() == null) {
            return;
        }
        super.refreshSourceConnections();
    }

    protected void refreshTargetConnections() {
        if (this.getParent() == null) {
            return;
        }
        super.refreshTargetConnections();
    }

    protected String getDebugMessage(Request request) {
        if (logger.isDebugEnabled()) {
            return "(" + this.getModelClass().getSimpleName() + ") " + request.getClass().getSimpleName() + ": " + request.getType().toString();
        }
        return null;
    }

    public void performRequest(Request request) {
        logger.debug(this.getDebugMessage(request));
        super.performRequest(request);
        if (request instanceof SelectionRequest && request.getType().equals("open")) {
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jwt.we.doubleclick");
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement extension = extensions[i];
                try {
                    DoubleClickHandler factory = (DoubleClickHandler)extension.createExecutableExtension("DoubleClickHandler");
                    if (factory.appliesTo((ModelElement)this.getModel())) {
                        factory.processDoubleClick((ModelElement)this.getModel(), this.getViewer().getEditDomain());
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass()).warning("Could not process double-click extension", ex);
                }
                ++i;
            }
        }
    }

    public Command getCommand(Request request) {
        logger.debug(this.getDebugMessage(request));
        return super.getCommand(request);
    }

    public WEEditor getWEEditor() {
        if (this.weeditor == null) {
            this.weeditor = GeneralHelper.getInstanceForEObject((EObject)this.getModel());
        }
        return this.weeditor;
    }
}

