/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.dnd.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.core.Model;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.commands.editdomain.GefEmfEditingDomain;
import org.eclipse.jwt.we.editors.dnd.internal.ApplicationDropListenerFactory;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ViewPackage;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.TreeItem;

public class JavaApplicationTreeDropListener
implements TransferDropTargetListener {
    private Model model;
    private GefEmfEditingDomain editingDomain;

    public JavaApplicationTreeDropListener(Model model, GefEmfEditingDomain editingDomain) {
        this.model = model;
        this.editingDomain = editingDomain;
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        String[] data = (String[])event.data;
        if (data == null) {
            return true;
        }
        return data.length == 1 && data[0].endsWith(".java");
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(final DropTargetEvent event) {
        final Application app = ApplicationDropListenerFactory.createApplication((String[])event.data);
        if (app == null) {
            return;
        }
        this.editingDomain.getCommandStack().execute(new Command(){

            public void execute() {
                Object item = null;
                item = event.item != null ? (EObject)((TreeItem)event.item).getData() : JavaApplicationTreeDropListener.this.model;
                if (item instanceof Package) {
                    Package pack = (Package)item;
                    pack.getElements().add((Object)app);
                } else if (item instanceof Activity) {
                    JavaApplicationTreeDropListener.this.model.getElements().add((Object)app);
                    Reference ref = (Reference)ViewPackage.eINSTANCE.getEFactoryInstance().create(ViewPackage.Literals.REFERENCE);
                    ref.setReference((ReferenceableElement)app);
                    ref.setContainedIn((Scope)((Activity)item));
                }
            }
        });
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

