/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.LayoutData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveLayoutDataCommand
extends RemoveCommand {
    private Map<LayoutData, GraphicalElement> elementMap;
    private Map<LayoutData, Diagram> diagramMap;

    public RemoveLayoutDataCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, owner, feature, collection);
    }

    public void doExecute() {
        this.elementMap = new HashMap<LayoutData, GraphicalElement>();
        this.diagramMap = new HashMap<LayoutData, Diagram>();
        for (LayoutData ld : this.collection) {
            if (ld.eContainer() != null) {
                this.diagramMap.put(ld, (Diagram)ld.eContainer());
                ((Diagram)ld.eContainer()).getLayoutData().remove((Object)ld);
            }
            if (ld.getDescribesElement() == null) continue;
            this.elementMap.put(ld, ld.getDescribesElement());
            ld.setDescribesElement(null);
        }
    }

    public void doRedo() {
        for (LayoutData ld : this.collection) {
            if (ld.eContainer() != null) {
                ((Diagram)ld.eContainer()).getLayoutData().remove((Object)ld);
            }
            if (ld.getDescribesElement() == null) continue;
            ld.setDescribesElement(null);
        }
    }

    public void doUndo() {
        for (Map.Entry<LayoutData, GraphicalElement> entry : this.elementMap.entrySet()) {
            entry.getKey().setDescribesElement(entry.getValue());
            this.diagramMap.get(entry.getKey()).getLayoutData().add((Object)entry.getKey());
        }
    }

    public void doDispose() {
        super.doDispose();
        this.elementMap.clear();
        this.diagramMap.clear();
    }
}

