/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.template;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.gef.commands.Command;
import org.eclipse.jwt.meta.commands.interfaces.IInterruptibleCommand;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.we.model.view.Diagram;

public class ImportTemplateCommand
extends Command
implements IInterruptibleCommand {
    private ArrayList packages = new ArrayList();
    private ArrayList elements = new ArrayList();
    private ArrayList comments = new ArrayList();
    private ArrayList references = new ArrayList();
    private ArrayList referenceedges = new ArrayList();
    private ArrayList layoutdatas = new ArrayList();
    private Package targetModel;
    private Diagram targetDiagram;

    public ImportTemplateCommand(Package targetModel, Diagram targetDiagram, Package templateModel, Diagram templateDiagram) {
        super("Import Template");
        this.packages.addAll(templateModel.getSubpackages());
        this.elements.addAll(templateModel.getElements());
        this.comments.addAll(templateModel.getOwnedComment());
        if (templateDiagram != null) {
            this.references.addAll(templateDiagram.getReferences());
            this.referenceedges.addAll(templateDiagram.getReferenceEdges());
            this.layoutdatas.addAll(templateDiagram.getLayoutData());
        }
        this.targetModel = targetModel;
        this.targetDiagram = targetDiagram;
    }

    public boolean checkIfCommandCanBeExecuted() {
        return true;
    }

    public void execute() {
        this.targetModel.getSubpackages().addAll((Collection)this.packages);
        this.mergePackages(this.targetModel);
        this.targetModel.getElements().addAll((Collection)this.elements);
        this.targetModel.getOwnedComment().addAll((Collection)this.comments);
        if (this.targetDiagram != null) {
            this.targetDiagram.getReferences().addAll((Collection)this.references);
            this.targetDiagram.getReferenceEdges().addAll((Collection)this.referenceedges);
            this.targetDiagram.getLayoutData().addAll((Collection)this.layoutdatas);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.targetModel.getSubpackages().removeAll((Collection)this.packages);
        this.targetModel.getElements().removeAll((Collection)this.elements);
        this.targetModel.getOwnedComment().removeAll((Collection)this.comments);
        if (this.targetDiagram != null) {
            this.targetDiagram.getReferences().removeAll((Collection)this.references);
            this.targetDiagram.getReferenceEdges().removeAll((Collection)this.referenceedges);
            this.targetDiagram.getLayoutData().removeAll((Collection)this.layoutdatas);
        }
    }

    private void mergePackages(Package superPackage) {
        ArrayList<Package> setOfPackagesToRemove = new ArrayList<Package>();
        int i = 0;
        while (i < superPackage.getSubpackages().size()) {
            if (i < superPackage.getSubpackages().size() - 1) {
                int j = i + 1;
                while (j < superPackage.getSubpackages().size()) {
                    if (((Package)superPackage.getSubpackages().get(i)).getName().equals(((Package)superPackage.getSubpackages().get(j)).getName())) {
                        ((Package)superPackage.getSubpackages().get(i)).getSubpackages().addAll((Collection)((Package)superPackage.getSubpackages().get(j)).getSubpackages());
                        ((Package)superPackage.getSubpackages().get(i)).getElements().addAll((Collection)((Package)superPackage.getSubpackages().get(j)).getElements());
                        setOfPackagesToRemove.add((Package)superPackage.getSubpackages().get(j));
                    }
                    ++j;
                }
            }
            this.mergePackages((Package)superPackage.getSubpackages().get(i));
            ++i;
        }
        superPackage.getSubpackages().removeAll(setOfPackagesToRemove);
    }
}

