/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.clipboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.core.GraphicalElement;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.meta.model.processes.ActivityLinkNode;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.meta.model.processes.StructuredActivityNode;
import org.eclipse.jwt.we.commands.clipboard.StrictCompoundCommandPessimistic;
import org.eclipse.jwt.we.commands.clipboard.WECopyToClipboardCommand;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;
import org.eclipse.jwt.we.model.view.LayoutData;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;

public class WEPasteFromClipboardCommand
extends PasteFromClipboardCommand {
    private Collection clipboardComplete;
    private Collection clipboardWithoutDiagramData;
    private Collection clipboardLayoutData;
    private Collection clipboardReferences;
    private Collection clipboardReferenceEdges;
    private WEEditor weeditor;

    public WEPasteFromClipboardCommand(WEEditor weeditor, EditingDomain domain, Object owner, Object feature, int index, boolean optimize) {
        super(domain, owner, feature, index, optimize);
        this.weeditor = weeditor;
    }

    protected boolean prepare() {
        this.clipboardComplete = new ArrayList();
        this.clipboardWithoutDiagramData = new ArrayList();
        this.clipboardLayoutData = new ArrayList();
        this.clipboardReferences = new ArrayList();
        this.clipboardReferenceEdges = new ArrayList();
        if (this.domain.getClipboard() != null) {
            for (Object object : this.domain.getClipboard()) {
                if (object instanceof LayoutData) {
                    this.clipboardLayoutData.add(object);
                    continue;
                }
                if (object instanceof Reference) {
                    this.clipboardReferences.add(object);
                    continue;
                }
                if (object instanceof ReferenceEdge) {
                    this.clipboardReferenceEdges.add(object);
                    continue;
                }
                this.clipboardWithoutDiagramData.add(object);
            }
            this.clipboardComplete.addAll(this.domain.getClipboard());
            this.domain.setClipboard(new ArrayList(this.clipboardWithoutDiagramData));
        }
        boolean result = true;
        if (this.clipboardWithoutDiagramData.size() > 0) {
            result = super.prepare();
        } else {
            this.command = null;
        }
        StrictCompoundCommandPessimistic newCommand = new StrictCompoundCommandPessimistic();
        if (this.clipboardLayoutData.size() > 0) {
            Command addCommandLayoutData = AddCommand.create((EditingDomain)this.domain, (Object)EMFHelper.getDiagram(this.weeditor), (Object)1, (Collection)this.clipboardLayoutData);
            newCommand.append(addCommandLayoutData);
        }
        if (this.clipboardReferences.size() > 0) {
            Command addCommandReferences = AddCommand.create((EditingDomain)this.domain, (Object)EMFHelper.getDiagram(this.weeditor), (Object)2, (Collection)this.clipboardReferences);
            newCommand.append(addCommandReferences);
        }
        if (this.clipboardReferenceEdges.size() > 0) {
            Command addCommandReferenceEdges = AddCommand.create((EditingDomain)this.domain, (Object)EMFHelper.getDiagram(this.weeditor), (Object)3, (Collection)this.clipboardReferenceEdges);
            newCommand.append(addCommandReferenceEdges);
        }
        if (this.command != null) {
            newCommand.append((Command)this.command);
        }
        this.command = newCommand;
        this.domain.setClipboard(new ArrayList(this.clipboardComplete));
        return result && this.clipboardComplete.size() > 0;
    }

    public void doRedo() {
        super.doRedo();
        WECopyToClipboardCommand copyCommand = new WECopyToClipboardCommand(this.weeditor, this.domain, this.clipboardComplete);
        if (copyCommand.canExecute()) {
            copyCommand.execute();
        }
    }

    public void doUndo() {
        super.doUndo();
        this.domain.setClipboard(new ArrayList(this.clipboardComplete));
    }

    public void doExecute() {
        if (this.domain.getClipboard() != null) {
            this.clipboardComplete.clear();
            this.clipboardComplete.addAll(this.domain.getClipboard());
            this.domain.setClipboard(new ArrayList(this.clipboardWithoutDiagramData));
        }
        super.doExecute();
        WECopyToClipboardCommand copyCommand = new WECopyToClipboardCommand(this.weeditor, this.domain, this.clipboardComplete);
        if (copyCommand.canExecute()) {
            copyCommand.execute();
        }
        for (Map.Entry entry : EcoreUtil.ExternalCrossReferencer.find((Collection)this.clipboardComplete).entrySet()) {
            for (EStructuralFeature.Setting setting : (Collection)entry.getValue()) {
                if (setting.getEObject() instanceof Reference && entry.getKey() instanceof ReferenceableElement || setting.getEObject() instanceof ActivityLinkNode && entry.getKey() instanceof Activity) continue;
                if (setting.getEStructuralFeature().isMany()) {
                    ((Collection)setting.getEObject().eGet(setting.getEStructuralFeature())).remove(entry.getKey());
                    continue;
                }
                setting.getEObject().eSet(setting.getEStructuralFeature(), null);
            }
        }
        for (EObject object : this.clipboardComplete) {
            if (object instanceof Reference) {
                ((Reference)object).setContainedIn((Scope)this.owner);
                continue;
            }
            if (!(object instanceof ReferenceEdge)) continue;
            ((ReferenceEdge)object).setContainedIn((Scope)this.owner);
        }
        if (this.owner instanceof StructuredActivityNode) {
            GraphicalElement graphicalElement;
            int x = 32000;
            int y = 32000;
            for (EObject object : this.clipboardComplete) {
                if (!(object instanceof GraphicalElement)) continue;
                graphicalElement = (GraphicalElement)object;
                x = Math.min(x, LayoutDataManager.getX(this.weeditor, graphicalElement));
                y = Math.min(y, LayoutDataManager.getY(this.weeditor, graphicalElement));
            }
            x -= 15;
            y -= 15;
            for (EObject object : this.clipboardComplete) {
                if (!(object instanceof GraphicalElement)) continue;
                graphicalElement = (GraphicalElement)object;
                LayoutDataManager.setX(this.weeditor, graphicalElement, LayoutDataManager.getX(this.weeditor, graphicalElement) - x);
                LayoutDataManager.setY(this.weeditor, graphicalElement, LayoutDataManager.getY(this.weeditor, graphicalElement) - y);
            }
        } else {
            for (EObject object : this.clipboardComplete) {
                if (!(object instanceof GraphicalElement)) continue;
                GraphicalElement graphicalElement = (GraphicalElement)object;
                LayoutDataManager.setX(this.weeditor, graphicalElement, LayoutDataManager.getX(this.weeditor, graphicalElement) + 15);
                LayoutDataManager.setY(this.weeditor, graphicalElement, LayoutDataManager.getY(this.weeditor, graphicalElement) + 15);
            }
        }
        if (this.weeditor.getCurrentActivitySheet() != null) {
            this.weeditor.getCurrentActivitySheet().refreshEditorSheet();
        }
    }

    public Collection elementsToSelect() {
        ArrayList elementsToSelect = new ArrayList();
        elementsToSelect.addAll(this.command.getResult());
        elementsToSelect.addAll(this.clipboardReferences);
        return elementsToSelect;
    }
}

