/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewbpmn.figures.processes;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;

public class EllipseBorder
extends LineBorder {
    public EllipseBorder(int width) {
        super(ColorConstants.black, width);
    }

    public Insets getInsets(IFigure figure) {
        Dimension bounds = figure.getSize();
        int i = (int)Math.ceil((double)bounds.width / 2.0 - (double)(bounds.width - this.getWidth()) / 4.0 * Math.sqrt(2.0));
        return new Insets(i);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(EllipseBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --EllipseBorder.tempRect.width;
            --EllipseBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        if (PreferenceReader.appearanceShadowVisible.get()) {
            EllipseBorder.tempRect.height -= 4;
            EllipseBorder.tempRect.width -= 4;
            EllipseBorder.tempRect.x += 2;
            EllipseBorder.tempRect.y += 2;
            Rectangle shadowRectangle = new Rectangle(tempRect);
            shadowRectangle.x += 3;
            shadowRectangle.y += 3;
            graphics.setAlpha(50);
            graphics.setBackgroundColor(PreferenceReader.appearanceShadowColor.get());
            graphics.fillOval(shadowRectangle);
            graphics.setAlpha(255);
            graphics.setBackgroundColor(figure.getBackgroundColor());
            ++EllipseBorder.tempRect.width;
            ++EllipseBorder.tempRect.height;
            graphics.fillOval(tempRect);
            --EllipseBorder.tempRect.width;
            --EllipseBorder.tempRect.height;
        }
        graphics.drawOval(tempRect);
    }
}

