/**
 * File:    TransformationRegistry.java
 * Created: 26.02.2008
 *
 *
/*******************************************************************************
 * Copyright (c) 2008  Open Wide (www.openwide.fr)
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Mickael Istria, Open Wide, Lyon, France
 *      - Creation and implementation
 *******************************************************************************/
package org.eclipse.jwt.transformations.base.init;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jwt.transformations.api.TransformationService;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TransformationRegistry {
	private Map<String, TransformationService> transformations;
	private static TransformationRegistry instance = null;
	
	
	public static TransformationRegistry getInstance() {
		if (instance == null)
			instance = new TransformationRegistry();
		return instance;
	}
	
	
	private TransformationRegistry() {
		transformations = new HashMap<String, TransformationService>();
	}
	
	public void addTransformation(String name, TransformationService transformation) {
		if (transformations.put(name, transformation) != null) {
			final Display display = Display.getCurrent();
			final Shell shell = new Shell(display);
			ErrorDialog.openError(shell, TransformationsMessages.transformationAlreadyExists_title, TransformationsMessages.bind(TransformationsMessages.transformationAlreadyExists_details, name), Status.OK_STATUS);
		}

	}
	
	public TransformationService getTransformation(String name) {
		return transformations.get(name);
	}
	
	public Set<String> getTransformationsName() {
		return transformations.keySet();
	}
}
