/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the AlertPromptConfirmation component from the html toolkit.
 * 
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.AlertImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2018-03-14T10:14:19.257Z")
public class AlertPromptConfirmation implements org.eclipse.jubula.toolkit.html.components.AlertPromptConfirmation {
            public AlertPromptConfirmation() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
        pseudoIdentifier.setComponentClassName("html.alert"); //$NON-NLS-1$
        return pseudoIdentifier;
    }
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkText(@NonNull String text,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckText")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkExistence(@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyExists")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(exists)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP inputText(@NonNull String text
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInputText")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(text)
                        .build();
        }
        
        /**
         * 
         * @param type 
         *        the type of interaction
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP setInteractionType(@NonNull String type
        ) throws IllegalArgumentException {
            Validate.notNull(type, "Argument 'type' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInteract")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(type)
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP interact(
        )  {
            
            return new CapBuilder("rcCloseDialog")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .build();
        }
        
} 