/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the AlertPromptConfirmationActionHandler component from the html toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2018-03-14T10:14:19.257Z")
public interface AlertPromptConfirmationActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result checkText(
            @Nullable String text,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param exists 
         *        whether the component is expected to exist or not
         * 
         */
        public Result checkExistence(
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * 
         */
        public Result inputText(
            @Nullable String text
        ) ;
        
        /**
         * 
         * @param type 
         *        the type of interaction
         * 
         */
        public Result setInteractionType(
            @Nullable String type
        ) ;
        
        /**
         * 
         * 
         */
        public Result interact(
        ) ;
        
} 