/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSelectElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class HTMLOptionsCollection
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private HtmlSelect htmlSelect_;

    public HTMLOptionsCollection() {
    }

    public HTMLOptionsCollection(SimpleScriptable parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_SELECT_CLASS_NAME)) {
            return "HTMLSelectElement";
        }
        return super.getClassName();
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_EXCEPTION_FOR_NEGATIVE)) {
                throw Context.reportRuntimeError((String)"Index is negative");
            }
            return Context.getUndefinedValue();
        }
        if (index >= this.htmlSelect_.getOptionSize()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_NULL_FOR_OUTSIDE)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return this.getScriptableFor(this.htmlSelect_.getOption(index));
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, (String)name)) {
            ScriptableObject.putProperty((Scriptable)parent, (String)name, (Object)value);
        } else {
            super.put(name, start, value);
        }
    }

    @Override
    public Object getWithFallback(String name) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_CHILDNODES_PROPERTY) && "childNodes".equals(name)) {
            return NOT_FOUND;
        }
        HTMLSelectElement select = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        return ScriptableObject.getProperty((Scriptable)select, (String)name);
    }

    @JsxFunction
    public Object item(int index) {
        return this.get(index, null);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = option.getDomNodeOrNull();
            if (index >= this.getLength()) {
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
        if (this.getLength() == 1 && !this.htmlSelect_.isMultipleSelectEnabled()) {
            ((HTMLSelectElement)this.htmlSelect_.getScriptObject()).setSelectedIndex(0);
        }
    }

    @JsxGetter
    public int getLength() {
        return this.htmlSelect_.getOptionSize();
    }

    @JsxSetter
    public void setLength(int newLength) {
        if (newLength < 0) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_IGNORE_NEGATIVE_LENGTH)) {
                return;
            }
            throw Context.reportRuntimeError((String)"Length is negative");
        }
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)HTMLParser.getFactory("option").createElement(this.htmlSelect_.getPage(), "option", null);
                this.htmlSelect_.appendOption(option);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_DONT_ADD_EMPTY_TEXT_CHILD_WHEN_EXPANDING)) continue;
                option.appendChild(new DomText(option.getPage(), ""));
            }
        }
    }

    @JsxFunction
    public void add(Object newOptionObject, Object newIndex) {
        int index = this.getLength();
        if (newIndex instanceof Number) {
            index = ((Number)newIndex).intValue();
        }
        this.put(index, null, newOptionObject);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public void remove(int index) {
        if (index < 0) {
            Context.reportRuntimeError((String)("Invalid index: " + index));
        }
        if (index < this.getLength()) {
            this.htmlSelect_.removeOption(index);
        }
    }
}

