/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.swt.graphics.RGB;

public class FormatParser {
    private static final Map<String, String> parameterMapping = ImmutableMap.builder().put((Object)"color", (Object)"org.eclipse.incquery.viewers.format.color").put((Object)"lineColor", (Object)"org.eclipse.incquery.viewers.format.linecolor").put((Object)"textColor", (Object)"org.eclipse.incquery.viewers.format.textcolor").put((Object)"lineWidth", (Object)"org.eclipse.incquery.viewers.format.linewidth").put((Object)"lineStyle", (Object)"org.eclipse.incquery.viewers.format.linestyle").put((Object)"arrowSourceEnd", (Object)"org.eclipse.incquery.viewers.format.arrowsourceend").put((Object)"arrowTargetEnd", (Object)"org.eclipse.incquery.viewers.format.arrowtargetend").build();

    public static FormatSpecification parseFormatAnnotation(PAnnotation format) {
        FormatSpecification specification = new FormatSpecification();
        for (Map.Entry param : format.getAllValues()) {
            FormatParser.parseParameter((String)param.getKey(), param.getValue(), specification);
        }
        return specification;
    }

    private static void parseParameter(String name, Object value, FormatSpecification specification) {
        String key = parameterMapping.get(name);
        if (value instanceof String) {
            specification.setProperty(key, (String)value);
        } else if (value instanceof Integer) {
            specification.setProperty(key, Integer.toString((Integer)value));
        }
    }

    public static RGB parseColor(String colorString) {
        String colorRegexp = "#[A-Fa-f0-9]{6}";
        if (colorString == null || !colorString.matches(colorRegexp)) {
            return null;
        }
        int red = Integer.parseInt(colorString.substring(1, 3), 16);
        int green = Integer.parseInt(colorString.substring(3, 5), 16);
        int blue = Integer.parseInt(colorString.substring(5, 7), 16);
        return new RGB(red, green, blue);
    }
}

