package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.ActionOutputMatch;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.OutputPin;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.actionOutput pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class ActionOutputProcessor implements IMatchProcessor<ActionOutputMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final Action pSource, final OutputPin pTarget);
  
  @Override
  public void process(final ActionOutputMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
