/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.emf;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.scope.IBaseIndex;
import org.eclipse.incquery.runtime.api.scope.IEngineContext;
import org.eclipse.incquery.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseFactory;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.emf.DynamicEMFQueryRuntimeContext;
import org.eclipse.incquery.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.incquery.runtime.emf.EMFQueryRuntimeContext;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.exception.IncQueryException;

class EMFEngineContext
implements IEngineContext {
    private final EMFScope emfScope;
    IncQueryEngine engine;
    Logger logger;
    NavigationHelper navHelper;
    IBaseIndex baseIndex;
    IIndexingErrorListener taintListener;
    private EMFQueryRuntimeContext runtimeContext;

    public EMFEngineContext(EMFScope emfScope, IncQueryEngine engine, IIndexingErrorListener taintListener, Logger logger) {
        this.emfScope = emfScope;
        this.engine = engine;
        this.logger = logger;
        this.taintListener = taintListener;
    }

    public NavigationHelper getNavHelper() throws IncQueryException {
        return this.getNavHelper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigationHelper getNavHelper(boolean ensureInitialized) throws IncQueryException {
        if (this.navHelper == null) {
            try {
                EMFEngineContext eMFEngineContext = this;
                synchronized (eMFEngineContext) {
                    this.navHelper = IncQueryBaseFactory.getInstance().createNavigationHelper(null, this.emfScope.getOptions(), this.logger);
                    this.getBaseIndex().addIndexingErrorListener(this.taintListener);
                }
            }
            catch (IncQueryBaseException e) {
                throw new IncQueryException("Could not create EMF-IncQuery base index", "Could not create base index", e);
            }
            if (ensureInitialized) {
                this.ensureIndexLoaded();
            }
        }
        return this.navHelper;
    }

    private void ensureIndexLoaded() throws IncQueryException {
        try {
            for (Notifier notifier : this.emfScope.getScopeRoots()) {
                this.navHelper.addRoot(notifier);
            }
        }
        catch (IncQueryBaseException incQueryBaseException) {
            throw new IncQueryException("Could not initialize EMF-IncQuery base index", "Could not initialize base index", incQueryBaseException);
        }
    }

    @Override
    public void initializeBackends(IEngineContext.IQueryBackendInitializer initializer) throws IncQueryException {
        try {
            NavigationHelper nh = this.getNavHelper(false);
            if (this.runtimeContext == null) {
                this.runtimeContext = this.emfScope.getOptions().isDynamicEMFMode() ? new DynamicEMFQueryRuntimeContext(nh, this.logger, this.emfScope) : new EMFQueryRuntimeContext(nh, this.logger, this.emfScope);
            }
            initializer.initializeWith(this.runtimeContext);
        }
        finally {
            this.ensureIndexLoaded();
        }
    }

    @Override
    public void dispose() {
        if (this.runtimeContext != null) {
            this.runtimeContext.dispose();
        }
        if (this.navHelper != null) {
            this.navHelper.dispose();
        }
        this.baseIndex = null;
        this.engine = null;
        this.logger = null;
        this.navHelper = null;
    }

    @Override
    public IBaseIndex getBaseIndex() throws IncQueryException {
        if (this.baseIndex == null) {
            NavigationHelper navigationHelper = this.getNavHelper();
            this.baseIndex = new EMFBaseIndexWrapper(navigationHelper);
        }
        return this.baseIndex;
    }
}

