/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.apiimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IMatchUpdateListener;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngineLifecycleListener;
import org.eclipse.incquery.runtime.api.IncQueryEngineManager;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.IncQueryModelUpdateListener;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.base.api.IncQueryBaseFactory;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.EngineTaintListener;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.internal.EMFPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.internal.PatternSanitizer;
import org.eclipse.incquery.runtime.internal.boundary.CallbackNode;
import org.eclipse.incquery.runtime.internal.engine.LifecycleProvider;
import org.eclipse.incquery.runtime.internal.engine.ModelUpdateProvider;
import org.eclipse.incquery.runtime.internal.matcherbuilder.EPMBuilder;
import org.eclipse.incquery.runtime.rete.construction.ReteContainerBuildable;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.matcher.RetePatternMatcher;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class IncQueryEngineImpl
extends AdvancedIncQueryEngine {
    private final IncQueryEngineManager manager;
    private final Notifier emfRoot;
    private final Map<IQuerySpecification<? extends IncQueryMatcher<?>>, IncQueryMatcher<?>> matchers;
    private NavigationHelper baseIndex;
    private boolean wildcardMode;
    private boolean dynamicEMFmode;
    private ReteEngine<Pattern> reteEngine = null;
    private PatternSanitizer sanitizer = null;
    private final LifecycleProvider lifecycleProvider;
    private final ModelUpdateProvider modelUpdateProvider;
    private Logger logger;
    private final int reteThreads = 0;
    private boolean tainted = false;
    private EngineTaintListener taintListener;

    public IncQueryEngineImpl(IncQueryEngineManager manager, Notifier emfRoot, boolean wildcardMode, boolean dynamicEMFmode) throws IncQueryException {
        this.wildcardMode = wildcardMode;
        this.dynamicEMFmode = dynamicEMFmode;
        this.manager = manager;
        this.emfRoot = emfRoot;
        this.matchers = Maps.newHashMap();
        this.lifecycleProvider = new LifecycleProvider(this);
        this.modelUpdateProvider = new ModelUpdateProvider(this);
        if (!(emfRoot instanceof EObject || emfRoot instanceof Resource || emfRoot instanceof ResourceSet)) {
            throw new IncQueryException("Incremental query engine can only be attached on the contents of an EMF EObject, Resource, or ResourceSet. Received instead: " + (emfRoot == null ? "(null)" : emfRoot.getClass().getName()), "Invalid EMF model root");
        }
    }

    @Override
    public Notifier getScope() {
        return this.emfRoot;
    }

    @Override
    public Set<? extends IncQueryMatcher<? extends IPatternMatch>> getCurrentMatchers() {
        return ImmutableSet.copyOf(this.matchers.values());
    }

    @Override
    public <Matcher extends IncQueryMatcher<? extends IPatternMatch>> Matcher getMatcher(IQuerySpecification<Matcher> querySpecification) throws IncQueryException {
        return querySpecification.getMatcher(this);
    }

    @Override
    public <Matcher extends IncQueryMatcher<? extends IPatternMatch>> Matcher getExistingMatcher(IQuerySpecification<Matcher> querySpecification) {
        return (Matcher)this.matchers.get(querySpecification);
    }

    @Override
    public IncQueryMatcher<? extends IPatternMatch> getMatcher(Pattern pattern) throws IncQueryException {
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpecification = QuerySpecificationRegistry.getOrCreateQuerySpecification(pattern);
        return this.getMatcher(querySpecification);
    }

    @Override
    public IncQueryMatcher<? extends IPatternMatch> getMatcher(String patternFQN) throws IncQueryException {
        Pattern pattern = this.getSanitizer().getAdmittedPatternByName(patternFQN);
        if (pattern != null) {
            return this.getMatcher(pattern);
        }
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpecification = QuerySpecificationRegistry.getQuerySpecification(patternFQN);
        if (querySpecification != null) {
            return this.getMatcher(querySpecification);
        }
        throw new IncQueryException(String.format("No matcher could be constructed for the pattern with FQN %s; if the generated matcher class is not available, please access for the first time using getMatcher(Pattern)", patternFQN), "No matcher could be constructed for given pattern FQN.");
    }

    protected NavigationHelper getBaseIndexInternal() throws IncQueryException {
        return this.getBaseIndexInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NavigationHelper getBaseIndexInternal(boolean initNow) throws IncQueryException {
        if (this.baseIndex == null) {
            try {
                IncQueryEngineImpl incQueryEngineImpl = this;
                synchronized (incQueryEngineImpl) {
                    this.baseIndex = IncQueryBaseFactory.getInstance().createNavigationHelper(null, this.wildcardMode, this.dynamicEMFmode, this.getLogger());
                }
            }
            catch (IncQueryBaseException e) {
                throw new IncQueryException("Could not create EMF-IncQuery base index", "Could not create base index", (Exception)((Object)e));
            }
            if (initNow) {
                this.initBaseIndex();
            }
        }
        return this.baseIndex;
    }

    private synchronized void initBaseIndex() throws IncQueryException {
        try {
            this.baseIndex.addRoot(this.getScope());
        }
        catch (IncQueryBaseException e) {
            throw new IncQueryException("Could not initialize EMF-IncQuery base index", "Could not initialize base index", (Exception)((Object)e));
        }
    }

    @Override
    public NavigationHelper getBaseIndex() throws IncQueryException {
        return this.getBaseIndexInternal();
    }

    @Override
    public Logger getLogger() {
        if (this.logger == null) {
            int hash = System.identityHashCode(this);
            this.logger = Logger.getLogger((String)(String.valueOf(IncQueryLoggingUtil.getDefaultLogger().getName()) + "." + hash));
            if (this.logger == null) {
                throw new AssertionError((Object)("Configuration error: unable to create EMF-IncQuery runtime logger for engine " + hash));
            }
            this.taintListener = new SelfTaintListener(this);
            this.logger.addAppender((Appender)this.taintListener);
        }
        return this.logger;
    }

    public void reportMatcherInitialized(IQuerySpecification<?> querySpecification, IncQueryMatcher<?> matcher) {
        if (this.matchers.containsKey(querySpecification)) {
            this.logger.debug((Object)("Pattern " + CorePatternLanguageHelper.getFullyQualifiedName((Pattern)querySpecification.getPattern()) + " already initialized in IncQueryEngine!"));
        } else {
            this.matchers.put(querySpecification, matcher);
            this.lifecycleProvider.matcherInstantiated(matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReteEngine<Pattern> getReteEngine() throws IncQueryException {
        if (this.reteEngine == null) {
            this.getBaseIndexInternal(false);
            EMFPatternMatcherRuntimeContext context = new EMFPatternMatcherRuntimeContext(this, this.baseIndex);
            IncQueryEngineImpl incQueryEngineImpl = this;
            synchronized (incQueryEngineImpl) {
                this.reteEngine = this.buildReteEngineInternal(context);
            }
            this.initBaseIndex();
        }
        return this.reteEngine;
    }

    private ReteEngine<Pattern> buildReteEngineInternal(IPatternMatcherRuntimeContext<Pattern> context) {
        ReteEngine engine = new ReteEngine(context, 0);
        ReteContainerBuildable buildable = new ReteContainerBuildable(engine);
        EPMBuilder builder = new EPMBuilder(buildable, (IPatternMatcherContext<Pattern>)context);
        engine.setBuilder(builder);
        return engine;
    }

    public PatternSanitizer getSanitizer() {
        if (this.sanitizer == null) {
            this.sanitizer = new PatternSanitizer(this.getLogger());
        }
        return this.sanitizer;
    }

    @Override
    public void dispose() {
        if (this.manager != null) {
            throw new UnsupportedOperationException(String.format("Cannot dispose() managed EMF-IncQuery engine. Attempted for notifier %s.", this.emfRoot));
        }
        this.wipe();
        this.lifecycleProvider.engineDisposed();
        try {
            if (this.baseIndex != null) {
                this.baseIndex.dispose();
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.getLogger().warn((Object)"The base index could not be disposed along with the EMF-InQuery engine, as there are still active listeners on it.");
        }
        this.getLogger().removeAppender((Appender)this.taintListener);
    }

    @Override
    public void wipe() {
        if (this.manager != null) {
            throw new UnsupportedOperationException(String.format("Cannot wipe() managed EMF-IncQuery engine. Attempted for notifier %s.", this.emfRoot));
        }
        if (this.reteEngine != null) {
            this.reteEngine.killEngine();
            this.reteEngine = null;
        }
        this.matchers.clear();
        this.sanitizer = null;
        this.lifecycleProvider.engineWiped();
    }

    @Override
    public boolean isTainted() {
        return this.tainted;
    }

    @Override
    public boolean isManaged() {
        return this.manager != null;
    }

    @Override
    public <Match extends IPatternMatch> void addMatchUpdateListener(IncQueryMatcher<Match> matcher, IMatchUpdateListener<? super Match> listener, boolean fireNow) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        Preconditions.checkArgument((matcher.getEngine() == this ? 1 : 0) != 0, (Object)"Cannot register listener for matcher of different engine!");
        Preconditions.checkArgument((this.reteEngine != null ? 1 : 0) != 0, (Object)"Cannot register listener on matcher of disposed engine!");
        final BaseMatcher bm = (BaseMatcher)matcher;
        CallbackNode callbackNode = new CallbackNode<Match>(this.reteEngine.getReteNet().getHeadContainer(), this, listener){

            @Override
            public Match statelessConvert(Tuple t) {
                return bm.newMatch(t.getElements());
            }
        };
        try {
            RetePatternMatcher patternMatcher = this.reteEngine.accessMatcher((Object)matcher.getPattern());
            patternMatcher.connect((Receiver)callbackNode, listener, fireNow);
        }
        catch (RetePatternBuildException e) {
            this.logger.error((Object)("Could not access matcher " + matcher.getPatternName()), (Throwable)e);
        }
    }

    @Override
    public <Match extends IPatternMatch> void removeMatchUpdateListener(IncQueryMatcher<Match> matcher, IMatchUpdateListener<? super Match> listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        Preconditions.checkArgument((matcher.getEngine() == this ? 1 : 0) != 0, (Object)"Cannot remove listener from matcher of different engine!");
        Preconditions.checkArgument((this.reteEngine != null ? 1 : 0) != 0, (Object)"Cannot remove listener from matcher of disposed engine!");
        try {
            RetePatternMatcher patternMatcher = this.reteEngine.accessMatcher((Object)matcher.getPattern());
            patternMatcher.disconnectByTag(listener);
        }
        catch (Exception e) {
            this.logger.error((Object)("Could not access matcher " + matcher.getPatternName()), (Throwable)e);
        }
    }

    @Override
    public void addModelUpdateListener(IncQueryModelUpdateListener listener) {
        this.modelUpdateProvider.addListener(listener);
    }

    @Override
    public void removeModelUpdateListener(IncQueryModelUpdateListener listener) {
        this.modelUpdateProvider.removeListener(listener);
    }

    @Override
    public void addLifecycleListener(IncQueryEngineLifecycleListener listener) {
        this.lifecycleProvider.addListener(listener);
    }

    @Override
    public void removeLifecycleListener(IncQueryEngineLifecycleListener listener) {
        this.lifecycleProvider.removeListener(listener);
    }

    private static class SelfTaintListener
    extends EngineTaintListener {
        WeakReference<IncQueryEngineImpl> iqEngRef;

        public SelfTaintListener(IncQueryEngineImpl iqEngine) {
            this.iqEngRef = new WeakReference<IncQueryEngineImpl>(iqEngine);
        }

        @Override
        public void engineBecameTainted() {
            IncQueryEngineImpl iqEngine = (IncQueryEngineImpl)this.iqEngRef.get();
            iqEngine.tainted = true;
            iqEngine.lifecycleProvider.engineBecameTainted();
        }
    }
}

