/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.network;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.index.AggregatorNode;
import org.eclipse.incquery.runtime.rete.index.DualInputNode;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.IterableIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.recipes.AggregatorRecipe;
import org.eclipse.incquery.runtime.rete.recipes.BetaRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ConstantRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ExpressionEnforcerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.InputRecipe;
import org.eclipse.incquery.runtime.rete.recipes.MultiParentNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.incquery.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.SingleParentNodeRecipe;
import org.eclipse.incquery.runtime.rete.recipes.TransitiveClosureRecipe;
import org.eclipse.incquery.runtime.rete.recipes.UniquenessEnforcerRecipe;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.incquery.runtime.rete.traceability.RecipeTraceInfo;

class ConnectionFactory {
    ReteContainer reteContainer;

    public ConnectionFactory(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
    }

    private boolean isStateful(ReteNodeRecipe recipe) {
        return recipe instanceof ProjectionIndexerRecipe || recipe instanceof AggregatorRecipe || recipe instanceof ExpressionEnforcerRecipe || recipe instanceof TransitiveClosureRecipe || recipe instanceof ProductionRecipe || recipe instanceof UniquenessEnforcerRecipe;
    }

    public void connectToParents(RecipeTraceInfo recipeTrace, Node freshNode) {
        ReteNodeRecipe recipe = recipeTrace.getRecipe();
        if (!(recipe instanceof ConstantRecipe)) {
            if (recipe instanceof InputRecipe) {
                throw new IllegalArgumentException(String.valueOf(ConnectionFactory.class.getSimpleName()) + " not intended for input connection: " + recipe);
            }
            if (recipe instanceof SingleParentNodeRecipe) {
                Receiver receiver = (Receiver)freshNode;
                ReteNodeRecipe parentRecipe = ((SingleParentNodeRecipe)recipe).getParent();
                this.connectToParent(recipe, receiver, parentRecipe);
            } else if (recipe instanceof MultiParentNodeRecipe) {
                Receiver receiver = (Receiver)freshNode;
                EList parentRecipes = ((MultiParentNodeRecipe)recipe).getParents();
                for (ReteNodeRecipe parentRecipe : parentRecipes) {
                    this.connectToParent(recipe, receiver, parentRecipe);
                }
            } else if (recipe instanceof BetaRecipe) {
                DualInputNode beta = (DualInputNode)freshNode;
                ArrayList<RecipeTraceInfo> parentTraces = new ArrayList<RecipeTraceInfo>(recipeTrace.getParentRecipeTraces());
                Slots slots = this.avoidActiveNodeConflict(parentTraces.get(0), parentTraces.get(1));
                beta.connectToIndexers(slots.primary, slots.secondary);
            } else if (recipe instanceof AggregatorRecipe) {
                AggregatorNode aggregator = (AggregatorNode)freshNode;
                AggregatorRecipe aggregatorRecipe = (AggregatorRecipe)recipe;
                aggregator.initializeWith((ProjectionIndexer)this.resolveIndexer((IndexerRecipe)aggregatorRecipe.getParent()));
            }
        }
    }

    private Indexer resolveIndexer(IndexerRecipe indexerRecipe) {
        Address<? extends Node> address = this.reteContainer.getNetwork().getExistingNodeByRecipe((ReteNodeRecipe)indexerRecipe);
        return (Indexer)this.reteContainer.resolveLocal(address);
    }

    private void connectToParent(ReteNodeRecipe recipe, Receiver freshNode, ReteNodeRecipe parentRecipe) {
        Address<? extends Node> parentAddress = this.reteContainer.getNetwork().getExistingNodeByRecipe(parentRecipe);
        Supplier parentSupplier = this.reteContainer.getProvisioner().asSupplier(parentAddress);
        if (freshNode instanceof TransitiveClosureNode) {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            parentSupplier.pullInto(tuples);
            ((TransitiveClosureNode)freshNode).reinitializeWith(tuples);
            this.reteContainer.connect(parentSupplier, freshNode);
        } else if (this.isStateful(recipe)) {
            this.reteContainer.connectAndSynchronize(parentSupplier, freshNode);
        } else {
            this.reteContainer.connect(parentSupplier, freshNode);
        }
    }

    private Slots avoidActiveNodeConflict(RecipeTraceInfo primarySlot, RecipeTraceInfo secondarySlot) {
        Slots result = new Slots(primarySlot, secondarySlot){
            {
                this.primary = (IterableIndexer)ConnectionFactory.this.resolveIndexer((IndexerRecipe)((ProjectionIndexerRecipe)recipeTraceInfo.getRecipe()));
                this.secondary = ConnectionFactory.this.resolveIndexer((IndexerRecipe)recipeTraceInfo2.getRecipe());
            }
        };
        if (this.activeNodeConflict(result.primary, result.secondary)) {
            if (result.secondary instanceof IterableIndexer) {
                result.secondary = this.resolveActiveIndexer(secondarySlot);
            } else {
                result.primary = (IterableIndexer)this.resolveActiveIndexer(primarySlot);
            }
        }
        return result;
    }

    private Indexer resolveActiveIndexer(RecipeTraceInfo inactiveIndexerTrace) {
        RecipeTraceInfo activeIndexerTrace = this.reteContainer.getProvisioner().accessActiveIndexer(inactiveIndexerTrace);
        this.reteContainer.getProvisioner().getOrCreateNodeByRecipe(activeIndexerTrace);
        return this.resolveIndexer((IndexerRecipe)((ProjectionIndexerRecipe)activeIndexerTrace.getRecipe()));
    }

    private boolean activeNodeConflict(Indexer primarySlot, Indexer secondarySlot) {
        return !primarySlot.equals(secondarySlot) && primarySlot.getActiveNode().equals(secondarySlot.getActiveNode());
    }

    private static class Slots {
        IterableIndexer primary;
        Indexer secondary;

        private Slots() {
        }
    }
}

