/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.eval;

import java.util.Map;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.IValueProvider;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.tuple.TupleValueProvider;

public abstract class AbstractEvaluatorNode
extends SingleInputNode {
    protected IPatternMatcherRuntimeContext context;
    protected IExpressionEvaluator evaluator;
    int sourceTupleWidth;
    private Map<String, Integer> parameterPositions;

    protected abstract Tuple tupleFromResult(Tuple var1, Object var2);

    protected abstract String logNodeName();

    public AbstractEvaluatorNode(ReteContainer reteContainer, IPatternMatcherRuntimeContext context, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
        super(reteContainer);
        this.context = context;
        this.evaluator = evaluator;
        this.parameterPositions = parameterPositions;
        this.sourceTupleWidth = sourceTupleWidth;
    }

    protected Object evaluateTerm(Tuple ps) {
        Object result = null;
        try {
            TupleValueProvider tupleParameters = new TupleValueProvider(ps, this.parameterPositions);
            result = this.evaluator.evaluateExpression((IValueProvider)tupleParameters);
        }
        catch (Exception e) {
            this.context.logWarning(String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.logNodeName(), this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), e.getMessage(), e.getClass().getSimpleName(), this), e);
            result = this.errorResult();
        }
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    protected Object errorResult() {
        return null;
    }
}

